/*
 * Decompiled with CFR 0.152.
 */
package com.skjolberg.mockito.soap;

import com.skjolberg.mockito.soap.SoapEndpointRule;
import java.util.List;
import org.junit.rules.ExternalResource;
import org.mockito.Mockito;

public abstract class SoapServiceRule
extends ExternalResource {
    public static SoapServiceRule newInstance() {
        return new SoapEndpointRule();
    }

    public static SoapEndpointRule newInstance(String ... ports) {
        return new SoapEndpointRule(ports);
    }

    public static SoapEndpointRule newInstance(int portRangeStart, int portRangeEnd, String ... properties) {
        return new SoapEndpointRule(portRangeStart, portRangeEnd, properties);
    }

    public abstract <T> void proxy(T var1, Class<T> var2, String var3, String var4, List<String> var5);

    public <T> T mock(Class<T> port, String address) {
        Object mock = Mockito.mock(port);
        this.proxy(mock, port, address, null, null);
        return (T)mock;
    }

    public <T> T mock(Class<T> port, String address, String wsdlLocation) {
        if (wsdlLocation == null || wsdlLocation.isEmpty()) {
            throw new IllegalArgumentException("Expected WSDL location.");
        }
        Object mock = Mockito.mock(port);
        this.proxy(mock, port, address, wsdlLocation, null);
        return (T)mock;
    }

    public <T> T mock(Class<T> port, String address, List<String> schemaLocations) {
        if (schemaLocations == null || schemaLocations.isEmpty()) {
            throw new IllegalArgumentException("Expected XML Schema location(s).");
        }
        Object mock = Mockito.mock(port);
        this.proxy(mock, port, address, null, schemaLocations);
        return (T)mock;
    }

    public abstract void stop();

    public abstract void start();
}

