/*
 * Decompiled with CFR 0.152.
 */
package kankan.wheel.widget;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import java.util.LinkedList;
import java.util.List;
import kankan.wheel.R;
import kankan.wheel.widget.ItemsRange;
import kankan.wheel.widget.OnWheelChangedListener;
import kankan.wheel.widget.OnWheelClickedListener;
import kankan.wheel.widget.OnWheelScrollListener;
import kankan.wheel.widget.WheelRecycle;
import kankan.wheel.widget.WheelScroller;
import kankan.wheel.widget.adapters.WheelViewAdapter;

public class WheelView
extends View {
    private static final int[] SHADOWS_COLORS = new int[]{-1, 0xFFFFFF, 0xFFFFFF};
    private static final int ITEM_OFFSET_PERCENT = 10;
    private static final int PADDING = 10;
    private static final int DEF_VISIBLE_ITEMS = 5;
    private static final int LINE_THICKNESS = 1;
    private int currentItem = 0;
    private int visibleItems = 5;
    private int itemHeight = 0;
    private Drawable centerDrawable;
    private Drawable topLine;
    private Drawable bottomLine;
    private GradientDrawable topShadow;
    private GradientDrawable bottomShadow;
    private WheelScroller scroller;
    private boolean isScrollingPerformed;
    private int scrollingOffset;
    boolean isCyclic = false;
    private LinearLayout itemsLayout;
    private int firstItem;
    private WheelViewAdapter viewAdapter;
    private WheelRecycle recycle = new WheelRecycle(this);
    private List<OnWheelChangedListener> changingListeners = new LinkedList<OnWheelChangedListener>();
    private List<OnWheelScrollListener> scrollingListeners = new LinkedList<OnWheelScrollListener>();
    private List<OnWheelClickedListener> clickingListeners = new LinkedList<OnWheelClickedListener>();
    WheelScroller.ScrollingListener scrollingListener = new WheelScroller.ScrollingListener(){

        @Override
        public void onStarted() {
            WheelView.this.isScrollingPerformed = true;
            WheelView.this.notifyScrollingListenersAboutStart();
        }

        @Override
        public void onScroll(int distance) {
            WheelView.this.doScroll(distance);
            int height = WheelView.this.getHeight();
            if (WheelView.this.scrollingOffset > height) {
                WheelView.this.scrollingOffset = height;
                WheelView.this.scroller.stopScrolling();
            } else if (WheelView.this.scrollingOffset < -height) {
                WheelView.this.scrollingOffset = -height;
                WheelView.this.scroller.stopScrolling();
            }
        }

        @Override
        public void onFinished() {
            if (WheelView.this.isScrollingPerformed) {
                WheelView.this.notifyScrollingListenersAboutEnd();
                WheelView.this.isScrollingPerformed = false;
            }
            WheelView.this.scrollingOffset = 0;
            WheelView.this.invalidate();
        }

        @Override
        public void onJustify() {
            if (Math.abs(WheelView.this.scrollingOffset) > 1) {
                WheelView.this.scroller.scroll(WheelView.this.scrollingOffset, 0);
            }
        }
    };
    private DataSetObserver dataObserver = new DataSetObserver(){

        public void onChanged() {
            WheelView.this.invalidateWheel(false);
        }

        public void onInvalidated() {
            WheelView.this.invalidateWheel(true);
        }
    };

    public WheelView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initData(context);
    }

    public WheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initData(context);
    }

    public WheelView(Context context) {
        super(context);
        this.initData(context);
    }

    private void initData(Context context) {
        this.scroller = new WheelScroller(this.getContext(), this.scrollingListener);
    }

    public void setInterpolator(Interpolator interpolator) {
        this.scroller.setInterpolator(interpolator);
    }

    public int getVisibleItems() {
        return this.visibleItems;
    }

    public void setVisibleItems(int count) {
        this.visibleItems = count;
    }

    public WheelViewAdapter getViewAdapter() {
        return this.viewAdapter;
    }

    public void setViewAdapter(WheelViewAdapter viewAdapter) {
        if (this.viewAdapter != null) {
            this.viewAdapter.unregisterDataSetObserver(this.dataObserver);
        }
        this.viewAdapter = viewAdapter;
        if (this.viewAdapter != null) {
            this.viewAdapter.registerDataSetObserver(this.dataObserver);
        }
        this.invalidateWheel(true);
    }

    public void addChangingListener(OnWheelChangedListener listener) {
        this.changingListeners.add(listener);
    }

    public void removeChangingListener(OnWheelChangedListener listener) {
        this.changingListeners.remove(listener);
    }

    protected void notifyChangingListeners(int oldValue, int newValue) {
        for (OnWheelChangedListener listener : this.changingListeners) {
            listener.onChanged(this, oldValue, newValue);
        }
    }

    public void addScrollingListener(OnWheelScrollListener listener) {
        this.scrollingListeners.add(listener);
    }

    public void removeScrollingListener(OnWheelScrollListener listener) {
        this.scrollingListeners.remove(listener);
    }

    protected void notifyScrollingListenersAboutStart() {
        for (OnWheelScrollListener listener : this.scrollingListeners) {
            listener.onScrollingStarted(this);
        }
    }

    protected void notifyScrollingListenersAboutEnd() {
        for (OnWheelScrollListener listener : this.scrollingListeners) {
            listener.onScrollingFinished(this);
        }
    }

    public void addClickingListener(OnWheelClickedListener listener) {
        this.clickingListeners.add(listener);
    }

    public void removeClickingListener(OnWheelClickedListener listener) {
        this.clickingListeners.remove(listener);
    }

    protected void notifyClickListenersAboutClick(int item) {
        for (OnWheelClickedListener listener : this.clickingListeners) {
            listener.onItemClicked(this, item);
        }
    }

    public int getCurrentItem() {
        return this.currentItem;
    }

    public void setCurrentItem(int index, boolean animated) {
        if (this.viewAdapter == null || this.viewAdapter.getItemsCount() == 0) {
            return;
        }
        int itemCount = this.viewAdapter.getItemsCount();
        if (index < 0 || index >= itemCount) {
            if (this.isCyclic) {
                while (index < 0) {
                    index += itemCount;
                }
                index %= itemCount;
            } else {
                return;
            }
        }
        if (index != this.currentItem) {
            if (animated) {
                int scroll;
                int itemsToScroll = index - this.currentItem;
                if (this.isCyclic && (scroll = itemCount + Math.min(index, this.currentItem) - Math.max(index, this.currentItem)) < Math.abs(itemsToScroll)) {
                    itemsToScroll = itemsToScroll < 0 ? scroll : -scroll;
                }
                this.scroll(itemsToScroll, 0);
            } else {
                this.scrollingOffset = 0;
                int old = this.currentItem;
                this.currentItem = index;
                this.notifyChangingListeners(old, this.currentItem);
                this.invalidate();
            }
        }
    }

    public void setCurrentItem(int index) {
        this.setCurrentItem(index, false);
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public void setCyclic(boolean isCyclic) {
        this.isCyclic = isCyclic;
        this.invalidateWheel(false);
    }

    public void invalidateWheel(boolean clearCaches) {
        if (clearCaches) {
            this.recycle.clearAll();
            if (this.itemsLayout != null) {
                this.itemsLayout.removeAllViews();
            }
            this.scrollingOffset = 0;
        } else if (this.itemsLayout != null) {
            this.recycle.recycleItems(this.itemsLayout, this.firstItem, new ItemsRange());
        }
        this.invalidate();
    }

    private void initResourcesIfNecessary() {
        if (this.centerDrawable == null) {
            this.centerDrawable = this.getContext().getResources().getDrawable(R.drawable.wheel_val);
        }
        if (this.topLine == null) {
            this.topLine = this.getContext().getResources().getDrawable(R.drawable.item_line);
        }
        if (this.bottomLine == null) {
            this.bottomLine = this.getContext().getResources().getDrawable(R.drawable.item_line);
        }
        if (this.topShadow == null) {
            this.topShadow = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, SHADOWS_COLORS);
        }
        if (this.bottomShadow == null) {
            this.bottomShadow = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, SHADOWS_COLORS);
        }
    }

    private int getDesiredHeight(LinearLayout layout) {
        if (layout != null && layout.getChildAt(0) != null) {
            this.itemHeight = layout.getChildAt(0).getMeasuredHeight();
        }
        int desired = this.itemHeight * this.visibleItems - this.itemHeight * 10 / 50;
        return Math.max(desired, this.getSuggestedMinimumHeight());
    }

    private int getItemHeight() {
        if (this.itemHeight != 0) {
            return this.itemHeight;
        }
        if (this.itemsLayout != null && this.itemsLayout.getChildAt(0) != null) {
            this.itemHeight = this.itemsLayout.getChildAt(0).getHeight();
            return this.itemHeight;
        }
        return this.getHeight() / this.visibleItems;
    }

    private int calculateLayoutWidth(int widthSize, int mode) {
        this.initResourcesIfNecessary();
        this.itemsLayout.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.itemsLayout.measure(View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        int width = this.itemsLayout.getMeasuredWidth();
        if (mode == 0x40000000) {
            width = widthSize;
        } else {
            width += 20;
            width = Math.max(width, this.getSuggestedMinimumWidth());
            if (mode == Integer.MIN_VALUE && widthSize < width) {
                width = widthSize;
            }
        }
        this.itemsLayout.measure(View.MeasureSpec.makeMeasureSpec((int)(width - 20), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        return width;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.buildViewForMeasuring();
        int width = this.calculateLayoutWidth(widthSize, widthMode);
        if (heightMode == 0x40000000) {
            height = heightSize;
        } else {
            height = this.getDesiredHeight(this.itemsLayout);
            if (heightMode == Integer.MIN_VALUE) {
                height = Math.min(height, heightSize);
            }
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.layout(r - l, b - t);
    }

    private void layout(int width, int height) {
        int itemsWidth = width - 20;
        this.itemsLayout.layout(0, 0, itemsWidth, height);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.viewAdapter != null && this.viewAdapter.getItemsCount() > 0) {
            this.updateView();
            this.drawItems(canvas);
            this.drawTopAndBottomLines(canvas);
        }
        this.drawShadows(canvas);
    }

    private void drawCenterRect(Canvas canvas) {
        int center = this.getHeight() / 2;
        int offset = (int)((double)(this.getItemHeight() / 2) * 1.2);
        this.centerDrawable.setBounds(0, center - offset, this.getWidth(), center + offset);
        this.centerDrawable.draw(canvas);
    }

    private void drawTopAndBottomLines(Canvas canvas) {
        int center = this.getHeight() / 2;
        int offset = (int)((double)(this.getItemHeight() / 2) * 1.2);
        int left = 0;
        int top = center - offset;
        int leftRightMargin = 3;
        this.topLine.setBounds(left + leftRightMargin, top, this.getWidth() - leftRightMargin, top + this.topLine.getIntrinsicHeight());
        this.topLine.draw(canvas);
        int bottom = center + offset;
        this.bottomLine.setBounds(left + leftRightMargin, bottom - this.bottomLine.getIntrinsicHeight(), this.getWidth() - leftRightMargin, bottom);
        this.bottomLine.draw(canvas);
    }

    private void drawShadows(Canvas canvas) {
        int height = (int)(1.5 * (double)this.getItemHeight());
        this.topShadow.setBounds(0, 0, this.getWidth(), height);
        this.topShadow.draw(canvas);
        this.bottomShadow.setBounds(0, this.getHeight() - height, this.getWidth(), this.getHeight());
        this.bottomShadow.draw(canvas);
    }

    private void drawItems(Canvas canvas) {
        canvas.save();
        int top = (this.currentItem - this.firstItem) * this.getItemHeight() + (this.getItemHeight() - this.getHeight()) / 2;
        canvas.translate(10.0f, (float)(-top + this.scrollingOffset));
        this.itemsLayout.draw(canvas);
        canvas.restore();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled() || this.getViewAdapter() == null) {
            return true;
        }
        switch (event.getAction()) {
            case 2: {
                if (this.getParent() == null) break;
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 1: {
                if (this.isScrollingPerformed) break;
                int distance = (int)event.getY() - this.getHeight() / 2;
                distance = distance > 0 ? (distance += this.getItemHeight() / 2) : (distance -= this.getItemHeight() / 2);
                int items = distance / this.getItemHeight();
                if (items == 0 || !this.isValidItemIndex(this.currentItem + items)) break;
                this.notifyClickListenersAboutClick(this.currentItem + items);
            }
        }
        return this.scroller.onTouchEvent(event);
    }

    private void doScroll(int delta) {
        this.scrollingOffset += delta;
        int itemHeight = this.getItemHeight();
        int count = this.scrollingOffset / itemHeight;
        int pos = this.currentItem - count;
        int itemCount = this.viewAdapter.getItemsCount();
        int fixPos = this.scrollingOffset % itemHeight;
        if (Math.abs(fixPos) <= itemHeight / 2) {
            fixPos = 0;
        }
        if (this.isCyclic && itemCount > 0) {
            if (fixPos > 0) {
                --pos;
                ++count;
            } else if (fixPos < 0) {
                ++pos;
                --count;
            }
            while (pos < 0) {
                pos += itemCount;
            }
            pos %= itemCount;
        } else if (pos < 0) {
            count = this.currentItem;
            pos = 0;
        } else if (pos >= itemCount) {
            count = this.currentItem - itemCount + 1;
            pos = itemCount - 1;
        } else if (pos > 0 && fixPos > 0) {
            --pos;
            ++count;
        } else if (pos < itemCount - 1 && fixPos < 0) {
            ++pos;
            --count;
        }
        int offset = this.scrollingOffset;
        if (pos != this.currentItem) {
            this.setCurrentItem(pos, false);
        } else {
            this.invalidate();
        }
        this.scrollingOffset = offset - count * itemHeight;
        if (this.scrollingOffset > this.getHeight()) {
            this.scrollingOffset = this.scrollingOffset % this.getHeight() + this.getHeight();
        }
    }

    public void scroll(int itemsToScroll, int time) {
        int distance = itemsToScroll * this.getItemHeight() - this.scrollingOffset;
        this.scroller.scroll(distance, time);
    }

    private ItemsRange getItemsRange() {
        if (this.getItemHeight() == 0) {
            return null;
        }
        int first = this.currentItem;
        int count = 1;
        while (count * this.getItemHeight() < this.getHeight()) {
            --first;
            count += 2;
        }
        if (this.scrollingOffset != 0) {
            if (this.scrollingOffset > 0) {
                --first;
            }
            ++count;
            int emptyItems = this.scrollingOffset / this.getItemHeight();
            first -= emptyItems;
            count = (int)((double)count + Math.asin(emptyItems));
        }
        return new ItemsRange(first, count);
    }

    private boolean rebuildItems() {
        int first;
        boolean updated = false;
        ItemsRange range = this.getItemsRange();
        if (this.itemsLayout != null) {
            first = this.recycle.recycleItems(this.itemsLayout, this.firstItem, range);
            updated = this.firstItem != first;
            this.firstItem = first;
        } else {
            this.createItemsLayout();
            updated = true;
        }
        if (!updated) {
            boolean bl = updated = this.firstItem != range.getFirst() || this.itemsLayout.getChildCount() != range.getCount();
        }
        if (this.firstItem > range.getFirst() && this.firstItem <= range.getLast()) {
            int i = this.firstItem - 1;
            while (i >= range.getFirst() && this.addViewItem(i, true)) {
                this.firstItem = i--;
            }
        } else {
            this.firstItem = range.getFirst();
        }
        first = this.firstItem;
        for (int i = this.itemsLayout.getChildCount(); i < range.getCount(); ++i) {
            if (this.addViewItem(this.firstItem + i, false) || this.itemsLayout.getChildCount() != 0) continue;
            ++first;
        }
        this.firstItem = first;
        return updated;
    }

    private void updateView() {
        if (this.rebuildItems()) {
            this.calculateLayoutWidth(this.getWidth(), 0x40000000);
            this.layout(this.getWidth(), this.getHeight());
        }
    }

    private void createItemsLayout() {
        if (this.itemsLayout == null) {
            this.itemsLayout = new LinearLayout(this.getContext());
            this.itemsLayout.setOrientation(1);
        }
    }

    private void buildViewForMeasuring() {
        if (this.itemsLayout != null) {
            this.recycle.recycleItems(this.itemsLayout, this.firstItem, new ItemsRange());
        } else {
            this.createItemsLayout();
        }
        int addItems = this.visibleItems / 2;
        for (int i = this.currentItem + addItems; i >= this.currentItem - addItems; --i) {
            if (!this.addViewItem(i, true)) continue;
            this.firstItem = i;
        }
    }

    private boolean addViewItem(int index, boolean first) {
        View view = this.getItemView(index);
        if (view != null) {
            if (first) {
                this.itemsLayout.addView(view, 0);
            } else {
                this.itemsLayout.addView(view);
            }
            return true;
        }
        return false;
    }

    private boolean isValidItemIndex(int index) {
        return this.viewAdapter != null && this.viewAdapter.getItemsCount() > 0 && (this.isCyclic || index >= 0 && index < this.viewAdapter.getItemsCount());
    }

    private View getItemView(int index) {
        if (this.viewAdapter == null || this.viewAdapter.getItemsCount() == 0) {
            return null;
        }
        int count = this.viewAdapter.getItemsCount();
        if (!this.isValidItemIndex(index)) {
            return this.viewAdapter.getEmptyItem(this.recycle.getEmptyItem(), (ViewGroup)this.itemsLayout);
        }
        while (index < 0) {
            index = count + index;
        }
        return this.viewAdapter.getItem(index %= count, this.recycle.getItem(), (ViewGroup)this.itemsLayout);
    }

    public void stopScrolling() {
        this.scroller.stopScrolling();
    }
}

