/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.Predicate;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static boolean containsAll(Collection<?> coll1, Collection<?> coll2) {
        if (coll2.isEmpty()) {
            return true;
        }
        Iterator<?> it = coll1.iterator();
        HashSet elementsAlreadySeen = new HashSet();
        for (Object nextElement : coll2) {
            if (elementsAlreadySeen.contains(nextElement)) continue;
            boolean foundCurrentElement = false;
            while (it.hasNext()) {
                Object p = it.next();
                elementsAlreadySeen.add(p);
                if (!(nextElement == null ? p == null : nextElement.equals(p))) continue;
                foundCurrentElement = true;
                break;
            }
            if (foundCurrentElement) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static <T> T find(Iterable<T> collection, Predicate<? super T> predicate) {
        if (collection != null && predicate != null) {
            for (T item : collection) {
                if (!predicate.evaluate(item)) continue;
                return item;
            }
        }
        return null;
    }

    @Deprecated
    public static <T, C extends Closure<? super T>> C forAllDo(Iterable<T> collection, C closure) {
        if (collection != null && closure != null) {
            for (T item : collection) {
                closure.execute(item);
            }
        }
        return closure;
    }

    public static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !CollectionUtils.isEmpty(coll);
    }
}

