package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.common.NGException;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.web.WebUtils;
import com.github.siwenyan.web.core.StaleElementException;
import com.github.siwenyan.web.core.VerifyResult;

import java.util.Set;

public class Verify extends AbstractSimpleGuest<IWebDriverTable> {

    private static final String VERIFY_KEY = "verify";
    private static final String VERIFY_SELECTION_KEY = "verifySelection";

    @Override
    public String help(String flavor) {
        String help = "";

        if (flavor.equals(VERIFY_KEY)) {
            help += Constants.OUTPUT_INDENT + VERIFY_KEY + Constants.OUTPUT_FLAVOR_SEPARATOR + "identifier"
                    + Constants.OUTPUT_PARAM_SEPARATOR + WebUtils.TEXT_KEY + Constants.OUTPUT_PARAMNAME_SEPARATOR
                    + "expectedText" + Constants.OUTPUT_PARAM_SEPARATOR + "attributeName1"
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "expectedAttributeValue1"
                    + Constants.OUTPUT_PARAM_SEPARATOR + "attributeName2" + Constants.OUTPUT_PARAMNAME_SEPARATOR
                    + "expectedAttributeValue2" + Constants.OUTPUT_PARAM_SEPARATOR + "..."
                    + Constants.OUTPUT_LINE_SEPARATOR + "\r\n";
        }

        if (flavor.equals(VERIFY_SELECTION_KEY)) {
            help += Constants.OUTPUT_INDENT + VERIFY_SELECTION_KEY + Constants.OUTPUT_FLAVOR_SEPARATOR + "identifier1"
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "expectedText1" + Constants.OUTPUT_PARAM_SEPARATOR
                    + "identifier2" + Constants.OUTPUT_PARAMNAME_SEPARATOR + "expectedText2"
                    + Constants.OUTPUT_LINE_SEPARATOR + "\r\n";
        }

        return help;
    }

    @Override
    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();

            if (cmd.equals(VERIFY_KEY)) {
                // required identifier
                String identifier = this.dynamic(dish.getStringElement(Constants.DEFAULT_KEY));
                if (identifier == null || identifier.isEmpty()) {
                    return new Feedback(Feedback.EStatus.FAIL, "Missing identifier.");
                }

                Set<String> keys = dish.getElementKeySet();
                if (keys.size() <= 1) {
                    return new Feedback(Feedback.EStatus.FAIL, "Nothing to be veried.");
                }

                for (String key : keys) {
                    if (key.equals(Constants.DEFAULT_KEY)) {
                        continue;
                    }

                    String value = this.dynamic(dish.getStringElement(key));
                    if (value == null) {
                        return new Feedback(Feedback.EStatus.FAIL, "Missing expected value.");
                    }

                    if (VerifyResult.DIFFERENT == WebUtils.doVerify(myTable.getMyWebDriver(), identifier, key, value)) {
                        return new Feedback(Feedback.EStatus.FAIL, "No match.");
                    }
                }

                return Feedback.yami();
            }

            if (cmd.equals(VERIFY_SELECTION_KEY)) {
                Set<String> keys = dish.getElementKeySet();
                if (keys.size() <= 0) {
                    return new Feedback(Feedback.EStatus.FAIL, "Nothing to be verified.");
                }

                for (String key : keys) {
                    if (key.equals(Constants.DEFAULT_KEY)) {
                        continue;
                    }

                    String value = this.dynamic(dish.getStringElement(key));
                    if (value == null) {
                        return new Feedback(Feedback.EStatus.FAIL, "Missing expected value.");
                    }

                    try {
                        WebUtils.doVerifySelection(myTable.getMyWebDriver(), key, value);
                    } catch (NGException e) {
                        return new Feedback(Feedback.EStatus.FAIL, "No match.");
                    }
                }

                return Feedback.yami();
            }
        } catch (StaleElementException e) {
            return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
        } catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }

        return Feedback.yaki();
    }

    public String[] getFlavors() {
        return new String[]{VERIFY_KEY, VERIFY_SELECTION_KEY};
    }

}
