package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.web.WebUtils;
import com.github.siwenyan.web.core.StaleElementException;

import java.util.Set;

public class TryInput extends AbstractSimpleGuest<IWebDriverTable> {

    private static final String INPUT_KEY = "input";

    @Override
    public String help(String flavor) {
        String help = "";

        if (flavor.equals(INPUT_KEY)) {
            help += Constants.OUTPUT_INDENT + INPUT_KEY + Constants.OUTPUT_FLAVOR_SEPARATOR + "identifier"

                    + Constants.OUTPUT_PARAM_SEPARATOR + WebUtils.TEXT_KEY + Constants.OUTPUT_PARAMNAME_SEPARATOR
                    + "inputText" + Constants.OUTPUT_PARAM_SEPARATOR + "attributeName1"
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "inputAttributeValue1" + Constants.OUTPUT_PARAM_SEPARATOR
                    + "attributeName2" + Constants.OUTPUT_PARAMNAME_SEPARATOR + "inputAttributeValue2"

                    + Constants.OUTPUT_PARAM_SEPARATOR + "..." + Constants.OUTPUT_LINE_SEPARATOR + "\r\n";
        }

        return help;
    }

    @Override
    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();

            if (cmd.equals(INPUT_KEY)) {
                String identifier = this.dynamic(dish.getStringElement(Constants.DEFAULT_KEY));
                if (identifier == null || identifier.isEmpty()) {
                    return new Feedback(Feedback.EStatus.FAIL, "identifier + not specified.");
                }

                Set<String> keys = dish.getElementKeySet();
                if (keys.size() <= 1) {
                    return new Feedback(Feedback.EStatus.FAIL, "Nothing to be input.");
                }

                for (String key : keys) {
                    if (key.equals(Constants.DEFAULT_KEY)) {
                        continue;
                    }

                    String value = this.dynamic(dish.getStringElement(key));
                    if (value == null) {
                        return new Feedback(Feedback.EStatus.FAIL, "Missing input value.");
                    }

                    WebUtils.doInput(myTable.getMyWebDriver(), identifier, key, value);
                }

                return Feedback.yami();
            }

        } catch (StaleElementException e) {
            return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
        } catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }

        return Feedback.yaki();
    }

    public String[] getFlavors() {
        return new String[]{INPUT_KEY};
    }

}
