package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.potluck.AbstractSimpleFeeder;
import com.github.siwenyan.potluck.ITable;

import java.io.PrintStream;
import java.util.Scanner;

public class SimpleFeederExt01 extends AbstractSimpleFeeder {

    public SimpleFeederExt01(Scanner in, PrintStream feedback) {
        super(in, feedback);
    }

    @Override
    public ITable createTable(String name) {
        if (!this.tablesByName.containsKey(name)) {
            ITable table = new SimpleWebDriverTable();
            table.setName(name);
            this.register(table);
            return table;
        } else {
            return null;
        }
    }

    @Override
    public void inviteExternalGuests(String tableName) {
        IWebDriverTable myTable = (IWebDriverTable) this.getTable(tableName);
        new AlertAccept().setMyTable(myTable);
        new AlertDismiss().setMyTable(myTable);
        new AlertText().setMyTable(myTable);
        new ClickAll().setMyTable(myTable);
        new GetField().setMyTable(myTable);
        new GetFieldCorners().setMyTable(myTable);
        new GuestReplaceDriver().setMyTable(myTable);
        new GuestWindow().setMyTable(myTable);
        new JavaScript().setMyTable(myTable);
        new OpenURL().setMyTable(myTable);
        new Screenshot().setMyTable(myTable);
        new SendKey().setMyTable(myTable);
        new ShowElements().setMyTable(myTable);
        new TestField().setMyTable(myTable);
        new TryClick().setMyTable(myTable);
        new TryFill().setMyTable(myTable);
        new TryInput().setMyTable(myTable);
        new TrySelect().setMyTable(myTable);
        new Verify().setMyTable(myTable);

//		 new GuestDb().setMyTable(myTable);
//		 new TextWriter().setMyTable(myTable);
//		 new SaveUrl().setMyTable(myTable);
//		 new FtpDelete().setMyTable(myTable);
//		 new HttpPost().setMyTable(myTable);
//		 new GetMachineDate().setMyTable(myTable);
//		 new ReadJson().setMyTable(myTable);
//		 new ReadXml().setMyTable(myTable);
//		 new OsCommand().setMyTable(myTable);
//		 new CopyRemoteFile().setMyTable(myTable);
//		 new ExcelUtil().setMyTable(myTable);
    }

}
