package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.common.MyEnvironment;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.web.Factories;
import com.github.siwenyan.web.core.ICorePoint;
import com.github.siwenyan.web.core.ICoreWebElement;
import com.github.siwenyan.web.core.StaleElementException;

public class GetFieldCorners extends AbstractSimpleGuest<IWebDriverTable> {

	private static final String FLAVOR_GET_FIELD_Corners = "getFieldCorners";

	private static final String X1_INTO_KEY = "x1Into";
	private static final String Y1_INTO_KEY = "y1Into";
	private static final String X2_INTO_KEY = "x2Into";
	private static final String Y2_INTO_KEY = "y2Into";

	@Override
	public String help(String flavor) {
		String help = "";

		if (flavor.equals(FLAVOR_GET_FIELD_Corners)) {
			help += Constants.OUTPUT_INDENT + FLAVOR_GET_FIELD_Corners + Constants.OUTPUT_FLAVOR_SEPARATOR
					+ "identifier" + Constants.OUTPUT_PARAM_SEPARATOR + X1_INTO_KEY
					+ Constants.OUTPUT_PARAMNAME_SEPARATOR + "yourVarName" + Constants.OUTPUT_PARAM_SEPARATOR
					+ Y1_INTO_KEY + Constants.OUTPUT_PARAMNAME_SEPARATOR + "yourVarName"
					+ Constants.OUTPUT_PARAM_SEPARATOR + X2_INTO_KEY + Constants.OUTPUT_PARAMNAME_SEPARATOR
					+ "yourVarName" + Constants.OUTPUT_PARAM_SEPARATOR + Y2_INTO_KEY
					+ Constants.OUTPUT_PARAMNAME_SEPARATOR + "yourVarName" + Constants.OUTPUT_LINE_SEPARATOR
					+ "\r\n";
		}

		return help;
	}

	@Override
	public Feedback have(IDish dish) {
		try {
			String cmd = dish.getFlavor().getFlavorName();

			if (cmd.equals(FLAVOR_GET_FIELD_Corners)) {
				// required identifier
				String identifier = this.dynamic(dish.getStringElement(Constants.DEFAULT_KEY));
				if (identifier == null || identifier.isEmpty()) {
					return new Feedback(Feedback.EStatus.FAIL, "Missing identifier.");
				}

				// optional x1Into, y1Into, x2Into, y2Into
				String x1Into = null, y1Into = null, x2Into = null, y2Into = null;
				if (dish.containsElement(X1_INTO_KEY)) {
					x1Into = this.dynamic(dish.getStringElement(X1_INTO_KEY));
				}
				if (dish.containsElement(Y1_INTO_KEY)) {
					y1Into = this.dynamic(dish.getStringElement(Y1_INTO_KEY));
				}
				if (dish.containsElement(X2_INTO_KEY)) {
					x2Into = this.dynamic(dish.getStringElement(X2_INTO_KEY));
				}
				if (dish.containsElement(Y2_INTO_KEY)) {
					y2Into = this.dynamic(dish.getStringElement(Y2_INTO_KEY));
				}

				ICorePoint point1 = Factories.web().createPoint(0, 0);
				ICorePoint point2 = Factories.web().createPoint(0, 0);
				if (!doGetFieldCorners(identifier, point1, point2)) {
					return new Feedback(Feedback.EStatus.FAIL, "Fail to get.");
				} else {
					MyEnvironment myEnvironment = myTable.getMyEnvironment();
					if (x1Into != null) {
						myEnvironment.put(x1Into, "" + point1.getX());
					}
					if (y1Into != null) {
						myEnvironment.put(y1Into, "" + point1.getY());
					}
					if (x2Into != null) {
						myEnvironment.put(x2Into, "" + point2.getX());
					}
					if (y2Into != null) {
						myEnvironment.put(y2Into, "" + point2.getY());
					}

					return Feedback.yami();
				}
			}
		} catch (StaleElementException e) {
			return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
		} catch (Exception e) {
			return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
		}

		return Feedback.yaki();
	}

	public String[] getFlavors() {
		return new String[] { FLAVOR_GET_FIELD_Corners };
	}

	// returns true if verified
	private boolean doGetFieldCorners(String identifier, ICorePoint point1, ICorePoint point2)
			throws StaleElementException {

		// get the field value if any
		myTable.println("Finding the Field: " + identifier + "...");
		ICoreWebElement field = null;
		field = myTable.getMyWebDriver().find(identifier).get(0);
		if (field == null) {
			myTable.println("Field " + identifier + " not found.");
			return false;
		} else {
			// Get the absolute location of element on the page
			ICorePoint pointInIframe = field.getAbsoluteLocation();
			point1.setX(pointInIframe.getX());
			point1.setY(pointInIframe.getY());

			// Get width and height of the element
			point2.setX(point1.getX() + field.getSize().getWidth());
			point2.setY(point1.getY() + field.getSize().getHeight());

			return true;
		}

	}
}
