package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.common.MyEscaper;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.web.Factories;
import com.github.siwenyan.web.core.ICoreUiSelect;
import com.github.siwenyan.web.core.ICoreWebElement;
import com.github.siwenyan.web.core.StaleElementException;

public class GetField extends AbstractSimpleGuest<IWebDriverTable> {

	private static final String GET_FIELD_KEY = "getField";
	private static final String TARGET_KEY = "target";
	private static final String TARGET_TEXT_KEY = "text";
	private static final String TARGET_FIRST_SELECTION_KEY = "firstSelection";
	private static final String TARGET_RECTANGLE_KEY = "rectangle";
	private static final String INTO_KEY = "into";

	@Override
	public String help(String flavor) {
		String help = "";

		if (flavor.equals(GET_FIELD_KEY)) {
			help += Constants.OUTPUT_INDENT + GET_FIELD_KEY + Constants.OUTPUT_FLAVOR_SEPARATOR + "identifier"
					+ Constants.OUTPUT_PARAM_SEPARATOR + TARGET_KEY + Constants.OUTPUT_PARAMNAME_SEPARATOR
					+ TARGET_TEXT_KEY + "/" + TARGET_FIRST_SELECTION_KEY + "/attributeName" + "/" + TARGET_RECTANGLE_KEY
					+ Constants.OUTPUT_PARAM_SEPARATOR + INTO_KEY + Constants.OUTPUT_PARAMNAME_SEPARATOR
					+ "yourVariableName" + Constants.OUTPUT_LINE_SEPARATOR + "\r\n";
		}

		return help;
	}

	@Override
	public Feedback have(IDish dish) {
		try {
			String cmd = dish.getFlavor().getFlavorName();

			if (cmd.equals(GET_FIELD_KEY)) {
				// required identifier
				String identifier = this.dynamic(dish.getStringElement(Constants.DEFAULT_KEY));
				if (identifier == null || identifier.isEmpty()) {
					return new Feedback(Feedback.EStatus.FAIL, "Missing identifier.");
				}

				// required target
				String target = this.dynamic(dish.getStringElement(TARGET_KEY));
				if (target == null || target.isEmpty()) {
					return new Feedback(Feedback.EStatus.FAIL, "Missing " + TARGET_KEY + ".");
				}

				// required variableName
				String variableName = this.dynamic(dish.getStringElement(INTO_KEY));
				if (variableName == null || variableName.isEmpty()) {
					return new Feedback(Feedback.EStatus.FAIL, "Missing " + INTO_KEY + ".");
				}

				if (!doGetField(identifier, target, variableName)) {
					return new Feedback(Feedback.EStatus.FAIL, "Fail to get.");
				}

				return Feedback.yami();
			}
		} catch (StaleElementException e) {
			return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
		} catch (Exception e) {
			return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
		}

		return Feedback.yaki();
	}

	public String[] getFlavors() {
		return new String[] { GET_FIELD_KEY };
	}

	// returns true if verified
	private boolean doGetField(String identifier, String target, String variableName) throws StaleElementException {

		// get the field value if any
		identifier = MyEscaper.unescape(identifier);
		identifier = this.dynamic(identifier);
		myTable.println("Finding the Field: " + identifier + "...");
		ICoreWebElement field = null;
		field = myTable.getMyWebDriver().find(identifier).get(0);
		if (field == null) {
			myTable.println("Field " + identifier + " not found.");
			return false;
		} else {
			String text = null;
			if (target.equals(TARGET_TEXT_KEY)) {
				text = field.getText();
			} else if (target.equals(TARGET_FIRST_SELECTION_KEY)) {
				ICoreUiSelect select = Factories.web().createUiSelect(field);
				ICoreWebElement firstSelection = select.getFirstSelectedOption();
				text = firstSelection.getAttribute("value");
			} else if (target.equals(TARGET_RECTANGLE_KEY)) {
				text = "[x=" + field.getAbsoluteLocation().getX() + ", " + "y=" + field.getAbsoluteLocation().getY()
						+ ", " + "width=" + field.getSize().getWidth() + ", " + "height=" + field.getSize().getHeight()
						+ "]";
			} else {
				text = field.getAttribute(target);
			}

			if (text == null) {
				text = "";
			}

			myTable.println("Field " + target + ": [" + (text == null ? "null" : text) + "]");

			// set
			myTable.getMyEnvironment().put(variableName, text);

			return true;
		}

	}
}
