package com.github.siwenyan.common;

import java.util.Properties;

public class Conf extends ConfBase {
    
    private static final String CONFIG_FILE_NAME = "ext01";
    private static final String KEY_SYSTEM_KEYS = "system.keys";
    private static final String KEY_SPLITTER = ":";
    
    public static Properties getInstance() {
        return instance;
    }

    private static final ConfBase instance = new Conf();

    private Conf() {
        super(CONFIG_FILE_NAME);

        String sSystemKeys = this.getProperty(KEY_SYSTEM_KEYS);
        if (null != sSystemKeys) {
            String[] systemKeys = sSystemKeys.split(KEY_SPLITTER);
            for (String key : systemKeys) {
                System.setProperty(key, this.getProperty(key));
            }
        }
    }
}
