/*
 * Decompiled with CFR 0.152.
 */
package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.common.NGException;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.potluck.ext01.IWebDriverTable;
import com.github.siwenyan.web.WebUtils;
import com.github.siwenyan.web.core.MyWebDriver;
import com.github.siwenyan.web.core.StaleElementException;
import com.github.siwenyan.web.core.VerifyResult;
import java.util.Set;

public class Verify
extends AbstractSimpleGuest<IWebDriverTable> {
    private static final String VERIFY_KEY = "verify";
    private static final String VERIFY_SELECTION_KEY = "verifySelection";

    public String help(String flavor) {
        String help = "";
        if (flavor.equals(VERIFY_KEY)) {
            help = help + "  verify identifier text=expectedText attributeName1=expectedAttributeValue1 attributeName2=expectedAttributeValue2 ...;\r\n";
        }
        if (flavor.equals(VERIFY_SELECTION_KEY)) {
            help = help + "  verifySelection identifier1=expectedText1 identifier2=expectedText2;\r\n";
        }
        return help;
    }

    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();
            if (cmd.equals(VERIFY_KEY)) {
                String identifier = this.dynamic(dish.getStringElement(new String[]{"main"}));
                if (identifier == null || identifier.isEmpty()) {
                    return new Feedback(Feedback.EStatus.FAIL, "Missing identifier.");
                }
                Set keys = dish.getElementKeySet();
                if (keys.size() <= 1) {
                    return new Feedback(Feedback.EStatus.FAIL, "Nothing to be veried.");
                }
                for (String key : keys) {
                    if (key.equals("main")) continue;
                    String value = this.dynamic(dish.getStringElement(new String[]{key}));
                    if (value == null) {
                        return new Feedback(Feedback.EStatus.FAIL, "Missing expected value.");
                    }
                    if (VerifyResult.DIFFERENT != WebUtils.doVerify((MyWebDriver)((IWebDriverTable)this.myTable).getMyWebDriver(), (String)identifier, (String)key, (String)value)) continue;
                    return new Feedback(Feedback.EStatus.FAIL, "No match.");
                }
                return Feedback.yami();
            }
            if (cmd.equals(VERIFY_SELECTION_KEY)) {
                Set keys = dish.getElementKeySet();
                if (keys.size() <= 0) {
                    return new Feedback(Feedback.EStatus.FAIL, "Nothing to be verified.");
                }
                for (String key : keys) {
                    if (key.equals("main")) continue;
                    String value = this.dynamic(dish.getStringElement(new String[]{key}));
                    if (value == null) {
                        return new Feedback(Feedback.EStatus.FAIL, "Missing expected value.");
                    }
                    try {
                        WebUtils.doVerifySelection((MyWebDriver)((IWebDriverTable)this.myTable).getMyWebDriver(), (String)key, (String)value);
                    }
                    catch (NGException e) {
                        return new Feedback(Feedback.EStatus.FAIL, "No match.");
                    }
                }
                return Feedback.yami();
            }
        }
        catch (StaleElementException e) {
            return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
        }
        catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }
        return Feedback.yaki();
    }

    public String[] getFlavors() {
        return new String[]{VERIFY_KEY, VERIFY_SELECTION_KEY};
    }
}

