/*
 * Decompiled with CFR 0.152.
 */
package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.potluck.ext01.IWebDriverTable;
import com.github.siwenyan.web.Factories;
import com.github.siwenyan.web.core.ICoreUiSelect;
import com.github.siwenyan.web.core.ICoreWebElement;
import com.github.siwenyan.web.core.StaleElementException;
import java.util.List;

public class TryFill
extends AbstractSimpleGuest<IWebDriverTable> {
    private static final String FILL_KEY = "fill";

    public String help(String flavor) {
        String help = "";
        if (flavor.equals(FILL_KEY)) {
            help = help + "  fill identifier1=value1 identifier2=value2 ...;\r\n";
        }
        return help;
    }

    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();
            if (cmd.equals(FILL_KEY)) {
                for (String identifier : dish.getElementKeySet()) {
                    ICoreWebElement el = (ICoreWebElement)((IWebDriverTable)this.myTable).getMyWebDriver().find(this.dynamic(identifier)).get(0);
                    String partialValue = this.dynamic(dish.getStringElement(new String[]{identifier}));
                    if (el != null && partialValue != null) {
                        try {
                            el.clear();
                            el.sendKeys(partialValue);
                            continue;
                        }
                        catch (StaleElementException e) {
                            throw e;
                        }
                        catch (Exception e1) {
                            try {
                                String text;
                                String value;
                                ICoreUiSelect select = Factories.web().createUiSelect(el);
                                List options = select.getOptions();
                                for (ICoreWebElement option : options) {
                                    value = option.getAttribute("value");
                                    if (!value.equals(partialValue)) continue;
                                    select.selectByValue(value);
                                    return Feedback.yami();
                                }
                                for (ICoreWebElement option : options) {
                                    value = option.getAttribute("value");
                                    text = option.getText();
                                    if (!text.equals(partialValue)) continue;
                                    select.selectByValue(value);
                                    return Feedback.yami();
                                }
                                for (ICoreWebElement option : options) {
                                    value = option.getAttribute("value");
                                    if (!value.contains(partialValue)) continue;
                                    select.selectByValue(value);
                                    return Feedback.yami();
                                }
                                for (ICoreWebElement option : options) {
                                    value = option.getAttribute("value");
                                    text = option.getText();
                                    if (!text.contains(partialValue)) continue;
                                    select.selectByValue(value);
                                    return Feedback.yami();
                                }
                                for (ICoreWebElement option : options) {
                                    value = option.getAttribute("value");
                                    if (!value.matches(partialValue)) continue;
                                    select.selectByValue(value);
                                    return Feedback.yami();
                                }
                                for (ICoreWebElement option : options) {
                                    value = option.getAttribute("value");
                                    text = option.getText();
                                    if (!text.matches(partialValue)) continue;
                                    select.selectByValue(value);
                                    return Feedback.yami();
                                }
                                return new Feedback(Feedback.EStatus.FAIL, "No such option: " + partialValue);
                            }
                            catch (StaleElementException e) {
                                throw e;
                            }
                            catch (Exception e2) {
                                return new Feedback(Feedback.EStatus.FAIL, "Fail to fill: " + partialValue);
                            }
                        }
                    }
                    return new Feedback(Feedback.EStatus.FAIL, identifier + " is ambiguous or not found.");
                }
                return Feedback.yami();
            }
        }
        catch (StaleElementException e) {
            return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
        }
        catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }
        return Feedback.yaki();
    }

    public String[] getFlavors() {
        return new String[]{FILL_KEY};
    }
}

