/*
 * Decompiled with CFR 0.152.
 */
package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.potluck.ext01.IWebDriverTable;
import com.github.siwenyan.web.core.ICoreWebElement;

public class TestField
extends AbstractSimpleGuest<IWebDriverTable> {
    private static final String TEST_FIELD_KEY = "testField";
    private static final String INTO_KEY = "into";
    private static final String TEST_EXIST = "TEST_EXIST";
    private static final String TEST_NOT_EXIST = "TEST_NOT_EXIST";

    public String help(String flavor) {
        String help = "";
        if (flavor.equals(TEST_FIELD_KEY)) {
            help = help + "  testField identifier  into=yourVariableName;\r\n";
            help = help + "Test possible results: [TEST_EXIST], [TEST_NOT_EXIST].\r\n";
        }
        return help;
    }

    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();
            if (cmd.equals(TEST_FIELD_KEY)) {
                String identifier = this.dynamic(dish.getStringElement(new String[]{"main"}));
                if (identifier == null || identifier.isEmpty()) {
                    return new Feedback(Feedback.EStatus.FAIL, "Missing identifier.");
                }
                String variableName = this.dynamic(dish.getStringElement(new String[]{INTO_KEY}));
                if (variableName == null || variableName.isEmpty()) {
                    return new Feedback(Feedback.EStatus.FAIL, "Missing into.");
                }
                this.doTestField(identifier, variableName);
                return Feedback.yami();
            }
        }
        catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }
        return Feedback.yaki();
    }

    public String[] getFlavors() {
        return new String[]{TEST_FIELD_KEY};
    }

    private void doTestField(String identifier, String variableName) {
        ((IWebDriverTable)this.myTable).println("Finding the Field: " + identifier + "...");
        ICoreWebElement field = null;
        field = (ICoreWebElement)((IWebDriverTable)this.myTable).getMyWebDriver().find(identifier).get(0);
        if (field == null) {
            ((IWebDriverTable)this.myTable).getMyEnvironment().put(variableName, (Object)TEST_NOT_EXIST);
            ((IWebDriverTable)this.myTable).println(variableName + "=[" + TEST_NOT_EXIST + "]");
        } else {
            ((IWebDriverTable)this.myTable).getMyEnvironment().put(variableName, (Object)TEST_EXIST);
            ((IWebDriverTable)this.myTable).println(variableName + "=[" + TEST_EXIST + "]");
        }
    }
}

