/*
 * Decompiled with CFR 0.152.
 */
package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.common.NGException;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.potluck.ext01.IWebDriverTable;
import com.github.siwenyan.web.Factories;
import com.github.siwenyan.web.core.ECoreKeys;
import com.github.siwenyan.web.core.ICoreInteractionActions;
import com.github.siwenyan.web.core.ICoreWebElement;
import com.github.siwenyan.web.core.MyWebDriver;
import com.github.siwenyan.web.core.StaleElementException;
import java.util.TreeSet;

public class SendKey
extends AbstractSimpleGuest<IWebDriverTable> {
    private static final String SEND_KEY = "sendKey";
    private static final String SEQUENCE_KEY_PREFIX = "seq";
    private static final String HINT_KEY_DOWN = "keyDown";
    private static final String HINT_KEY_UP = "keyUp";
    private static final String HINT_SEND_KEY = "sendKey";
    private static final String HINT_SEPARATOR = ":";

    public String help(String flavor) {
        String help = "";
        if (flavor.equals("sendKey")) {
            help = help + "  sendKey [optionalTargetElement] seq1=hint1:keys1 seq2=hint2:keys2 seq...;\r\n";
            help = help + "  Possible hints: [keyDown, keyUp, sendKey]\r\n";
            help = help + "  For hints [keyDown, keyUp]: Possible keys are: " + this.toStringEnumKeys() + "\r\n";
            help = help + "  For OPTIONAL hint [sendKey]: it could be any charactor sequence " + this.toStringEnumKeys() + "\r\n";
        }
        return help;
    }

    private String toStringEnumKeys() {
        String s = "[";
        for (ECoreKeys key : ECoreKeys.values()) {
            s = s + key.name() + ",";
        }
        s = s + "]";
        return s;
    }

    public Feedback have(IDish dish) {
        try {
            MyWebDriver myWebDriver = ((IWebDriverTable)this.myTable).getMyWebDriver();
            String cmd = dish.getFlavor().getFlavorName();
            if (cmd.equals("sendKey")) {
                ICoreWebElement el = null;
                if (dish.containsElement("main")) {
                    String sel = this.dynamic(dish.getStringElement(new String[]{"main"}));
                    el = (ICoreWebElement)((IWebDriverTable)this.myTable).getMyWebDriver().find(sel).get(0);
                    if (el == null) {
                        return new Feedback(Feedback.EStatus.FAIL, "No such element: " + sel);
                    }
                }
                ICoreInteractionActions builder = Factories.web().createActions(myWebDriver.getCoreWebDriver());
                TreeSet orderedKeySet = new TreeSet(dish.getElementKeySet());
                for (String key : orderedKeySet) {
                    String keysWithHint = this.dynamic(dish.getStringElement(new String[]{key}));
                    if (!key.startsWith(SEQUENCE_KEY_PREFIX)) continue;
                    this.sendKey(builder, el, keysWithHint);
                }
                builder.build().perform();
                return Feedback.yami();
            }
        }
        catch (StaleElementException e) {
            return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
        }
        catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }
        return Feedback.yaki();
    }

    private void sendKey(ICoreInteractionActions builder, ICoreWebElement el, String keysWithHint) throws NGException, StaleElementException {
        String[] pair = keysWithHint.split(HINT_SEPARATOR, 2);
        if (pair.length == 1) {
            this.doSendKey(builder, el, pair[0]);
        } else if (pair.length == 2) {
            if (pair[0].equals("sendKey")) {
                this.doSendKey(builder, el, pair[1]);
            } else if (pair[0].equals(HINT_KEY_DOWN)) {
                this.doKeyDown(builder, el, pair[1]);
            } else if (pair[0].equals(HINT_KEY_UP)) {
                this.doKeyUp(builder, el, pair[1]);
            }
        } else {
            throw new NGException("Wrong keys: " + keysWithHint);
        }
    }

    private void doKeyUp(ICoreInteractionActions builder, ICoreWebElement el, String keysToSend) throws StaleElementException {
        if (el == null) {
            builder.keyUp(ECoreKeys.valueOf((String)keysToSend));
        } else {
            builder.keyUp(el, ECoreKeys.valueOf((String)keysToSend));
        }
    }

    private void doKeyDown(ICoreInteractionActions builder, ICoreWebElement el, String keysToSend) throws StaleElementException {
        if (el == null) {
            builder.keyDown(ECoreKeys.valueOf((String)keysToSend));
        } else {
            builder.keyDown(el, ECoreKeys.valueOf((String)keysToSend));
        }
    }

    private void doSendKey(ICoreInteractionActions builder, ICoreWebElement el, String keysToSend) throws StaleElementException {
        if (el == null) {
            builder.sendKeys(keysToSend);
        } else {
            builder.sendKeys(el, keysToSend);
        }
    }

    public String[] getFlavors() {
        return new String[]{"sendKey"};
    }
}

