/*
 * Decompiled with CFR 0.152.
 */
package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.potluck.ext01.IWebDriverTable;
import com.github.siwenyan.web.core.MyWebDriver;

public class OpenURL
extends AbstractSimpleGuest<IWebDriverTable> {
    private static final String URL_KEY = "url";
    private static final String OPEN_KEY = "open";

    public String help(String flavor) {
        String help = "\r\n";
        if (flavor.equals(OPEN_KEY)) {
            help = help + "  open url=https://www.google.com/#q=peoplesoft;\r\n";
        }
        return help;
    }

    public Feedback have(IDish dish) {
        try {
            MyWebDriver myWebDriver = ((IWebDriverTable)this.myTable).getMyWebDriver();
            String cmd = dish.getFlavor().getFlavorName();
            if (cmd.equals(OPEN_KEY)) {
                String url = this.dynamic(dish.getStringElement(new String[]{URL_KEY, "main"}));
                if (url == null || url.isEmpty()) {
                    return new Feedback(Feedback.EStatus.FAIL, "URL not specified.");
                }
                myWebDriver.getCoreWebDriver().get(url);
                return Feedback.yami();
            }
        }
        catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }
        return Feedback.yaki();
    }

    public String[] getFlavors() {
        return new String[]{OPEN_KEY};
    }
}

