/*
 * Decompiled with CFR 0.152.
 */
package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.potluck.ext01.IWebDriverTable;
import com.github.siwenyan.web.core.ICoreDimension;
import com.github.siwenyan.web.core.ICorePoint;
import com.github.siwenyan.web.core.MyWebDriver;
import java.awt.Rectangle;
import java.util.Set;

public class GuestWindow
extends AbstractSimpleGuest<IWebDriverTable> {
    private static final String FLAVOR_MOVE_RESIZE = "moveAndResize";
    private static final String FLAVOR_NEXT_WINDOW = "nextWindow";
    private static final String FLAVOR_CLOSE_WINDOW = "closeWindow";
    private static final String FLAVOR_CLOSE_OTHERS = "closeOthers";
    private static final String WINDOW_X_KEY = "x";
    private static final String WINDOW_Y_KEY = "y";
    private static final String WINDOW_W_KEY = "width";
    private static final String WINDOW_H_KEY = "height";

    public String help(String flavor) {
        String help = "";
        if (flavor.equals(FLAVOR_MOVE_RESIZE)) {
            help = help + "  moveAndResize x=integer y=integer width=integer height=integer ;\r\n    Description: to move and/or resize a browser.\r\n";
        }
        if (flavor.equals(FLAVOR_NEXT_WINDOW)) {
            help = help + "  nextWindow;\r\n    Description: switch to the next openned window.\r\n";
        }
        if (flavor.equals(FLAVOR_CLOSE_WINDOW)) {
            help = help + "  closeWindow;\r\n    Description: close the current window. Not applicable to the parent window.r\n";
        }
        if (flavor.equals(FLAVOR_CLOSE_OTHERS)) {
            help = help + "  closeOthers;\r\n    Description: close other windows.\r\n";
        }
        return help;
    }

    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();
            MyWebDriver myWebDriver = ((IWebDriverTable)this.myTable).getMyWebDriver();
            if (cmd.equals(FLAVOR_MOVE_RESIZE)) {
                String s;
                ICorePoint pos = myWebDriver.getCoreWebDriver().manage().window().getPosition();
                ICoreDimension size = myWebDriver.getCoreWebDriver().manage().window().getSize();
                int x = pos.getX();
                int y = pos.getY();
                int w = size.getWidth();
                int h = size.getHeight();
                if (dish.containsElement(WINDOW_X_KEY)) {
                    s = this.dynamic(dish.getStringElement(new String[]{WINDOW_X_KEY}));
                    x = Integer.parseInt(s);
                }
                if (dish.containsElement(WINDOW_Y_KEY)) {
                    s = this.dynamic(dish.getStringElement(new String[]{WINDOW_Y_KEY}));
                    y = Integer.parseInt(s);
                }
                if (dish.containsElement(WINDOW_W_KEY)) {
                    s = this.dynamic(dish.getStringElement(new String[]{WINDOW_W_KEY}));
                    w = Integer.parseInt(s);
                }
                if (dish.containsElement(WINDOW_H_KEY)) {
                    s = this.dynamic(dish.getStringElement(new String[]{WINDOW_H_KEY}));
                    h = Integer.parseInt(s);
                }
                Rectangle rectangle = new Rectangle(x, y, w, h);
                ((IWebDriverTable)this.myTable).setRectangle(rectangle);
                return Feedback.yami();
            }
            if (cmd.equals(FLAVOR_NEXT_WINDOW)) {
                for (String winHandle : myWebDriver.getCoreWebDriver().getWindowHandles()) {
                    myWebDriver.getCoreWebDriver().switchTo().window(winHandle);
                    myWebDriver.setChildWindowHandler(winHandle);
                }
                return Feedback.yami();
            }
            if (cmd.equals(FLAVOR_CLOSE_WINDOW)) {
                if (myWebDriver.getChildWindowHandler().isEmpty()) {
                    return Feedback.yaki();
                }
                if (myWebDriver.getCoreWebDriver().getWindowHandles().size() <= 1) {
                    return new Feedback(Feedback.EStatus.YAKI, "The last window cannot be closed.");
                }
                myWebDriver.getCoreWebDriver().closeCurrentWindow();
                myWebDriver.setChildWindowHandler("");
                myWebDriver.getCoreWebDriver().switchTo().window(myWebDriver.getParentWindowHandler());
                return Feedback.yami();
            }
            if (cmd.equals(FLAVOR_CLOSE_OTHERS)) {
                String currentHandle = myWebDriver.getWindowHandle();
                Set handles = myWebDriver.getCoreWebDriver().getWindowHandles();
                handles.remove(currentHandle);
                for (String handle : handles) {
                    myWebDriver.getCoreWebDriver().switchTo().window(handle);
                    myWebDriver.getCoreWebDriver().quit();
                }
                myWebDriver.getCoreWebDriver().switchTo().window(currentHandle);
                myWebDriver.setChildWindowHandler("");
                myWebDriver.setParentWindowHandler("");
                return Feedback.yami();
            }
        }
        catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }
        return Feedback.yaki();
    }

    public String[] getFlavors() {
        return new String[]{FLAVOR_MOVE_RESIZE, FLAVOR_NEXT_WINDOW, FLAVOR_CLOSE_WINDOW, FLAVOR_CLOSE_OTHERS};
    }
}

