/*
 * Decompiled with CFR 0.152.
 */
package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.common.MyEnvironment;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.potluck.ext01.IWebDriverTable;
import com.github.siwenyan.web.Factories;
import com.github.siwenyan.web.core.ICorePoint;
import com.github.siwenyan.web.core.ICoreWebElement;
import com.github.siwenyan.web.core.StaleElementException;

public class GetFieldCorners
extends AbstractSimpleGuest<IWebDriverTable> {
    private static final String FLAVOR_GET_FIELD_Corners = "getFieldCorners";
    private static final String X1_INTO_KEY = "x1Into";
    private static final String Y1_INTO_KEY = "y1Into";
    private static final String X2_INTO_KEY = "x2Into";
    private static final String Y2_INTO_KEY = "y2Into";

    public String help(String flavor) {
        String help = "";
        if (flavor.equals(FLAVOR_GET_FIELD_Corners)) {
            help = help + "  getFieldCorners identifier x1Into=yourVarName y1Into=yourVarName x2Into=yourVarName y2Into=yourVarName;\r\n";
        }
        return help;
    }

    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();
            if (cmd.equals(FLAVOR_GET_FIELD_Corners)) {
                ICorePoint point2;
                ICorePoint point1;
                String identifier = this.dynamic(dish.getStringElement(new String[]{"main"}));
                if (identifier == null || identifier.isEmpty()) {
                    return new Feedback(Feedback.EStatus.FAIL, "Missing identifier.");
                }
                String x1Into = null;
                String y1Into = null;
                String x2Into = null;
                String y2Into = null;
                if (dish.containsElement(X1_INTO_KEY)) {
                    x1Into = this.dynamic(dish.getStringElement(new String[]{X1_INTO_KEY}));
                }
                if (dish.containsElement(Y1_INTO_KEY)) {
                    y1Into = this.dynamic(dish.getStringElement(new String[]{Y1_INTO_KEY}));
                }
                if (dish.containsElement(X2_INTO_KEY)) {
                    x2Into = this.dynamic(dish.getStringElement(new String[]{X2_INTO_KEY}));
                }
                if (dish.containsElement(Y2_INTO_KEY)) {
                    y2Into = this.dynamic(dish.getStringElement(new String[]{Y2_INTO_KEY}));
                }
                if (!this.doGetFieldCorners(identifier, point1 = Factories.web().createPoint(0, 0), point2 = Factories.web().createPoint(0, 0))) {
                    return new Feedback(Feedback.EStatus.FAIL, "Fail to get.");
                }
                MyEnvironment myEnvironment = ((IWebDriverTable)this.myTable).getMyEnvironment();
                if (x1Into != null) {
                    myEnvironment.put(x1Into, (Object)("" + point1.getX()));
                }
                if (y1Into != null) {
                    myEnvironment.put(y1Into, (Object)("" + point1.getY()));
                }
                if (x2Into != null) {
                    myEnvironment.put(x2Into, (Object)("" + point2.getX()));
                }
                if (y2Into != null) {
                    myEnvironment.put(y2Into, (Object)("" + point2.getY()));
                }
                return Feedback.yami();
            }
        }
        catch (StaleElementException e) {
            return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
        }
        catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }
        return Feedback.yaki();
    }

    public String[] getFlavors() {
        return new String[]{FLAVOR_GET_FIELD_Corners};
    }

    private boolean doGetFieldCorners(String identifier, ICorePoint point1, ICorePoint point2) throws StaleElementException {
        ((IWebDriverTable)this.myTable).println("Finding the Field: " + identifier + "...");
        ICoreWebElement field = null;
        field = (ICoreWebElement)((IWebDriverTable)this.myTable).getMyWebDriver().find(identifier).get(0);
        if (field == null) {
            ((IWebDriverTable)this.myTable).println("Field " + identifier + " not found.");
            return false;
        }
        ICorePoint pointInIframe = field.getAbsoluteLocation();
        point1.setX(pointInIframe.getX());
        point1.setY(pointInIframe.getY());
        point2.setX(point1.getX() + field.getSize().getWidth());
        point2.setY(point1.getY() + field.getSize().getHeight());
        return true;
    }
}

