package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.web.Factories;
import com.github.siwenyan.web.core.ICoreUiSelect;
import com.github.siwenyan.web.core.ICoreWebElement;
import com.github.siwenyan.web.core.StaleElementException;

import java.util.List;

public class TryFill extends AbstractSimpleGuest<IWebDriverTable> {

    private static final String FILL_KEY = "fill";

    @Override
    public String help(String flavor) {
        String help = "";

        if (flavor.equals(FILL_KEY)) {
            help += Constants.OUTPUT_INDENT + FILL_KEY + Constants.OUTPUT_FLAVOR_SEPARATOR + "identifier1"
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "value1" + Constants.OUTPUT_PARAM_SEPARATOR
                    + "identifier2" + Constants.OUTPUT_PARAMNAME_SEPARATOR + "value2"
                    + Constants.OUTPUT_PARAM_SEPARATOR + "..." + Constants.OUTPUT_LINE_SEPARATOR + "\r\n";
        }

        return help;
    }

    @Override
    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();

            if (cmd.equals(FILL_KEY)) {

                for (String identifier : dish.getElementKeySet()) {
                    ICoreWebElement el = myTable.getMyWebDriver().find(this.dynamic(identifier)).get(0);
                    String partialValue = this.dynamic(dish.getStringElement(identifier));
                    if (el != null && partialValue != null) {
                        try {
                            el.clear();
                            el.sendKeys(partialValue);
                        } catch (StaleElementException e) {
                            throw e;
                        } catch (Exception e1) {
                            try {
                                ICoreUiSelect select = Factories.web().createUiSelect(el);
                                List<ICoreWebElement> options = select.getOptions();

                                // 1. value equals
                                for (ICoreWebElement option : options) {
                                    String value = option.getAttribute("value");
                                    if (value.equals(partialValue)) {
                                        select.selectByValue(value);
                                        return Feedback.yami();
                                    }
                                }
                                // 2. text equals
                                for (ICoreWebElement option : options) {
                                    String value = option.getAttribute("value");
                                    String text = option.getText();
                                    if (text.equals(partialValue)) {
                                        select.selectByValue(value);
                                        return Feedback.yami();
                                    }
                                }

                                // 3. value contains
                                for (ICoreWebElement option : options) {
                                    String value = option.getAttribute("value");
                                    if (value.contains(partialValue)) {
                                        select.selectByValue(value);
                                        return Feedback.yami();
                                    }
                                }

                                // 4. text contains
                                for (ICoreWebElement option : options) {
                                    String value = option.getAttribute("value");
                                    String text = option.getText();
                                    if (text.contains(partialValue)) {
                                        select.selectByValue(value);
                                        return Feedback.yami();
                                    }
                                }

                                // 5. text matches
                                for (ICoreWebElement option : options) {
                                    String value = option.getAttribute("value");
                                    if (value.matches(partialValue)) {
                                        select.selectByValue(value);
                                        return Feedback.yami();
                                    }
                                }

                                // 6. text matches
                                for (ICoreWebElement option : options) {
                                    String value = option.getAttribute("value");
                                    String text = option.getText();
                                    if (text.matches(partialValue)) {
                                        select.selectByValue(value);
                                        return Feedback.yami();
                                    }
                                }

                                return new Feedback(Feedback.EStatus.FAIL, "No such option: " + partialValue);
                            } catch (StaleElementException e) {
                                throw e;
                            } catch (Exception e2) {
                                return new Feedback(Feedback.EStatus.FAIL, "Fail to fill: " + partialValue);
                            }
                        }
                    } else {
                        return new Feedback(Feedback.EStatus.FAIL, identifier + " is ambiguous or not found.");
                    }
                }

                return Feedback.yami();
            }

        } catch (StaleElementException e) {
            return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
        } catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }

        return Feedback.yaki();
    }

    public String[] getFlavors() {
        return new String[]{FILL_KEY};
    }

}
