package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.web.core.ICoreWebElement;
import com.github.siwenyan.web.core.StaleElementException;

public class TryClick extends AbstractSimpleGuest<IWebDriverTable> {

    private static final String IDENTIFIER_KEY = "identifier";
    private static final String CLICK_KEY = "click";

    @Override
    public String help(String flavor) {
        String help = "";

        if (flavor.equals(CLICK_KEY)) {
            help += Constants.OUTPUT_INDENT + CLICK_KEY + Constants.OUTPUT_FLAVOR_SEPARATOR + IDENTIFIER_KEY
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "id/name/link/partial link/tag/xpath"
                    + Constants.OUTPUT_LINE_SEPARATOR + "\r\n";
        }

        return help;
    }

    @Override
    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();

            if (cmd.equals(CLICK_KEY)) {

                String identifier = this.dynamic(dish.getStringElement(IDENTIFIER_KEY, Constants.DEFAULT_KEY));

                if (identifier == null || identifier.isEmpty()) {
                    return new Feedback(Feedback.EStatus.FAIL, "No identifier specified.");
                } else {
                    ICoreWebElement el = myTable.getMyWebDriver().find(identifier).get(0);
                    if (el != null) {
                        el.click();
                    } else {
                        return new Feedback(Feedback.EStatus.FAIL, identifier + " is ambiguous or not found.");
                    }
                }

                return Feedback.yami();
            }

        } catch (StaleElementException e) {
            return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
        } catch (NullPointerException e) {
            return new Feedback(Feedback.EStatus.FAIL, "Invalid identifier.");
        } catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }

        return Feedback.yaki();
    }

    public String[] getFlavors() {
        return new String[]{CLICK_KEY};
    }

}
