package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.web.core.ICoreWebElement;

public class TestField extends AbstractSimpleGuest<IWebDriverTable> {

    private static final String TEST_FIELD_KEY = "testField";
    private static final String INTO_KEY = "into";
    private static final String TEST_EXIST = "TEST_EXIST";
    private static final String TEST_NOT_EXIST = "TEST_NOT_EXIST";

    @Override
    public String help(String flavor) {
        String help = "";

        if (flavor.equals(TEST_FIELD_KEY)) {
            help += Constants.OUTPUT_INDENT + TEST_FIELD_KEY + Constants.OUTPUT_FLAVOR_SEPARATOR + "identifier"
                    + Constants.OUTPUT_PARAM_SEPARATOR + Constants.OUTPUT_PARAM_SEPARATOR + INTO_KEY
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "yourVariableName" + Constants.OUTPUT_LINE_SEPARATOR
                    + "\r\n";
            help += "Test possible results: [" + TEST_EXIST + "], [" + TEST_NOT_EXIST + "].\r\n";
        }

        return help;
    }

    @Override
    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();

            if (cmd.equals(TEST_FIELD_KEY)) {
                // required identifier
                String identifier = this.dynamic(dish.getStringElement(Constants.DEFAULT_KEY));
                if (identifier == null || identifier.isEmpty()) {
                    return new Feedback(Feedback.EStatus.FAIL, "Missing identifier.");
                }

                // required variableName
                String variableName = this.dynamic(dish.getStringElement(INTO_KEY));
                if (variableName == null || variableName.isEmpty()) {
                    return new Feedback(Feedback.EStatus.FAIL, "Missing " + INTO_KEY + ".");
                }

                doTestField(identifier, variableName);

                return Feedback.yami();
            }
        } catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }

        return Feedback.yaki();
    }

    public String[] getFlavors() {
        return new String[]{TEST_FIELD_KEY};
    }

    private void doTestField(String identifier, String variableName) {

        myTable.println("Finding the Field: " + identifier + "...");

        // get the field value if any
        ICoreWebElement field = null;
        field = myTable.getMyWebDriver().find(identifier).get(0);
        if (field == null) {
            myTable.getMyEnvironment().put(variableName, TEST_NOT_EXIST);
            myTable.println(variableName + "=[" + TEST_NOT_EXIST + "]");
        } else {
            myTable.getMyEnvironment().put(variableName, TEST_EXIST);
            myTable.println(variableName + "=[" + TEST_EXIST + "]");
        }

    }
}
