package com.github.siwenyan.potluck.ext01;


import com.github.siwenyan.common.NGException;
import com.github.siwenyan.dish_parser.BadSmellException;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.dish_parser.ISupply;
import com.github.siwenyan.potluck.AbstractTable;
import com.github.siwenyan.potluck.SimpleDish;
import com.github.siwenyan.potluck.SimpleTable;
import com.github.siwenyan.potluck.TableStatus;
import com.github.siwenyan.web.core.MyWebDriver;
import org.apache.log4j.Logger;

import java.awt.*;
import java.net.MalformedURLException;
import java.util.LinkedHashMap;
import java.util.Map;

public class SimpleWebDriverTable extends SimpleTable implements IWebDriverTable {

    private static final Logger log = Logger.getLogger(SimpleWebDriverTable.class.getName());

    private MyWebDriver myWebDriver = null;
    private Rectangle rectangle = null;

    @Override
    public IDish defaultCook(ISupply oneSupply) throws BadSmellException {
        return SimpleDish.cook(oneSupply);
    }

    @Override
    public void replaceDriver(Map<String, Object> options) throws NGException {
        if (null != this.myWebDriver) {
            this.myWebDriver.stop();
        }

        if (null == options || 0 == options.size()) {
            if (null == this.myWebDriver) {
                options = new LinkedHashMap<>();
            } else {
                options = this.myWebDriver.getOptions();
            }
        }
        try {
            this.myWebDriver = new MyWebDriver(options);
        } catch (MalformedURLException e) {
            throw new NGException(e.getMessage());
        }
    }

    @Override
    public MyWebDriver getMyWebDriver() {
        return myWebDriver;
    }

    @Override
    public void maxSize() {

        try {
            this.getMyWebDriver().getCoreWebDriver().manage().window().maximize();
        } catch (Exception e) {
            log.warn("Not able to max size: " + e.getMessage());
        }
    }

    @Override
    public Rectangle getRectangle() {
        return rectangle;
    }

    @Override
    public void setRectangle(Rectangle rectangle) throws NGException {
        this.rectangle = rectangle;

        myWebDriver.setRectangle(rectangle);

    }

    @Override
    public boolean stop() {
        synchronized (supplyLock) {
            try {
                if (null != this.myWebDriver) {
                    this.myWebDriver.stop();
                }
            } finally {
                this.myWebDriver = null;
                return super.stop();
            }

        }
    }
}
