package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.common.StringTools;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.web.LayoutHelper;
import com.github.siwenyan.web.LayoutOfLocatorNames;
import com.github.siwenyan.web.WebUtils;
import com.github.siwenyan.web.core.ICoreWebElement;
import com.github.siwenyan.web.core.StaleElementException;

import java.awt.*;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ShowElements extends AbstractSimpleGuest<IWebDriverTable> {

    private static final String IDENTIFIER_KEY = "identifier";
    private static final String CHOSEN_KEY = "chosen";
    private static final String ID_VAR_KEY = "idVar";
    private static final String TEXT_VAR_KEY = "textVar";
    private static final String VALUE_VAR_KEY = "valueVar";
    private static final String ATTRIBUTE_KEY = "attribute";
    private static final String PAGE_OBJECT_KEY = "pageObject";
    private static final String CROP_KEY = "crop";

    private static final String SHOW_ELEMENTS_FLAVOR = "showElements";
    private static final String SHOW_ELEMENTS_BY_POSITION_FLAVOR = "showElementsByPosition";

    private List<ICoreWebElement> els = null;

    @Override
    public String help(String flavor) {
        String help = "";

        if (flavor.equals(SHOW_ELEMENTS_FLAVOR)) {
            help += Constants.OUTPUT_INDENT + SHOW_ELEMENTS_FLAVOR + Constants.OUTPUT_FLAVOR_SEPARATOR
                    + "yourIdentifier" + Constants.OUTPUT_PARAM_SEPARATOR + CHOSEN_KEY
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "chosenIndex" + Constants.OUTPUT_PARAM_SEPARATOR
                    + ID_VAR_KEY + Constants.OUTPUT_PARAMNAME_SEPARATOR + "yourIdVariable"
                    + Constants.OUTPUT_PARAM_SEPARATOR + TEXT_VAR_KEY + Constants.OUTPUT_PARAMNAME_SEPARATOR
                    + "yourTextVariable" + Constants.OUTPUT_PARAM_SEPARATOR + VALUE_VAR_KEY
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "yourValueVariable" + Constants.OUTPUT_LINE_SEPARATOR
                    + "\r\n";
        } else if (flavor.equals(SHOW_ELEMENTS_BY_POSITION_FLAVOR)) {
            help += Constants.OUTPUT_INDENT + SHOW_ELEMENTS_BY_POSITION_FLAVOR + Constants.OUTPUT_FLAVOR_SEPARATOR
                    + "yourIdentifier" + Constants.OUTPUT_PARAM_SEPARATOR + ATTRIBUTE_KEY
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "yourAttribute" + Constants.OUTPUT_PARAM_SEPARATOR
                    + PAGE_OBJECT_KEY + Constants.OUTPUT_PARAMNAME_SEPARATOR + "yourPageObjectName"
                    + Constants.OUTPUT_PARAM_SEPARATOR + CROP_KEY + Constants.OUTPUT_PARAMNAME_SEPARATOR
                    + "x1:y1:x2:y2^element1^x1:y1:x2:y2^element2^..." + Constants.OUTPUT_LINE_SEPARATOR
                    + "\r\n";
        }

        return help;
    }

    @Override
    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();

            if (cmd.equals(SHOW_ELEMENTS_FLAVOR)) {

                String xpath = this.dynamic(dish.getStringElement(IDENTIFIER_KEY, Constants.DEFAULT_KEY));
                int iChosen = StringTools.parsePositiveInteger(dish.getStringElement(CHOSEN_KEY));
                String idVar = dish.getStringElement(ID_VAR_KEY);
                String textVar = dish.getStringElement(TEXT_VAR_KEY);
                String valueVar = dish.getStringElement(VALUE_VAR_KEY);

                List<ICoreWebElement> els = myTable.getMyWebDriver().getCoreWebDriver().find(xpath, true);

                // int x0 = myTable.getMyWebDriver().getCurrentIFrameX();
                // int y0 = myTable.getMyWebDriver().getCurrentIFrameY();
                String tmp = "";
                int count = 0;
                Rectangle recUnion = null;
                for (ICoreWebElement el : els) {
                    count++;

                    Rectangle rec = WebUtils.getWebRectangle(el);
                    recUnion = recUnion == null ? rec : recUnion.union(rec);

                    tmp += "\r\n" + StringTools.padRight(count + ".", 4, ' ');

                    String id = el.getAttribute("id");
                    tmp += StringTools.padRight("id=[" + id + "]", 50, ' ');

                    String text = el.getText();
                    tmp += StringTools.padRight("text=[" + text + "]", 50, ' ');

                    String value = el.getAttribute("value");
                    tmp += StringTools.padRight("value=[" + value + "]", 60, ' ');

                    String string = el.toString();
                    tmp += StringTools.padRight("string=[" + string + "]", 60, ' ');

                    if (iChosen == count) {
                        if (idVar != null && !idVar.isEmpty()) {
                            this.myTable.getMyEnvironment().put(idVar, id);
                        }

                        if (textVar != null && !textVar.isEmpty()) {
                            this.myTable.getMyEnvironment().put(textVar, text);
                        }

                        if (valueVar != null && !valueVar.isEmpty()) {
                            this.myTable.getMyEnvironment().put(valueVar, value);
                        }
                    }
                }

                int minX1 = recUnion.x;
                int minY1 = recUnion.y;
                int maxX2 = minX1 + recUnion.width;
                int maxY2 = minY1 + recUnion.height;
                tmp += "\r\n\r\n";
                tmp += StringTools.padRight("x1=[" + minX1 + "]", 15, ' ');
                tmp += StringTools.padRight("y1=[" + minY1 + "]", 15, ' ');
                tmp += StringTools.padRight("x2=[" + maxX2 + "]", 15, ' ');
                tmp += StringTools.padRight("y2=[" + maxY2 + "]", 15, ' ');
                this.myTable.println(tmp);
                return Feedback.yami();
            } else if (cmd.equals(SHOW_ELEMENTS_BY_POSITION_FLAVOR)) {

                String xpath = this.dynamic(dish.getStringElement(IDENTIFIER_KEY, Constants.DEFAULT_KEY));

                if (xpath.isEmpty()) {
                    if (null == els) {
                        return Feedback.yaki("Missing " + IDENTIFIER_KEY);
                    }
                } else {
                    els = myTable.getMyWebDriver().getCoreWebDriver().find(xpath, true);
                }

                Map<Rectangle, ICoreWebElement> elByRec = new LinkedHashMap<>(els.size());
                String sRec = this.dynamic(dish.getStringElement(CROP_KEY));
                Rectangle crop = sRec.isEmpty() ? null : WebUtils.toRectangle(myTable.getMyWebDriver(), sRec);
                LayoutHelper layoutHelper = new LayoutHelper(crop);
                for (ICoreWebElement el : els) {
                    if (el.isDisplayed()) {
                        Rectangle rec = WebUtils.getWebRectangle(el);
                        elByRec.put(rec, el);
                        layoutHelper.addRectangle(rec);
                    }
                }

                Rectangle[][] layout = layoutHelper.layout();

                String att = dish.getStringElement(ATTRIBUTE_KEY);
                if (!att.isEmpty()) {
                    String s = layoutString(elByRec, layout, att);
                    myTable.print(s);
                }

                String pageObject = dish.getStringElement(PAGE_OBJECT_KEY);
                if (!pageObject.isEmpty()) {
                    int lastDot = pageObject.lastIndexOf('.');
                    String packageName = pageObject.substring(0, lastDot);
                    String className = pageObject.substring(lastDot + 1);
                    LayoutOfLocatorNames layoutOfLocatorNames = new LayoutOfLocatorNames(elByRec, layout, packageName, className);

                    myTable.println(layoutOfLocatorNames.toString());

                    myTable.println(layoutOfLocatorNames.toPageObject());
                }

                return Feedback.yami();
            }

        } catch (StaleElementException e) {
            return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
        } catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }

        return Feedback.yaki();
    }

    private String layoutString(Map<Rectangle, ICoreWebElement> elByRec, Rectangle[][] layout, String att) throws StaleElementException {
        String s = "\n";
        for (int row = 0; row < layout.length; row++) {
            s += "|";
            Rectangle[] oneRow = layout[row];
            for (int col = 0; col < oneRow.length; col++) {
                Rectangle rec = layout[row][col];
                if (null == rec) {
                    s += " |";
                } else {
                    String attValue = null;
                    if ("text".equals(att)) {
                        String text = elByRec.get(rec).getText();
                        if (null == text) {
                            attValue = "";
                        } else {
                            attValue = text.replaceAll("\n", "").trim();
                        }
                    } else {
                        String text = elByRec.get(rec).getAttribute(att);
                        if (null == text) {
                            attValue = "";
                        } else {
                            attValue = text.replaceAll("\n", "").trim();
                        }
                    }
                    s += attValue + "|";
                }
            }
            s += "\n";
        }
        return s;
    }

    public String[] getFlavors() {
        return new String[]{SHOW_ELEMENTS_FLAVOR, SHOW_ELEMENTS_BY_POSITION_FLAVOR};
    }

}
