package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.common.NGException;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.web.Factories;
import com.github.siwenyan.web.core.*;

import java.util.Set;
import java.util.TreeSet;

public class SendKey extends AbstractSimpleGuest<IWebDriverTable> {

    private static final String SEND_KEY = "sendKey";
    private static final String SEQUENCE_KEY_PREFIX = "seq";
    private static final String HINT_KEY_DOWN = "keyDown";
    private static final String HINT_KEY_UP = "keyUp";
    private static final String HINT_SEND_KEY = "sendKey";
    private static final String HINT_SEPARATOR = ":";

    @Override
    public String help(String flavor) {
        String help = "";

        if (flavor.equals(SEND_KEY)) {
            help += Constants.OUTPUT_INDENT + SEND_KEY + Constants.OUTPUT_FLAVOR_SEPARATOR
                    + "[optionalTargetElement]" + Constants.OUTPUT_PARAM_SEPARATOR + SEQUENCE_KEY_PREFIX + "1"
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "hint1" + HINT_SEPARATOR + "keys1"
                    + Constants.OUTPUT_PARAM_SEPARATOR + SEQUENCE_KEY_PREFIX + "2"
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "hint2" + HINT_SEPARATOR + "keys2"
                    + Constants.OUTPUT_PARAM_SEPARATOR + SEQUENCE_KEY_PREFIX + "..."
                    + Constants.OUTPUT_LINE_SEPARATOR + "\r\n";
            help += Constants.OUTPUT_INDENT + "Possible hints: " + "[" + HINT_KEY_DOWN + ", " + HINT_KEY_UP + ", "
                    + HINT_SEND_KEY + "]\r\n";
            help += Constants.OUTPUT_INDENT + "For hints " + "[" + HINT_KEY_DOWN + ", " + HINT_KEY_UP + "]"
                    + ": Possible keys are: " + toStringEnumKeys() + "\r\n";
            help += Constants.OUTPUT_INDENT + "For OPTIONAL hint " + "[" + HINT_SEND_KEY + "]"
                    + ": it could be any charactor sequence " + toStringEnumKeys() + "\r\n";
        }

        return help;
    }

    private String toStringEnumKeys() {
        String s = "[";
        for (ECoreKeys key : ECoreKeys.values()) {
            s += key.name() + ",";
        }
        s += "]";
        return s;
    }

    @Override
    public Feedback have(IDish dish) {
        try {
            MyWebDriver myWebDriver = myTable.getMyWebDriver();
            String cmd = dish.getFlavor().getFlavorName();

            if (cmd.equals(SEND_KEY)) {
                ICoreWebElement el = null;

                if (dish.containsElement(Constants.DEFAULT_KEY)) {
                    String sel = this.dynamic(dish.getStringElement(Constants.DEFAULT_KEY));
                    el = this.myTable.getMyWebDriver().find(sel).get(0);
                    if (el == null) {
                        return new Feedback(Feedback.EStatus.FAIL, "No such element: " + sel);
                    }
                }

                ICoreInteractionActions builder = Factories.web().createActions(myWebDriver.getCoreWebDriver());

                Set<String> orderedKeySet = new TreeSet<String>(dish.getElementKeySet());
                for (String key : orderedKeySet) {
                    String keysWithHint = this.dynamic(dish.getStringElement(key));
                    if (key.startsWith(SEQUENCE_KEY_PREFIX)) {
                        sendKey(builder, el, keysWithHint);
                    }
                }

                builder.build().perform();

                return Feedback.yami();
            }

        } catch (StaleElementException e) {
            return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
        } catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }

        return Feedback.yaki();
    }

    private void sendKey(ICoreInteractionActions builder, ICoreWebElement el, String keysWithHint)
            throws NGException, StaleElementException {
        String[] pair = keysWithHint.split(HINT_SEPARATOR, 2);
        if (pair.length == 1) {
            doSendKey(builder, el, pair[0]);
        } else if (pair.length == 2) {
            if (pair[0].equals(HINT_SEND_KEY)) {
                doSendKey(builder, el, pair[1]);
            } else if (pair[0].equals(HINT_KEY_DOWN)) {
                doKeyDown(builder, el, pair[1]);
            } else if (pair[0].equals(HINT_KEY_UP)) {
                doKeyUp(builder, el, pair[1]);
            }
        } else {
            throw new NGException("Wrong keys: " + keysWithHint);
        }
    }

    private void doKeyUp(ICoreInteractionActions builder, ICoreWebElement el, String keysToSend)
            throws StaleElementException {
        if (el == null) {
            builder.keyUp(ECoreKeys.valueOf(keysToSend));
        } else {
            builder.keyUp(el, ECoreKeys.valueOf(keysToSend));
        }

    }

    private void doKeyDown(ICoreInteractionActions builder, ICoreWebElement el, String keysToSend)
            throws StaleElementException {
        if (el == null) {
            builder.keyDown(ECoreKeys.valueOf(keysToSend));
        } else {
            builder.keyDown(el, ECoreKeys.valueOf(keysToSend));
        }

    }

    private void doSendKey(ICoreInteractionActions builder, ICoreWebElement el, String keysToSend)
            throws StaleElementException {
        if (el == null) {
            builder.sendKeys(keysToSend);
        } else {
            builder.sendKeys(el, keysToSend);
        }

    }

    public String[] getFlavors() {
        return new String[]{SEND_KEY};
    }

}
