package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.web.core.MyWebDriver;

public class OpenURL extends AbstractSimpleGuest<IWebDriverTable> {

	private static final String URL_KEY = "url";
	private static final String OPEN_KEY = "open";

	@Override
	public String help(String flavor) {
		String help = "\r\n";

		if (flavor.equals(OPEN_KEY)) {
			help += Constants.OUTPUT_INDENT + OPEN_KEY + Constants.OUTPUT_FLAVOR_SEPARATOR + URL_KEY
					+ Constants.OUTPUT_PARAMNAME_SEPARATOR + "https://www.google.com/#q=peoplesoft"
					+ Constants.OUTPUT_LINE_SEPARATOR + "\r\n";
		}

		return help;
	}

	@Override
	public Feedback have(IDish dish) {
		try {
			MyWebDriver myWebDriver = myTable.getMyWebDriver();
			String cmd = dish.getFlavor().getFlavorName();

			if (cmd.equals(OPEN_KEY)) {
				String url = this.dynamic(dish.getStringElement(URL_KEY, Constants.DEFAULT_KEY));

				if (url == null || url.isEmpty()) {
					return new Feedback(Feedback.EStatus.FAIL, "URL not specified.");
				} else {
					myWebDriver.getCoreWebDriver().get(url);

					return Feedback.yami();
				}
			}

		} catch (Exception e) {
			return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
		}

		return Feedback.yaki();
	}

	public String[] getFlavors() {
		return new String[] { OPEN_KEY };
	}

}
