package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.web.core.ICoreDimension;
import com.github.siwenyan.web.core.ICorePoint;
import com.github.siwenyan.web.core.MyWebDriver;

import java.awt.*;
import java.util.Set;

public class GuestWindow extends AbstractSimpleGuest<IWebDriverTable> {
    private static final String FLAVOR_MOVE_RESIZE = "moveAndResize";
    private static final String FLAVOR_NEXT_WINDOW = "nextWindow";
    private static final String FLAVOR_CLOSE_WINDOW = "closeWindow";
    private static final String FLAVOR_CLOSE_OTHERS = "closeOthers";

    private static final String WINDOW_X_KEY = "x";
    private static final String WINDOW_Y_KEY = "y";
    private static final String WINDOW_W_KEY = "width";
    private static final String WINDOW_H_KEY = "height";

    @Override
    public String help(String flavor) {
        String help = "";

        if (flavor.equals(FLAVOR_MOVE_RESIZE)) {
            help += Constants.OUTPUT_INDENT + FLAVOR_MOVE_RESIZE + Constants.OUTPUT_FLAVOR_SEPARATOR + WINDOW_X_KEY
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "integer" + Constants.OUTPUT_PARAM_SEPARATOR
                    + WINDOW_Y_KEY + Constants.OUTPUT_PARAMNAME_SEPARATOR + "integer"
                    + Constants.OUTPUT_PARAM_SEPARATOR + WINDOW_W_KEY + Constants.OUTPUT_PARAMNAME_SEPARATOR
                    + "integer" + Constants.OUTPUT_PARAM_SEPARATOR + WINDOW_H_KEY
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "integer" + Constants.OUTPUT_PARAM_SEPARATOR
                    + Constants.OUTPUT_LINE_SEPARATOR + "\r\n" + Constants.OUTPUT_INDENT + Constants.OUTPUT_INDENT
                    + "Description: to move and/or resize a browser.\r\n";
        }

        if (flavor.equals(FLAVOR_NEXT_WINDOW)) {
            help += Constants.OUTPUT_INDENT + FLAVOR_NEXT_WINDOW + Constants.OUTPUT_LINE_SEPARATOR + "\r\n"
                    + Constants.OUTPUT_INDENT + Constants.OUTPUT_INDENT
                    + "Description: switch to the next openned window.\r\n";

        }

        if (flavor.equals(FLAVOR_CLOSE_WINDOW)) {
            help += Constants.OUTPUT_INDENT + FLAVOR_CLOSE_WINDOW + Constants.OUTPUT_LINE_SEPARATOR + "\r\n"
                    + Constants.OUTPUT_INDENT + Constants.OUTPUT_INDENT
                    + "Description: close the current window. Not applicable to the parent window.r\n";

        }

        if (flavor.equals(FLAVOR_CLOSE_OTHERS)) {
            help += Constants.OUTPUT_INDENT + FLAVOR_CLOSE_OTHERS + Constants.OUTPUT_LINE_SEPARATOR + "\r\n"
                    + Constants.OUTPUT_INDENT + Constants.OUTPUT_INDENT + "Description: close other windows.\r\n";

        }

        return help;
    }

    @Override
    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();
            MyWebDriver myWebDriver = myTable.getMyWebDriver();
            if (cmd.equals(FLAVOR_MOVE_RESIZE)) {
                ICorePoint pos = myWebDriver.getCoreWebDriver().manage().window().getPosition();
                ICoreDimension size = myWebDriver.getCoreWebDriver().manage().window().getSize();
                int x = pos.getX();
                int y = pos.getY();
                int w = size.getWidth();
                int h = size.getHeight();
                if (dish.containsElement(WINDOW_X_KEY)) {
                    String s = this.dynamic(dish.getStringElement(WINDOW_X_KEY));
                    x = Integer.parseInt(s);
                }
                if (dish.containsElement(WINDOW_Y_KEY)) {
                    String s = this.dynamic(dish.getStringElement(WINDOW_Y_KEY));
                    y = Integer.parseInt(s);
                }
                if (dish.containsElement(WINDOW_W_KEY)) {
                    String s = this.dynamic(dish.getStringElement(WINDOW_W_KEY));
                    w = Integer.parseInt(s);
                }
                if (dish.containsElement(WINDOW_H_KEY)) {
                    String s = this.dynamic(dish.getStringElement(WINDOW_H_KEY));
                    h = Integer.parseInt(s);
                }

                Rectangle rectangle = new Rectangle(x, y, w, h);
                this.myTable.setRectangle(rectangle);

                return Feedback.yami();
            }

            if (cmd.equals(FLAVOR_NEXT_WINDOW)) {
                for (String winHandle : myWebDriver.getCoreWebDriver().getWindowHandles()) {
                    myWebDriver.getCoreWebDriver().switchTo().window(winHandle);
                    myWebDriver.setChildWindowHandler(winHandle);
                }
                return Feedback.yami();
            }

            if (cmd.equals(FLAVOR_CLOSE_WINDOW)) {
                if (myWebDriver.getChildWindowHandler().isEmpty()) {
                    return Feedback.yaki();
                }

                if (myWebDriver.getCoreWebDriver().getWindowHandles().size() > 1) {
                    myWebDriver.getCoreWebDriver().closeCurrentWindow();
                    myWebDriver.setChildWindowHandler("");
                    myWebDriver.getCoreWebDriver().switchTo().window(myWebDriver.getParentWindowHandler());
                } else {
                    return new Feedback(Feedback.EStatus.YAKI, "The last window cannot be closed.");
                }
                return Feedback.yami();
            }

            if (cmd.equals(FLAVOR_CLOSE_OTHERS)) {
                String currentHandle = myWebDriver.getWindowHandle();
                Set<String> handles = myWebDriver.getCoreWebDriver().getWindowHandles();
                handles.remove(currentHandle);
                for (String handle : handles) {
                    myWebDriver.getCoreWebDriver().switchTo().window(handle);
                    myWebDriver.getCoreWebDriver().quit();
                }
                myWebDriver.getCoreWebDriver().switchTo().window(currentHandle);
                myWebDriver.setChildWindowHandler("");
                myWebDriver.setParentWindowHandler("");

                return Feedback.yami();
            }

        } catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }

        return Feedback.yaki();
    }

    public String[] getFlavors() {
        return new String[]{FLAVOR_MOVE_RESIZE, FLAVOR_NEXT_WINDOW, FLAVOR_CLOSE_WINDOW, FLAVOR_CLOSE_OTHERS};
    }

}
