package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.web.core.ICoreWebElement;

import java.util.List;

public class ClickAll extends AbstractSimpleGuest<IWebDriverTable> {

    private static final String IDENTIFIER_KEY = "identifier";
    private static final String CLICK_ALL = "clickAll";

    @Override
    public String help(String flavor) {
        String help = "";

        if (flavor.equals(CLICK_ALL)) {
            help += Constants.OUTPUT_INDENT + CLICK_ALL + Constants.OUTPUT_FLAVOR_SEPARATOR + IDENTIFIER_KEY
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "id/name/link/partial link/tag/xpath"
                    + Constants.OUTPUT_LINE_SEPARATOR + "\r\n";
        }

        return help;
    }

    @Override
    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();

            if (cmd.equals(CLICK_ALL)) {

                String identifier = this.dynamic(dish.getStringElement(IDENTIFIER_KEY, Constants.DEFAULT_KEY));

                if (identifier == null || identifier.isEmpty()) {
                    return new Feedback(Feedback.EStatus.FAIL, "No identifier specified.");
                } else {
                    List<ICoreWebElement> els = myTable.getMyWebDriver().find(identifier);
                    while (null != els && els.size() > 0) {
                        //TODO: strange to put a null in to the list
                        if (1 == els.size() && null == els.get(0)) {
                            break;
                        }
                        for (ICoreWebElement el : els) {
                            try {
                                if (el.isDisplayed())
                                    try {
                                        el.click();
                                    } catch (Exception e) {
                                        myTable.getMyWebDriver().getCoreWebDriver().executeScript("window.scrollTo(0, 0)");
                                    }
                            } catch (Exception e) {
                                // do nothing
                            }
                        }
                        myTable.getMyWebDriver().getCoreWebDriver().clearBuffer();
                        els = myTable.getMyWebDriver().find(identifier);
                    }
                }

                return Feedback.yami();
            }

        } catch (
                NullPointerException e) {
            return new Feedback(Feedback.EStatus.FAIL, "Invalid identifier.");
        } catch (
                Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }

        return Feedback.yaki();
    }

    public String[] getFlavors() {
        return new String[]{CLICK_ALL};
    }

}
