package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.web.core.ICoreAlert;
import com.github.siwenyan.web.core.MyWebDriver;

public class AlertText extends AbstractSimpleGuest<IWebDriverTable> {

	private static final String FLAVOR_GET_ALERT_TEXT = "getAlertText";
	private static final String KEY_INTO = "into";

	@Override
	public String help(String flavor) {
		String help = "";

		if (flavor.equals(FLAVOR_GET_ALERT_TEXT)) {
			help += Constants.OUTPUT_INDENT + FLAVOR_GET_ALERT_TEXT + Constants.OUTPUT_FLAVOR_SEPARATOR + KEY_INTO
					+ Constants.OUTPUT_PARAMNAME_SEPARATOR + "yourVarName" + Constants.OUTPUT_LINE_SEPARATOR + "\r\n";
		}

		return help;
	}

	@Override
	public Feedback have(IDish dish) {
		try {
			MyWebDriver myWebDriver = myTable.getMyWebDriver();
			String cmd = dish.getFlavor().getFlavorName();

			if (cmd.equals(FLAVOR_GET_ALERT_TEXT)) {
				String into = dish.getStringElement(KEY_INTO);
				if (into.isEmpty()) {
					return Feedback.yaki("Missing parameter: " + KEY_INTO);
				}

				ICoreAlert alert = myWebDriver.getCoreWebDriver().switchTo().alert();
				String text = alert.getText();
				myWebDriver.getCoreWebDriver().switchTo().defaultContent();

				this.myTable.getMyEnvironment().put(into, text);
				return Feedback.yami();
			}

		} catch (Exception e) {
			return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
		}

		return Feedback.yaki();
	}

	public String[] getFlavors() {
		return new String[] { FLAVOR_GET_ALERT_TEXT };
	}

}
