/*
 * Decompiled with CFR 0.152.
 */
package com.github.sisyphsu.retree;

import com.github.sisyphsu.retree.Node;
import com.github.sisyphsu.retree.ReMatcher;

public final class LoopNode
extends Node {
    private static final long BACK_FLAG = 0x2000000000000000L;
    final int type;
    final int minTimes;
    final int maxTimes;
    Node body;
    private final int timesVar;

    public LoopNode(Node head, Node tail, int cmin, int cmax, int type, int localOffset) {
        this.body = head;
        this.type = type;
        this.minTimes = cmin;
        this.maxTimes = cmax;
        this.timesVar = localOffset;
        tail.next = this;
    }

    @Override
    public void study() {
        if (this.minInput < 0) {
            this.minInput = 0;
            this.body.study();
            this.next.study();
            this.minInput = this.next.minInput + this.body.minInput * this.minTimes;
        }
    }

    @Override
    public boolean alike(Node node) {
        if (node instanceof LoopNode) {
            if (this.type != ((LoopNode)node).type) {
                return false;
            }
            if (this.minTimes != ((LoopNode)node).minTimes) {
                return false;
            }
            if (this.maxTimes != ((LoopNode)node).maxTimes) {
                return false;
            }
            if (this.timesVar != ((LoopNode)node).timesVar) {
                return false;
            }
            return this.body.alike(((LoopNode)node).body);
        }
        return false;
    }

    @Override
    public boolean match(ReMatcher matcher, CharSequence input, int cursor) {
        long var = matcher.loopVars[this.timesVar];
        if (var < 0L) {
            matcher.loopVars[this.timesVar] = 0L;
        }
        boolean result = this.doMatch(matcher, input, cursor);
        if (var < 0L) {
            matcher.loopVars[this.timesVar] = -1L;
        }
        return result;
    }

    private boolean doMatch(ReMatcher matcher, CharSequence input, int cursor) {
        boolean preEmpty;
        long var = matcher.loopVars[this.timesVar];
        int times = (int)(var & 0x3FFFFFFFL);
        int offset = (int)(var >>> 30 & 0x3FFFFFFFL);
        int rest = matcher.to - cursor;
        boolean bl = preEmpty = times > 0 && cursor == offset;
        if (times < this.minTimes) {
            if (preEmpty || rest < this.body.minInput + this.next.minInput) {
                return false;
            }
            matcher.loopVars[this.timesVar] = (long)times + 1L | (long)cursor << 30;
            return this.body.match(matcher, input, cursor);
        }
        if (this.type == 1) {
            matcher.loopVars[this.timesVar] = -1L;
            if (this.next.match(matcher, input, cursor)) {
                return true;
            }
            if (preEmpty || rest < this.body.minInput) {
                return false;
            }
            matcher.loopVars[this.timesVar] = (long)times + 1L | (long)cursor << 30;
            return this.body.match(matcher, input, cursor);
        }
        if (!preEmpty && times < this.maxTimes && rest >= this.body.minInput) {
            matcher.loopVars[this.timesVar] = (long)times + 1L | (long)cursor << 30;
            if (this.body.match(matcher, input, cursor)) {
                return true;
            }
        }
        if (this.type != 2) {
            matcher.loopVars[this.timesVar] = -1L;
            return this.next.match(matcher, input, cursor);
        }
        if ((matcher.loopVars[this.timesVar] & 0x2000000000000000L) != 0L) {
            return false;
        }
        matcher.loopVars[this.timesVar] = -1L;
        if (this.next.match(matcher, input, cursor)) {
            return true;
        }
        matcher.loopVars[this.timesVar] = var | 0x2000000000000000L;
        return false;
    }
}

