/*
 * Decompiled with CFR 0.152.
 */
package com.github.sisyphsu.retree;

import com.github.sisyphsu.retree.Node;
import com.github.sisyphsu.retree.ReMatcher;

public final class GroupNode
extends Node {
    final Node tailNode;
    private final int groupIndex;
    private final int groupStartIndex;
    private final int groupEndIndex;

    public GroupNode(int groupIndex) {
        this.groupIndex = groupIndex;
        if (groupIndex > 0) {
            this.groupStartIndex = groupIndex * 2;
            this.groupEndIndex = groupIndex * 2 + 1;
        } else {
            this.groupStartIndex = 0;
            this.groupEndIndex = 0;
        }
        this.tailNode = new Tail();
    }

    @Override
    public boolean match(ReMatcher matcher, CharSequence input, int cursor) {
        int startOff = matcher.groupVars[this.groupStartIndex];
        int endOff = matcher.groupVars[this.groupEndIndex];
        matcher.groupVars[this.groupStartIndex] = cursor;
        boolean succ = this.next.match(matcher, input, cursor);
        if (!succ) {
            matcher.groupVars[this.groupStartIndex] = startOff;
            matcher.groupVars[this.groupEndIndex] = endOff;
        }
        return succ;
    }

    @Override
    public boolean alike(Node node) {
        if (node instanceof GroupNode) {
            return this.groupIndex == ((GroupNode)node).groupIndex;
        }
        return false;
    }

    boolean isAnonymous() {
        return this.groupIndex == 0;
    }

    public class Tail
    extends Node {
        @Override
        public boolean match(ReMatcher matcher, CharSequence input, int cursor) {
            matcher.groupVars[((GroupNode)GroupNode.this).groupEndIndex] = cursor;
            if (this.next == null) {
                matcher.last = cursor;
                return true;
            }
            return this.next.match(matcher, input, cursor);
        }

        @Override
        public boolean alike(Node node) {
            return node instanceof Tail;
        }

        boolean isAnonymous() {
            return GroupNode.this.isAnonymous();
        }
    }
}

