/*
 * Decompiled with CFR 0.152.
 */
package com.github.sisyphsu.retree;

import com.github.sisyphsu.retree.Node;
import com.github.sisyphsu.retree.ReMatcher;
import java.util.Arrays;

public class CharSliceNode
extends Node {
    int[] chars;

    public CharSliceNode(int[] chars) {
        this.chars = chars;
    }

    @Override
    public void study() {
        if (this.minInput >= 0) {
            return;
        }
        this.minInput = this.chars.length;
        if (this.next != null) {
            this.next.study();
            this.minInput += this.next.minInput;
        }
    }

    @Override
    public boolean match(ReMatcher matcher, CharSequence input, int cursor) {
        if (matcher.to - cursor < this.minInput) {
            return false;
        }
        for (int i = 0; i < this.chars.length; ++i) {
            if (this.chars[i] == input.charAt(cursor + i)) continue;
            return false;
        }
        if (this.next == null) {
            matcher.last = cursor + this.chars.length;
            return true;
        }
        return this.next.match(matcher, input, cursor + this.chars.length);
    }

    @Override
    public boolean alike(Node node) {
        return node instanceof CharSliceNode && Arrays.equals(this.chars, ((CharSliceNode)node).chars);
    }
}

