/*
 * Decompiled with CFR 0.152.
 */
package com.github.sisyphsu.retree;

import com.github.sisyphsu.retree.Node;
import com.github.sisyphsu.retree.ReMatcher;

public final class BoundNode
extends Node {
    public static int NON_WORD = 0;
    public static int WORD = 1;
    private final int type;

    public BoundNode(int n) {
        this.type = n;
    }

    @Override
    public boolean match(ReMatcher matcher, CharSequence input, int cursor) {
        boolean leftIsWord = false;
        boolean rightIsWord = false;
        if (cursor > matcher.from) {
            leftIsWord = this.isWord(Character.codePointBefore(input, cursor));
        }
        if (cursor < matcher.to) {
            rightIsWord = this.isWord(Character.codePointAt(input, cursor));
        }
        if (this.type == WORD && leftIsWord == rightIsWord) {
            return false;
        }
        if (this.type == NON_WORD && leftIsWord != rightIsWord) {
            return false;
        }
        if (this.next == null) {
            matcher.last = cursor;
            return true;
        }
        return this.next.match(matcher, input, cursor);
    }

    private boolean isWord(int ch) {
        return ch == 95 || Character.isLetterOrDigit(ch);
    }

    @Override
    public boolean alike(Node node) {
        if (node instanceof BoundNode) {
            return ((BoundNode)node).type == this.type;
        }
        return false;
    }
}

