/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.mockeri.meta;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.sindaryn.datafi.annotations.NonCascadeUpdatable;
import org.sindaryn.datafi.annotations.NonCascadeUpdatables;
import org.sindaryn.datafi.reflection.CachedEntityType;
import org.sindaryn.datafi.reflection.ReflectionCache;
import org.sindaryn.mockeri.StaticUtils;
import org.sindaryn.mockeri.annotations.MockData;
import org.sindaryn.mockeri.annotations.NonMockable;
import org.sindaryn.mockeri.annotations.NonNullable;
import org.sindaryn.mockeri.meta.CircularReferenceException;
import org.sindaryn.mockeri.meta.CollectionInstantiator;
import org.sindaryn.mockeri.meta.FieldMetaInfo;
import org.sindaryn.mockeri.meta.FieldReferenceType;
import org.sindaryn.mockeri.meta.MockDataSource;
import org.sindaryn.mockeri.service.KEYWORD;
import org.sindaryn.mockeri.service.NullMockFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FieldMetaInfoFactory {
    @Autowired
    private ReflectionCache reflectionCache;
    @Autowired
    private CollectionInstantiator collectionInstantiator;
    private Map<Field, FieldMetaInfo> cache = new HashMap<Field, FieldMetaInfo>();

    public FieldMetaInfo fieldMetaInfo(Object parent, Field field) {
        if (this.cache.get(field) != null) {
            return this.cache.get(field);
        }
        FieldMetaInfo fieldMetaInfo = new FieldMetaInfo();
        fieldMetaInfo.setToInstantiate(this.determineInstantiationStatus(field, parent));
        fieldMetaInfo.setOptional(this.determineOptionality(field));
        fieldMetaInfo.setUpdatable(this.determineUpdatability(field, parent));
        if (!fieldMetaInfo.isToInstantiate()) {
            return fieldMetaInfo;
        }
        fieldMetaInfo.setFieldReferenceType(this.determineFieldReferenceType(field));
        fieldMetaInfo.setMockDataSource(this.determineMockDataSource(field));
        fieldMetaInfo.setParent(parent);
        this.cache.put(field, fieldMetaInfo);
        return fieldMetaInfo;
    }

    private boolean determineUpdatability(Field field, Object parent) {
        return !(field.isAnnotationPresent(Column.class) && !field.getAnnotation(Column.class).updatable() || field.isAnnotationPresent(NonCascadeUpdatable.class) || parent.getClass().isAnnotationPresent(NonCascadeUpdatables.class) && Arrays.asList(parent.getClass().getAnnotation(NonCascadeUpdatables.class).value()).contains(field.getName()) || field.isAnnotationPresent(Id.class) || field.isAnnotationPresent(EmbeddedId.class));
    }

    private boolean determineOptionality(Field field) {
        return field.isAnnotationPresent(Column.class) && field.getAnnotation(Column.class).nullable() || field.isAnnotationPresent(NonNullable.class) || field.isAnnotationPresent(OneToOne.class) && field.getAnnotation(OneToOne.class).optional() || field.isAnnotationPresent(ManyToOne.class) && field.getAnnotation(ManyToOne.class).optional() || !this.hasNonNullableJoinColumn(field);
    }

    private MockDataSource determineMockDataSource(Field field) {
        if (!field.isAnnotationPresent(MockData.class)) {
            return MockDataSource.DEFAULT;
        }
        MockData mockData = field.getAnnotation(MockData.class);
        if (!mockData.mockFactoryBean().equals(NullMockFactory.class)) {
            return MockDataSource.MOCK_FACTORY;
        }
        if (!mockData.customKeyword().equals("")) {
            return MockDataSource.CUSTOM_KEYWORD;
        }
        if (!mockData.keyword().equals((Object)KEYWORD.NULL)) {
            return MockDataSource.KEYWORD;
        }
        if (this.ofSetIsNotEmpty(mockData)) {
            return MockDataSource.OF_SET;
        }
        if (mockData.max() != -1 && mockData.min() != -1 && mockData.max() > mockData.min()) {
            return MockDataSource.MIN_MAX_RANGE;
        }
        throw new IllegalArgumentException("Cannot determine data mocking strategy for " + field.getDeclaringClass().getSimpleName() + "." + field.getName());
    }

    private boolean ofSetIsNotEmpty(MockData mockData) {
        return mockData.ofSet().length > 1 || !mockData.ofSet()[0].equals("");
    }

    private FieldReferenceType determineFieldReferenceType(Field field) {
        if (field.isAnnotationPresent(OneToOne.class)) {
            return FieldReferenceType.SINGLE_FOREIGN_KEY;
        }
        if (field.isAnnotationPresent(OneToMany.class) || field.isAnnotationPresent(ManyToMany.class)) {
            return FieldReferenceType.FOREIGN_KEY_COLLECTION;
        }
        if (Iterable.class.isAssignableFrom(field.getType())) {
            return FieldReferenceType.PRIMITIVE_COLLECTION;
        }
        return FieldReferenceType.SINGLE_PRIMITIVE;
    }

    private boolean determineInstantiationStatus(Field field, Object parent) {
        if (this.isAlreadyInitialized(field, parent)) {
            return false;
        }
        if (!StaticUtils.isEmbeddedEntity(field, this.reflectionCache)) {
            return true;
        }
        if (field.isAnnotationPresent(NonMockable.class)) {
            return false;
        }
        if (field.isAnnotationPresent(NonNullable.class)) {
            return true;
        }
        if (field.isAnnotationPresent(OneToOne.class)) {
            OneToOne oneToOne = field.getAnnotation(OneToOne.class);
            Field backPointer = this.nonNullableOneToOneBackPointer(field, parent);
            if (backPointer != null) {
                if (oneToOne.optional()) {
                    return false;
                }
                CircularReferenceException.throwOneToOneCircularReferenceException(field, parent, backPointer);
            }
        } else if (field.isAnnotationPresent(OneToMany.class)) {
            OneToMany oneToMany = field.getAnnotation(OneToMany.class);
            Field backPointer = this.nonNullableOneToManyBackPointer(field, parent);
            if (backPointer != null) {
                Class<?> collectionType = StaticUtils.collectibleType(field, this.reflectionCache);
                if (this.hasNonNullableJoinColumn(field)) {
                    CircularReferenceException.throwOneToManyCircularReferenceException(field, collectionType, parent, backPointer);
                }
                this.initEmptyCollection(field, parent);
                return false;
            }
        } else if (field.isAnnotationPresent(ManyToMany.class)) {
            ManyToMany manyToMany = field.getAnnotation(ManyToMany.class);
            Field backPointer = this.nonNullableManyToManyBackpointer(field, parent);
            if (backPointer != null) {
                Class<?> collectionType = StaticUtils.collectibleType(field, this.reflectionCache);
                if (this.hasNonNullableJoinColumn(field)) {
                    CircularReferenceException.throwManyToManyCircularReferenceException(field, collectionType, parent, backPointer);
                }
                this.initEmptyCollection(field, parent);
                return false;
            }
        } else if (field.isAnnotationPresent(ManyToOne.class)) {
            ManyToOne manyToOne = field.getAnnotation(ManyToOne.class);
            Field backPointer = this.nonNullableManyToOneBackpointer(field, parent);
            if (backPointer != null) {
                if (this.hasNonNullableJoinColumn(field)) {
                    CircularReferenceException.throwManyToOneCircularReferenceException(field, parent, backPointer);
                }
                return false;
            }
        }
        return true;
    }

    private Field nonNullableManyToOneBackpointer(Field field, Object parent) {
        for (Field aField : ReflectionCache.getClassFields(field.getType())) {
            if (!aField.getType().equals(parent.getClass()) || !field.isAnnotationPresent(ManyToOne.class) || field.getAnnotation(ManyToOne.class).optional()) continue;
            return aField;
        }
        return null;
    }

    private Field nonNullableManyToManyBackpointer(Field field, Object parent) {
        for (Field aField : ReflectionCache.getClassFields(field.getType())) {
            if (!aField.getType().equals(parent.getClass()) || !field.isAnnotationPresent(ManyToMany.class) || !this.hasNonNullableJoinColumn(field)) continue;
            return aField;
        }
        return null;
    }

    private Field nonNullableOneToManyBackPointer(Field field, Object parent) {
        if (parent == null) {
            return null;
        }
        for (Field aField : ReflectionCache.getClassFields(field.getType())) {
            if (!aField.getType().equals(parent.getClass()) || !field.isAnnotationPresent(OneToMany.class) || !this.hasNonNullableJoinColumn(field)) continue;
            return aField;
        }
        return null;
    }

    private boolean hasNonNullableJoinColumn(Field field) {
        if (field.isAnnotationPresent(JoinColumn.class)) {
            return !field.getAnnotation(JoinColumn.class).nullable();
        }
        if (field.isAnnotationPresent(JoinColumns.class)) {
            for (JoinColumn joinColumn : field.getAnnotation(JoinColumns.class).value()) {
                if (joinColumn.nullable()) continue;
                return true;
            }
        }
        return false;
    }

    private Field nonNullableOneToOneBackPointer(Field field, Object parent) {
        for (Field aField : ReflectionCache.getClassFields(field.getType())) {
            if (!aField.getType().equals(parent.getClass()) || !field.isAnnotationPresent(OneToOne.class) || field.getAnnotation(OneToOne.class).optional()) continue;
            return aField;
        }
        return null;
    }

    private void initEmptyCollection(Field field, Object parent) {
        try {
            field.setAccessible(true);
            field.set(parent, this.collectionInstantiator.instantiateCollection(field.getType(), StaticUtils.collectibleType(field, this.reflectionCache)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isAlreadyInitialized(Field field, Object parent) {
        return ((CachedEntityType)this.reflectionCache.getEntitiesCache().get(parent.getClass().getSimpleName())).invokeGetter(parent, field.getName()) != null;
    }
}

