/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.mockeri.meta;

import com.google.common.collect.Maps;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.joda.time.LocalDateTime;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.sindaryn.datafi.reflection.CachedEntityType;
import org.sindaryn.datafi.reflection.ReflectionCache;
import org.sindaryn.mockeri.generator.TestDataGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CollectionInstantiator {
    @Autowired
    private ReflectionCache reflectionCache;
    private Reflections javaUtils = new Reflections("java.util", new Scanner[0]);
    private Map<Class<? extends Collection>, List<Class<? extends Collection>>> collectionTypes = new HashMap<Class<? extends Collection>, List<Class<? extends Collection>>>();
    private Map<Map.Entry<Class<?>, Class<?>>, Class<?>> cache = new HashMap();

    @PostConstruct
    private void init() {
        Set allCollectionTypes = this.javaUtils.getSubTypesOf(Collection.class);
        Collection collectionInterfaces = allCollectionTypes.stream().filter(Class::isInterface).collect(Collectors.toList());
        Collection collectionImplementations = allCollectionTypes.stream().filter(type -> !type.isInterface()).collect(Collectors.toList());
        for (Class collectionInterface : collectionInterfaces) {
            this.collectionTypes.put(collectionInterface, new ArrayList());
            for (Class collectionImplementation : collectionImplementations) {
                if (!collectionInterface.isAssignableFrom(collectionImplementation)) continue;
                this.collectionTypes.get(collectionInterface).add(collectionImplementation);
            }
        }
    }

    public Collection instantiateCollection(Class<?> collectionType, Class<?> collectableType) {
        Map.Entry key = Maps.immutableEntry(collectionType, collectableType);
        if (this.cache.get(key) != null) {
            return (Collection)CachedEntityType.genDefaultInstance(this.cache.get(key));
        }
        if (collectableType.equals(Collection.class)) {
            return new ArrayList();
        }
        Object result = null;
        for (Map.Entry<Class<? extends Collection>, List<Class<? extends Collection>>> entry : this.collectionTypes.entrySet()) {
            if (entry.getKey().equals(collectionType)) {
                result = this.assignDefaultType(entry, collectableType);
                continue;
            }
            if (!entry.getKey().isAssignableFrom(collectionType)) continue;
            result = (Collection)CachedEntityType.genDefaultInstance(collectionType);
        }
        if (result == null) {
            throw new IllegalArgumentException("unrecognized collection type: " + collectionType.getSimpleName());
        }
        this.cache.put(key, result.getClass());
        return result;
    }

    private Collection assignDefaultType(Map.Entry<Class<? extends Collection>, List<Class<? extends Collection>>> entry, Class<?> collectibleType) {
        if (collectibleType.equals(Collection.class)) {
            return new ArrayList();
        }
        try {
            Collection result = (Collection)CachedEntityType.genDefaultInstance(TestDataGenerator.randomFrom(entry.getValue()));
            Object exampleInstance = this.getDefaultInstance(collectibleType);
            result.add(exampleInstance);
            result.removeIf(item -> item.toString().equals(exampleInstance.toString()));
            Class<?> resultClass = result.getClass();
            if (resultClass.equals(CopyOnWriteArrayList.class) || resultClass.equals(CopyOnWriteArraySet.class)) {
                throw new RuntimeException();
            }
            return result;
        }
        catch (StackOverflowError stackOverflowError) {
            throw new RuntimeException(stackOverflowError);
        }
        catch (Exception e) {
            return this.assignDefaultType(entry, collectibleType);
        }
    }

    private Object getDefaultInstance(Class<?> collectableType) {
        CachedEntityType type = (CachedEntityType)this.reflectionCache.getEntitiesCache().get(collectableType.getSimpleName());
        if (type != null) {
            return type.getDefaultInstance();
        }
        if (Number.class.isAssignableFrom(collectableType)) {
            return 0;
        }
        if (collectableType.equals(Boolean.class)) {
            return true;
        }
        if (collectableType.equals(String.class)) {
            return "";
        }
        if (collectableType.equals(URL.class)) {
            return this.dummyUrl();
        }
        if (collectableType.equals(LocalDate.class)) {
            return LocalDate.now();
        }
        if (collectableType.equals(java.time.LocalDateTime.class)) {
            return java.time.LocalDateTime.now();
        }
        if (collectableType.equals(org.joda.time.LocalDate.class)) {
            return org.joda.time.LocalDate.now();
        }
        if (collectableType.equals(LocalDateTime.class)) {
            return LocalDateTime.now();
        }
        throw new RuntimeException("cannot instantiate field of type " + collectableType.getSimpleName());
    }

    private URL dummyUrl() {
        try {
            return new URL("https://www.google.com/");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

