/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.apifi.generator;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import lombok.NonNull;
import org.sindaryn.apifi.annotations.GraphQLApiEntity;

public class EntitiesInfoCache {
    @NonNull
    private ProcessingEnvironment processingEnvironment;
    private Map<String, TypeElement> typeElementMap;

    public void setTypeElementMap(Set<? extends TypeElement> typeElements) {
        this.typeElementMap = new HashMap<String, TypeElement>();
        for (TypeElement typeElement : typeElements) {
            this.typeElementMap.put(typeElement.getQualifiedName().toString(), typeElement);
        }
    }

    public boolean isStrongEntity(VariableElement embeddedCollection) {
        String typeNameString = this.getCollectionType(embeddedCollection);
        TypeElement typeElement = this.typeElementMap.get(typeNameString);
        if (typeElement == null) {
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, "Entity type " + typeNameString + " is referenced by another entity but is not annotated with @GraphQLApi. Either remove @GraphQLApi annotation from the referencing entity, or annotate " + typeNameString + " as well.", typeElement);
        }
        GraphQLApiEntity graphQLApiEntity = typeElement.getAnnotation(GraphQLApiEntity.class);
        return graphQLApiEntity.exposeDirectly();
    }

    public String getCollectionType(VariableElement element) {
        return element.asType().toString().replaceAll("^.+<", "").replaceAll(">", "");
    }

    @NonNull
    public ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnvironment;
    }

    public Map<String, TypeElement> getTypeElementMap() {
        return this.typeElementMap;
    }

    public EntitiesInfoCache(@NonNull ProcessingEnvironment processingEnvironment) {
        if (processingEnvironment == null) {
            throw new NullPointerException("processingEnvironment is marked non-null but is null");
        }
        this.processingEnvironment = processingEnvironment;
    }

    public void setProcessingEnvironment(@NonNull ProcessingEnvironment processingEnvironment) {
        if (processingEnvironment == null) {
            throw new NullPointerException("processingEnvironment is marked non-null but is null");
        }
        this.processingEnvironment = processingEnvironment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntitiesInfoCache)) {
            return false;
        }
        EntitiesInfoCache other = (EntitiesInfoCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProcessingEnvironment this$processingEnvironment = this.getProcessingEnvironment();
        ProcessingEnvironment other$processingEnvironment = other.getProcessingEnvironment();
        if (this$processingEnvironment == null ? other$processingEnvironment != null : !this$processingEnvironment.equals(other$processingEnvironment)) {
            return false;
        }
        Map<String, TypeElement> this$typeElementMap = this.getTypeElementMap();
        Map<String, TypeElement> other$typeElementMap = other.getTypeElementMap();
        return !(this$typeElementMap == null ? other$typeElementMap != null : !((Object)this$typeElementMap).equals(other$typeElementMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntitiesInfoCache;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProcessingEnvironment $processingEnvironment = this.getProcessingEnvironment();
        result = result * 59 + ($processingEnvironment == null ? 43 : $processingEnvironment.hashCode());
        Map<String, TypeElement> $typeElementMap = this.getTypeElementMap();
        result = result * 59 + ($typeElementMap == null ? 43 : ((Object)$typeElementMap).hashCode());
        return result;
    }

    public String toString() {
        return "EntitiesInfoCache(processingEnvironment=" + this.getProcessingEnvironment() + ", typeElementMap=" + this.getTypeElementMap() + ")";
    }
}

