/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.apifi;

import com.google.common.collect.Sets;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.sindaryn.apifi.annotations.GraphQLApiEntity;
import org.sindaryn.apifi.annotations.MetaOperations;
import org.sindaryn.apifi.service.EmbeddedCollectionMetaOperations;
import org.sindaryn.datafi.persistence.Archivable;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

public abstract class StaticUtils {
    public static final String reflectionCache = "reflectionCache";

    public static List<VariableElement> getFields(TypeElement typeElement) {
        ArrayList<VariableElement> fields = new ArrayList<VariableElement>();
        for (Element element : typeElement.getEnclosedElements()) {
            if (!element.getKind().isField()) continue;
            fields.add((VariableElement)element);
        }
        return fields;
    }

    public static void argsToResolver(String resolverParams, MethodSpec.Builder builder) {
        ParameterizedTypeName listOfObjects = ParameterizedTypeName.get(List.class, (Type[])new Type[]{Object.class});
        CodeBlock.Builder block = CodeBlock.builder().add("$T args = $T.asList($L)", new Object[]{listOfObjects, Arrays.class, resolverParams});
        builder.addStatement(block.build());
    }

    public static Set<? extends TypeElement> getGraphQLApiEntities(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        HashSet<? extends Element> entities = new HashSet<Element>();
        for (TypeElement typeElement : annotations) {
            if (!typeElement.getQualifiedName().toString().equals(GraphQLApiEntity.class.getCanonicalName())) continue;
            entities.addAll(roundEnvironment.getElementsAnnotatedWith(typeElement));
        }
        return Sets.newHashSet(entities);
    }

    public static TypeName listOf(TypeElement element) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((TypeElement)element)});
    }

    public static TypeName listOf(VariableElement element) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)element.asType())});
    }

    public static TypeName listOf(ClassName className) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{className});
    }

    public static String dataManagerName(Element entity) {
        return StaticUtils.camelcaseNameOf(entity) + "DataManager";
    }

    public static TypeName collectionTypeName(VariableElement embedded) {
        String typeNameString = embedded.asType().toString();
        typeNameString = typeNameString.replaceAll("^.+<", "");
        typeNameString = typeNameString.replaceAll(">", "");
        int lastDot = typeNameString.lastIndexOf(46);
        String packageName = typeNameString.substring(0, lastDot);
        String simpleClassName = typeNameString.substring(lastDot + 1);
        return ClassName.get((String)packageName, (String)simpleClassName, (String[])new String[0]);
    }

    public static String metaOpsName(TypeElement entity) {
        return StaticUtils.camelcaseNameOf(entity) + "MetaOperations";
    }

    public static String camelcaseNameOf(Element entity) {
        return org.sindaryn.datafi.StaticUtils.toCamelCase((String)entity.getSimpleName().toString());
    }

    public static String pascalCaseNameOf(Element entity) {
        return org.sindaryn.datafi.StaticUtils.toPascalCase((String)entity.getSimpleName().toString());
    }

    public static ParameterSpec parameterizeType(TypeElement entity) {
        return ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)entity.asType()), (String)"input", (Modifier[])new Modifier[0]).build();
    }

    public static CodeBlock entitiesList(TypeElement entity) {
        ClassName listClassName = ClassName.get((String)"java.util", (String)"List", (String[])new String[0]);
        ClassName typeClassName = ClassName.get((TypeElement)entity);
        ParameterizedTypeName listOfEntities = ParameterizedTypeName.get((ClassName)listClassName, (TypeName[])new TypeName[]{typeClassName});
        return CodeBlock.builder().add("$T entities", new Object[]{listOfEntities}).build();
    }

    public static <A extends Annotation> ParameterSpec asParamList(Element element, Class<A> ... annotations) {
        ClassName list = ClassName.get((String)"java.util", (String)"List", (String[])new String[0]);
        TypeName typeClassName = TypeName.get((TypeMirror)element.asType());
        ParameterSpec.Builder builder = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)list, (TypeName[])new TypeName[]{typeClassName}), (String)"input", (Modifier[])new Modifier[0]);
        if (annotations.length > 0) {
            for (Class<A> annotation : annotations) {
                builder.addAnnotation(annotation);
            }
        }
        return builder.build();
    }

    public static ParameterSpec asEmbeddedCollectionParamList(VariableElement embedded) {
        ClassName list = ClassName.get((String)"java.util", (String)"List", (String[])new String[0]);
        TypeName typeClassName = StaticUtils.collectionTypeName(embedded);
        return ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)list, (TypeName[])new TypeName[]{typeClassName}), (String)"input", (Modifier[])new Modifier[0]).build();
    }

    public static AnnotationSpec suppressDeprecationWarning() {
        return AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"deprecation"}).build();
    }

    public static ParameterizedTypeName listOfLists(VariableElement element) {
        ParameterizedTypeName nestedList = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{StaticUtils.collectionTypeName(element)});
        ClassName listName = ClassName.get((String)"java.util", (String)"List", (String[])new String[0]);
        return ParameterizedTypeName.get((ClassName)listName, (TypeName[])new TypeName[]{nestedList});
    }

    public static ParameterizedTypeName listOfEmbedded(VariableElement element) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{StaticUtils.collectionTypeName(element)});
    }

    public static String embeddedCollectionMetaOpsName(VariableElement embedded) {
        MetaOperations metaOperations = embedded.getAnnotation(MetaOperations.class);
        if (metaOperations == null) {
            return org.sindaryn.datafi.StaticUtils.toCamelCase((String)embedded.getSimpleName().toString()) + org.sindaryn.datafi.StaticUtils.toPascalCase((String)EmbeddedCollectionMetaOperations.class.getSimpleName());
        }
        Class<? extends EmbeddedCollectionMetaOperations> embeddedMetaOps = metaOperations.metaOps();
        if (embeddedMetaOps.isAnnotationPresent(Component.class) || embeddedMetaOps.isAnnotationPresent(Service.class)) {
            return org.sindaryn.datafi.StaticUtils.toCamelCase((String)embeddedMetaOps.getSimpleName());
        }
        return "new " + embeddedMetaOps.getSimpleName() + "()";
    }

    public static boolean isArchivable(TypeElement element, ProcessingEnvironment processingEnv) {
        return processingEnv.getTypeUtils().isAssignable(element.asType(), processingEnv.getElementUtils().getTypeElement(Archivable.class.getCanonicalName()).asType());
    }
}

