/*
 * Decompiled with CFR 0.152.
 */
package com.xiaofeng.flowlayoutmanager;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewTreeObserver;
import com.xiaofeng.flowlayoutmanager.Alignment;
import com.xiaofeng.flowlayoutmanager.FlowLayoutOptions;
import com.xiaofeng.flowlayoutmanager.LayoutContext;
import com.xiaofeng.flowlayoutmanager.LayoutHelper;
import com.xiaofeng.flowlayoutmanager.LayoutManagerAppender;
import com.xiaofeng.flowlayoutmanager.cache.CacheHelper;
import com.xiaofeng.flowlayoutmanager.cache.Line;
import java.util.LinkedList;
import java.util.List;

public class FlowLayoutManager
extends RecyclerView.LayoutManager {
    private static final String LOG_TAG = "FlowLayoutManager";
    private static final int SCROLL_UP = -1;
    private static final int SCROLL_DOWN = 1;
    private RecyclerView recyclerView;
    private int firstChildAdapterPosition = 0;
    private RecyclerView.Recycler recyclerRef;
    private FlowLayoutOptions flowLayoutOptions = new FlowLayoutOptions();
    private LayoutHelper layoutHelper;
    private CacheHelper cacheHelper;
    @Nullable
    private ViewTreeObserver.OnGlobalLayoutListener globalLayoutListener;

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (!this.cacheHelper.valid() && this.getChildCount() != 0) {
            return;
        }
        if (this.cacheHelper.contentAreaWidth() != this.layoutHelper.visibleAreaWidth()) {
            this.cacheHelper.contentAreaWidth(this.layoutHelper.visibleAreaWidth());
        }
        this.recyclerRef = recycler;
        if (state.isPreLayout()) {
            this.onPreLayoutChildren(recycler, state);
        } else {
            this.cacheHelper.startBatchSetting();
            this.onRealLayoutChildren(recycler);
            this.cacheHelper.endBatchSetting();
        }
    }

    private void onPreLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        int firstItemAdapterPosition = this.getChildAdapterPosition(0);
        if (firstItemAdapterPosition == -1) {
            this.detachAndScrapAttachedViews(recycler);
            return;
        }
        Point point = this.layoutHelper.layoutStartPoint(LayoutContext.fromLayoutOptions(this.flowLayoutOptions));
        int x = point.x;
        int y = point.y;
        int height = 0;
        int realX = point.x;
        int realY = point.y;
        int realHeight = 0;
        Rect rect = new Rect();
        Rect realRect = new Rect();
        this.detachAndScrapAttachedViews(recycler);
        LayoutContext beforeContext = LayoutContext.fromLayoutOptions(this.flowLayoutOptions);
        LayoutContext afterContext = LayoutContext.clone(beforeContext);
        afterContext.layoutOptions.itemsPerLine = this.flowLayoutOptions.itemsPerLine;
        for (int currentItemPosition = firstItemAdapterPosition < 0 ? 0 : firstItemAdapterPosition; currentItemPosition < state.getItemCount(); ++currentItemPosition) {
            View child = recycler.getViewForPosition(currentItemPosition);
            boolean childRemoved = this.isChildRemoved(child);
            boolean newline = this.calcChildLayoutRect(child, x, y, height, beforeContext, rect);
            if (newline) {
                point = this.startNewline(rect, beforeContext);
                x = point.x;
                y = point.y;
                height = rect.height();
                beforeContext.currentLineItemCount = 1;
            } else {
                x = this.advanceInSameLine(x, rect, beforeContext);
                height = Math.max(height, rect.height());
                ++beforeContext.currentLineItemCount;
            }
            if (!childRemoved) {
                boolean realNewline = this.calcChildLayoutRect(child, realX, realY, realHeight, afterContext, realRect);
                if (realNewline) {
                    point = this.startNewline(realRect, afterContext);
                    realX = point.x;
                    realY = point.y;
                    realHeight = realRect.height();
                    afterContext.currentLineItemCount = 1;
                } else {
                    realX = this.advanceInSameLine(realX, realRect, afterContext);
                    realHeight = Math.max(realHeight, realRect.height());
                    ++afterContext.currentLineItemCount;
                }
            }
            if (!this.childVisible(true, realX, realY, realX + rect.width(), realY + rect.height())) {
                recycler.recycleView(child);
                break;
            }
            if (childRemoved) {
                this.addDisappearingView(child);
            } else {
                this.addView(child);
            }
            this.layoutDecorated(child, rect.left, rect.top, rect.right, rect.bottom);
        }
    }

    private void onRealLayoutChildren(RecyclerView.Recycler recycler) {
        this.detachAndScrapAttachedViews(recycler);
        Point startPoint = this.layoutStartPoint();
        int x = startPoint.x;
        int y = startPoint.y;
        int itemCount = this.getItemCount();
        int height = 0;
        Rect rect = new Rect();
        LayoutContext layoutContext = LayoutContext.fromLayoutOptions(this.flowLayoutOptions);
        LinkedList<LayoutManagerAppender> appenders = new LinkedList<LayoutManagerAppender>();
        for (int i = this.firstChildAdapterPosition; i < itemCount; ++i) {
            View child = recycler.getViewForPosition(i);
            boolean newLine = this.calcChildLayoutRect(child, x, y, height, layoutContext, rect);
            if (!this.childVisible(false, rect)) {
                recycler.recycleView(child);
                this.layoutAppenders(x, appenders);
                appenders.clear();
                return;
            }
            this.addView(child);
            appenders.add(new LayoutManagerAppender(child, this, rect, this.flowLayoutOptions.alignment));
            this.cacheHelper.setItem(i, new Point(rect.width(), rect.height()));
            if (newLine) {
                LayoutManagerAppender last = appenders.removeLast();
                this.layoutAppenders(x, appenders);
                appenders.clear();
                appenders.add(last);
                Point lineInfo = this.startNewline(rect);
                x = lineInfo.x;
                y = lineInfo.y;
                height = rect.height();
                layoutContext.currentLineItemCount = 1;
                continue;
            }
            x = this.advanceInSameLine(x, rect, layoutContext);
            height = Math.max(height, rect.height());
            ++layoutContext.currentLineItemCount;
        }
        this.layoutAppenders(x, appenders);
    }

    public boolean canScrollHorizontally() {
        return false;
    }

    public boolean canScrollVertically() {
        if (this.getChildCount() == 0) {
            return false;
        }
        return this.canScrollVertically(-1) || this.canScrollVertically(1);
    }

    public boolean canScrollVertically(int direction) {
        if (direction < 0) {
            View firstChild = this.getChildAt(0);
            View topChild = this.getChildAt(this.getMaxHeightLayoutPositionInLine(0));
            return this.getChildAdapterPosition(firstChild) != 0 || this.getDecoratedTop(topChild) < this.topVisibleEdge();
        }
        View lastChild = this.getChildAt(this.getChildCount() - 1);
        View bottomChild = this.getChildAt(this.getMaxHeightLayoutPositionInLine(this.getChildCount() - 1));
        return this.getChildAdapterPosition(lastChild) != this.recyclerView.getAdapter().getItemCount() - 1 || bottomChild == null || this.getDecoratedBottom(bottomChild) > this.bottomVisibleEdge();
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (dy == 0) {
            return 0;
        }
        if (this.getItemCount() == 0) {
            return 0;
        }
        View firstChild = this.getChildAt(0);
        View lastChild = this.getChildAt(this.getChildCount() - 1);
        View topChild = this.getChildAt(this.getMaxHeightLayoutPositionInLine(0));
        View bottomChild = this.getChildAt(this.getMaxHeightLayoutPositionInLine(this.getChildCount() - 1));
        boolean topReached = false;
        boolean bottomReached = false;
        if (this.getChildAdapterPosition(firstChild) == 0 && this.getDecoratedTop(topChild) >= this.topVisibleEdge()) {
            topReached = true;
        }
        if (this.getChildAdapterPosition(lastChild) == this.recyclerView.getAdapter().getItemCount() - 1 && this.getDecoratedBottom(bottomChild) <= this.bottomVisibleEdge()) {
            bottomReached = true;
        }
        if (dy > 0 && bottomReached) {
            return 0;
        }
        if (dy < 0 && topReached) {
            return 0;
        }
        return dy > 0 ? this.contentMoveUp(dy, recycler) : this.contentMoveDown(dy, recycler);
    }

    public void onItemsChanged(RecyclerView recyclerView) {
        this.flowLayoutOptions = FlowLayoutOptions.clone(this.flowLayoutOptions);
        if (this.cacheHelper != null) {
            this.cacheHelper.clear();
        }
        this.cacheHelper = new CacheHelper(this.flowLayoutOptions.itemsPerLine, this.layoutHelper.visibleAreaWidth());
        super.onItemsChanged(recyclerView);
    }

    public void onItemsAdded(RecyclerView recyclerView, int positionStart, int itemCount) {
        this.cacheHelper.add(positionStart, itemCount);
        super.onItemsAdded(recyclerView, positionStart, itemCount);
    }

    public void onItemsRemoved(RecyclerView recyclerView, int positionStart, int itemCount) {
        this.cacheHelper.remove(positionStart, itemCount);
        super.onItemsRemoved(recyclerView, positionStart, itemCount);
    }

    public void onItemsUpdated(RecyclerView recyclerView, int positionStart, int itemCount) {
        this.cacheHelper.invalidSizes(positionStart, itemCount);
        super.onItemsUpdated(recyclerView, positionStart, itemCount);
    }

    public void onItemsUpdated(RecyclerView recyclerView, int positionStart, int itemCount, Object payload) {
        this.cacheHelper.invalidSizes(positionStart, itemCount);
        super.onItemsUpdated(recyclerView, positionStart, itemCount, payload);
    }

    public void onItemsMoved(RecyclerView recyclerView, int from, int to, int itemCount) {
        this.cacheHelper.move(from, to, itemCount);
        super.onItemsMoved(recyclerView, from, to, itemCount);
    }

    private int contentMoveUp(int dy, RecyclerView.Recycler recycler) {
        int offscreenBottom;
        int actualDy = dy;
        int maxHeightIndex = this.getMaxHeightLayoutPositionInLine(this.getChildCount() - 1);
        View maxHeightItem = this.getChildAt(maxHeightIndex);
        for (offscreenBottom = this.getDecoratedBottom(maxHeightItem) - (this.getClipToPadding() ? this.bottomVisibleEdge() : this.getHeight()); offscreenBottom < dy && this.getChildAdapterPosition(this.getChildCount() - 1) < this.getItemCount() - 1; offscreenBottom += this.getDecoratedMeasuredHeight(maxHeightItem)) {
            this.addNewLineAtBottom(recycler);
            maxHeightIndex = this.getMaxHeightLayoutPositionInLine(this.getChildCount() - 1);
            maxHeightItem = this.getChildAt(maxHeightIndex);
        }
        if (offscreenBottom + this.getPaddingBottom() < dy) {
            actualDy = offscreenBottom + this.getPaddingBottom();
        }
        this.offsetChildrenVertical(-actualDy);
        while (!this.lineVisible(0)) {
            this.recycleLine(0, recycler);
        }
        this.firstChildAdapterPosition = this.getChildAdapterPosition(0);
        return actualDy;
    }

    private int contentMoveDown(int dy, RecyclerView.Recycler recycler) {
        int offScreenTop;
        int actualDy = dy;
        int maxHeightItemIndex = this.getMaxHeightLayoutPositionInLine(0);
        View maxHeightItem = this.getChildAt(maxHeightItemIndex);
        for (offScreenTop = (this.getClipToPadding() ? this.topVisibleEdge() : 0) - this.getDecoratedTop(maxHeightItem); offScreenTop < Math.abs(dy) && this.getChildAdapterPosition(0) > 0; offScreenTop += this.getDecoratedMeasuredHeight(maxHeightItem)) {
            this.addNewLineAtTop(recycler);
            maxHeightItemIndex = this.getMaxHeightLayoutPositionInLine(0);
            maxHeightItem = this.getChildAt(maxHeightItemIndex);
        }
        if (offScreenTop + this.getPaddingTop() < Math.abs(dy)) {
            actualDy = -offScreenTop - this.getPaddingTop();
        }
        this.offsetChildrenVertical(-actualDy);
        while (!this.lineVisible(this.getChildCount() - 1)) {
            this.recycleLine(this.getChildCount() - 1, recycler);
        }
        this.firstChildAdapterPosition = this.getChildAdapterPosition(0);
        return actualDy;
    }

    private void addNewLineAtTop(RecyclerView.Recycler recycler) {
        boolean newline;
        int x = this.layoutStartPoint().x;
        int bottom = this.getDecoratedTop(this.getChildAt(this.getMaxHeightLayoutPositionInLine(0)));
        int height = 0;
        LinkedList<View> lineChildren = new LinkedList<View>();
        int endAdapterPosition = this.getChildAdapterPosition(0) - 1;
        Rect rect = new Rect();
        boolean firstItem = true;
        LayoutContext layoutContext = LayoutContext.fromLayoutOptions(this.flowLayoutOptions);
        int firstItemAdapterPosition = this.getChildAdapterPosition(0);
        if (this.cacheHelper.hasPreviousLineCached(firstItemAdapterPosition)) {
            int previousLineIndex = this.cacheHelper.itemLineIndex(firstItemAdapterPosition) - 1;
            Line previousLine = this.cacheHelper.getLine(previousLineIndex);
            int firstNewItemAdapterPosition = this.cacheHelper.firstItemIndex(previousLineIndex);
            for (int i = 0; i < previousLine.itemCount; ++i) {
                View newView = recycler.getViewForPosition(firstNewItemAdapterPosition + i);
                this.addView(newView, i);
                lineChildren.add(newView);
            }
            height = previousLine.maxHeight;
        } else {
            for (int currentAdapterPosition = 0; currentAdapterPosition <= endAdapterPosition; ++currentAdapterPosition) {
                View newChild = recycler.getViewForPosition(currentAdapterPosition);
                newline = this.calcChildLayoutRect(newChild, x, 0, height, layoutContext, rect);
                this.cacheHelper.setItem(currentAdapterPosition, new Point(rect.width(), rect.height()));
                this.addView(newChild, lineChildren.size());
                if (newline && !firstItem) {
                    for (View viewToRecycle : lineChildren) {
                        this.removeAndRecycleView(viewToRecycle, recycler);
                    }
                    lineChildren.clear();
                    x = this.advanceInSameLine(this.layoutStartPoint().x, rect, layoutContext);
                    height = rect.height();
                    layoutContext.currentLineItemCount = 1;
                } else {
                    x = this.advanceInSameLine(x, rect, layoutContext);
                    height = Math.max(height, rect.height());
                    firstItem = false;
                    ++layoutContext.currentLineItemCount;
                }
                lineChildren.add(newChild);
            }
        }
        x = this.layoutStartPoint().x;
        int y = bottom - height;
        firstItem = true;
        layoutContext = LayoutContext.fromLayoutOptions(this.flowLayoutOptions);
        LinkedList<LayoutManagerAppender> appenders = new LinkedList<LayoutManagerAppender>();
        for (int i = 0; i < lineChildren.size(); ++i) {
            View childView = (View)lineChildren.get(i);
            newline = this.calcChildLayoutRect(childView, x, y, height, layoutContext, rect);
            if (newline && firstItem) {
                int rectHeight = rect.height();
                rect.top -= rectHeight;
                rect.bottom -= rectHeight;
                firstItem = false;
            }
            appenders.add(new LayoutManagerAppender(childView, this, rect, this.flowLayoutOptions.alignment));
            x = this.advanceInSameLine(x, rect, layoutContext);
        }
        this.layoutAppenders(x, appenders);
    }

    private void layoutAppenders(int x, List<LayoutManagerAppender> appenders) {
        for (LayoutManagerAppender appender : appenders) {
            appender.layout(this.rightVisibleEdge() - x >> 1);
        }
    }

    private void addNewLineAtBottom(RecyclerView.Recycler recycler) {
        int x = this.layoutStartPoint().x;
        int y = this.getDecoratedBottom(this.getChildAt(this.getMaxHeightLayoutPositionInLine(this.getChildCount() - 1)));
        int childAdapterPosition = this.getChildAdapterPosition(this.getChildCount() - 1) + 1;
        if (childAdapterPosition == this.getItemCount()) {
            return;
        }
        Rect rect = new Rect();
        boolean firstItem = true;
        LayoutContext layoutContext = LayoutContext.fromLayoutOptions(this.flowLayoutOptions);
        LinkedList<LayoutManagerAppender> appenders = new LinkedList<LayoutManagerAppender>();
        while (childAdapterPosition < this.getItemCount()) {
            View newChild = recycler.getViewForPosition(childAdapterPosition);
            boolean newline = this.calcChildLayoutRect(newChild, x, y, 0, layoutContext, rect);
            this.cacheHelper.setItem(childAdapterPosition, new Point(rect.width(), rect.height()));
            if (newline && !firstItem) {
                recycler.recycleView(newChild);
                layoutContext.currentLineItemCount = 1;
                break;
            }
            this.addView(newChild);
            appenders.add(new LayoutManagerAppender(newChild, this, rect, this.flowLayoutOptions.alignment));
            x = this.advanceInSameLine(x, rect, layoutContext);
            ++childAdapterPosition;
            firstItem = false;
            ++layoutContext.currentLineItemCount;
        }
        this.layoutAppenders(x, appenders);
    }

    public void onAttachedToWindow(final RecyclerView view) {
        super.onAttachedToWindow(view);
        this.recyclerView = view;
        this.layoutHelper = new LayoutHelper(this, this.recyclerView);
        this.cacheHelper = new CacheHelper(this.flowLayoutOptions.itemsPerLine, this.layoutHelper.visibleAreaWidth());
        if (this.layoutHelper.visibleAreaWidth() == 0) {
            if (this.globalLayoutListener == null) {
                this.globalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        FlowLayoutManager.this.globalLayoutListener = null;
                        FlowLayoutManager.this.cacheHelper.contentAreaWidth(FlowLayoutManager.this.layoutHelper.visibleAreaWidth());
                    }
                };
            }
            view.getViewTreeObserver().addOnGlobalLayoutListener(this.globalLayoutListener);
        }
    }

    public void onDetachedFromWindow(RecyclerView view, RecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(view, recycler);
        if (this.globalLayoutListener != null) {
            view.getViewTreeObserver().removeOnGlobalLayoutListener(this.globalLayoutListener);
            this.globalLayoutListener = null;
        }
    }

    public boolean supportsPredictiveItemAnimations() {
        return true;
    }

    public void scrollToPosition(int position) {
        this.firstChildAdapterPosition = position;
        this.requestLayout();
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        LinearSmoothScroller smoothScroller = new LinearSmoothScroller(recyclerView.getContext()){

            public PointF computeScrollVectorForPosition(int targetPosition) {
                return new PointF(0.0f, (float)FlowLayoutManager.this.getOffsetOfItemToFirstChild(targetPosition, FlowLayoutManager.this.recyclerRef));
            }
        };
        smoothScroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)smoothScroller);
    }

    public void setAutoMeasureEnabled(boolean enabled) {
        super.setAutoMeasureEnabled(enabled);
    }

    private int leftVisibleEdge() {
        return this.getPaddingLeft();
    }

    private int rightVisibleEdge() {
        return this.getWidth() - this.getPaddingRight();
    }

    private int topVisibleEdge() {
        return this.getPaddingTop();
    }

    private int bottomVisibleEdge() {
        return this.getHeight() - this.getPaddingBottom();
    }

    private boolean childVisible(boolean preLayout, int left, int top, int right, int bottom) {
        if (this.recyclerView.getLayoutParams().height == -2) {
            return true;
        }
        boolean clip = this.getClipToPadding();
        return Rect.intersects((Rect)new Rect(this.leftVisibleEdge(), clip ? this.topVisibleEdge() : 0, this.rightVisibleEdge(), clip ? this.bottomVisibleEdge() : this.getHeight()), (Rect)new Rect(left, top, right, bottom));
    }

    private boolean childVisible(boolean preLayout, Rect childRect) {
        if (!preLayout && this.recyclerView.getLayoutParams().height == -2) {
            return true;
        }
        boolean clip = this.getClipToPadding();
        return Rect.intersects((Rect)new Rect(this.leftVisibleEdge(), clip ? this.topVisibleEdge() : 0, this.rightVisibleEdge(), clip ? this.bottomVisibleEdge() : this.getHeight()), (Rect)childRect);
    }

    private int getMaxHeightLayoutPositionInLine(int layoutPosition) {
        try {
            int currentIndex;
            View child = this.getChildAt(layoutPosition);
            int maxIndexBefore = layoutPosition;
            int maxIndexAfter = layoutPosition;
            int maxHeightBefore = this.getDecoratedMeasuredHeight(child);
            int maxHeightAfter = this.getDecoratedMeasuredHeight(child);
            LayoutContext layoutContext = LayoutContext.fromLayoutOptions(this.flowLayoutOptions);
            for (currentIndex = layoutPosition; currentIndex >= 0 && !this.isStartOfLine(currentIndex, layoutContext); --currentIndex) {
                View beforeChild = this.getChildAt(currentIndex);
                if (this.getDecoratedMeasuredHeight(beforeChild) <= maxHeightBefore) continue;
                maxIndexBefore = currentIndex;
                maxHeightBefore = this.getDecoratedMeasuredHeight(beforeChild);
            }
            if (maxHeightBefore < this.getDecoratedMeasuredHeight(this.getChildAt(currentIndex))) {
                maxIndexBefore = currentIndex;
                maxHeightBefore = this.getDecoratedMeasuredHeight(this.getChildAt(currentIndex));
            }
            for (currentIndex = layoutPosition; currentIndex < this.getChildCount() && !this.isEndOfLine(currentIndex, layoutContext); ++currentIndex) {
                View afterChild = this.getChildAt(currentIndex);
                if (this.getDecoratedMeasuredHeight(afterChild) <= maxHeightAfter) continue;
                maxIndexAfter = currentIndex;
                maxHeightAfter = this.getDecoratedMeasuredHeight(afterChild);
            }
            if (maxHeightAfter < this.getDecoratedMeasuredHeight(this.getChildAt(currentIndex))) {
                maxIndexAfter = currentIndex;
                maxHeightAfter = this.getDecoratedMeasuredHeight(this.getChildAt(currentIndex));
            }
            if (maxHeightBefore >= maxHeightAfter) {
                return maxIndexBefore;
            }
            return maxIndexAfter;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private List<View> getAllViewsInLine(int index) {
        int firstItemIndex = index;
        while (!this.isStartOfLine(firstItemIndex)) {
            --firstItemIndex;
        }
        LinkedList<View> viewList = new LinkedList<View>();
        viewList.add(this.getChildAt(firstItemIndex));
        LayoutContext layoutContext = LayoutContext.fromLayoutOptions(this.flowLayoutOptions);
        for (int nextItemIndex = firstItemIndex + 1; nextItemIndex < this.getChildCount() && !this.isStartOfLine(nextItemIndex, layoutContext); ++nextItemIndex) {
            viewList.add(this.getChildAt(nextItemIndex));
        }
        return viewList;
    }

    private int getChildAdapterPosition(int layoutPosition) {
        return this.getChildAdapterPosition(this.getChildAt(layoutPosition));
    }

    private int getChildAdapterPosition(View child) {
        if (child == null) {
            return -1;
        }
        return ((RecyclerView.LayoutParams)child.getLayoutParams()).getViewAdapterPosition();
    }

    public int getChildLayoutPosition(View child) {
        return ((RecyclerView.LayoutParams)child.getLayoutParams()).getViewLayoutPosition();
    }

    private boolean lineVisible(int index) {
        int maxHeightItemIndex = this.getMaxHeightLayoutPositionInLine(index);
        View maxHeightItem = this.getChildAt(maxHeightItemIndex);
        boolean clip = this.getClipToPadding();
        return Rect.intersects((Rect)new Rect(this.leftVisibleEdge(), clip ? this.topVisibleEdge() : 0, this.rightVisibleEdge(), clip ? this.bottomVisibleEdge() : this.getHeight()), (Rect)new Rect(this.leftVisibleEdge(), this.getDecoratedTop(maxHeightItem), this.rightVisibleEdge(), this.getDecoratedBottom(maxHeightItem)));
    }

    private void recycleLine(int index, RecyclerView.Recycler recycler) {
        List<View> viewList = this.getAllViewsInLine(index);
        for (View viewToRecycle : viewList) {
            this.removeAndRecycleView(viewToRecycle, recycler);
        }
    }

    private int getOffsetOfItemToFirstChild(int adapterPosition, RecyclerView.Recycler recycler) {
        int firstChildPosition = this.getChildAdapterPosition(0);
        if (firstChildPosition == adapterPosition) {
            return this.topVisibleEdge() - this.getDecoratedTop(this.getChildAt(0));
        }
        if (adapterPosition > firstChildPosition) {
            int lastChildAdapterPosition = this.getChildAdapterPosition(this.getChildCount() - 1);
            if (lastChildAdapterPosition >= adapterPosition) {
                int targetChildIndex = this.getChildCount() - 1 - (lastChildAdapterPosition - adapterPosition);
                return this.getDecoratedTop(this.getChildAt(targetChildIndex)) - this.topVisibleEdge();
            }
            int y = this.getDecoratedBottom(this.getChildAt(this.getMaxHeightLayoutPositionInLine(this.getChildCount() - 1))) - this.topVisibleEdge();
            int x = this.layoutStartPoint().x;
            int height = 0;
            Rect rect = new Rect();
            LayoutContext layoutContext = LayoutContext.fromLayoutOptions(this.flowLayoutOptions);
            for (int targetAdapterPosition = lastChildAdapterPosition + 1; targetAdapterPosition != adapterPosition; ++targetAdapterPosition) {
                View nextChild = recycler.getViewForPosition(targetAdapterPosition);
                boolean newline = this.calcChildLayoutRect(nextChild, x, y, height, layoutContext, rect);
                if (newline) {
                    x = this.advanceInSameLine(this.layoutStartPoint().x, rect, layoutContext);
                    y = rect.top;
                    height = rect.height();
                    layoutContext.currentLineItemCount = 1;
                } else {
                    x = this.advanceInSameLine(x, rect, layoutContext);
                    height = Math.max(height, this.getDecoratedMeasuredHeight(nextChild));
                    ++layoutContext.currentLineItemCount;
                }
                recycler.recycleView(nextChild);
            }
            return y;
        }
        int x = this.layoutStartPoint().x;
        int height = 0;
        int y = this.topVisibleEdge() - this.getDecoratedTop(this.getChildAt(0));
        Rect rect = new Rect();
        LayoutContext layoutContext = LayoutContext.fromLayoutOptions(this.flowLayoutOptions);
        for (int targetAdapterPosition = 0; targetAdapterPosition <= firstChildPosition; ++targetAdapterPosition) {
            View child = recycler.getViewForPosition(targetAdapterPosition);
            boolean newline = this.calcChildLayoutRect(child, x, y, height, rect);
            if (newline) {
                x = this.advanceInSameLine(this.layoutStartPoint().x, rect);
                height = rect.height();
                if (targetAdapterPosition >= adapterPosition) {
                    y += height;
                }
                layoutContext.currentLineItemCount = 1;
                continue;
            }
            x = this.advanceInSameLine(x, rect);
            height = Math.max(height, this.getDecoratedMeasuredHeight(child));
            ++layoutContext.currentLineItemCount;
        }
        return -y;
    }

    private boolean isChildRemoved(View child) {
        return ((RecyclerView.LayoutParams)child.getLayoutParams()).isItemRemoved();
    }

    public FlowLayoutManager setAlignment(Alignment alignment) {
        this.flowLayoutOptions.alignment = alignment;
        return this;
    }

    public FlowLayoutManager singleItemPerLine() {
        this.flowLayoutOptions.itemsPerLine = 1;
        if (this.cacheHelper != null) {
            this.cacheHelper.clear();
        }
        if (this.layoutHelper != null) {
            this.cacheHelper = new CacheHelper(1, this.layoutHelper.visibleAreaWidth());
        }
        return this;
    }

    public FlowLayoutManager maxItemsPerLine(int itemsPerLine) {
        this.flowLayoutOptions.itemsPerLine = itemsPerLine;
        if (this.cacheHelper != null) {
            this.cacheHelper.clear();
        }
        if (this.layoutHelper != null) {
            this.cacheHelper = new CacheHelper(itemsPerLine, this.layoutHelper.visibleAreaWidth());
        }
        return this;
    }

    public FlowLayoutManager removeItemPerLineLimit() {
        this.flowLayoutOptions.itemsPerLine = 0;
        if (this.cacheHelper != null) {
            this.cacheHelper.clear();
        }
        if (this.layoutHelper != null) {
            this.cacheHelper = new CacheHelper(0, this.layoutHelper.visibleAreaWidth());
        }
        return this;
    }

    private boolean calcChildLayoutRect(View child, int x, int y, int lineHeight, Rect rect) {
        return this.calcChildLayoutRect(child, x, y, lineHeight, LayoutContext.fromLayoutOptions(this.flowLayoutOptions), rect);
    }

    private boolean calcChildLayoutRect(View child, int x, int y, int lineHeight, LayoutContext layoutContext, Rect rect) {
        boolean newLine;
        this.measureChildWithMargins(child, 0, 0);
        int childWidth = this.getDecoratedMeasuredWidth(child);
        int childHeight = this.getDecoratedMeasuredHeight(child);
        switch (layoutContext.layoutOptions.alignment) {
            case RIGHT: {
                if (LayoutHelper.shouldStartNewline(x, childWidth, this.leftVisibleEdge(), this.rightVisibleEdge(), layoutContext)) {
                    newLine = true;
                    rect.left = this.rightVisibleEdge() - childWidth;
                    rect.top = y + lineHeight;
                    rect.right = this.rightVisibleEdge();
                    rect.bottom = rect.top + childHeight;
                    break;
                }
                newLine = false;
                rect.left = x - childWidth;
                rect.top = y;
                rect.right = x;
                rect.bottom = rect.top + childHeight;
                break;
            }
            default: {
                if (LayoutHelper.shouldStartNewline(x, childWidth, this.leftVisibleEdge(), this.rightVisibleEdge(), layoutContext)) {
                    newLine = true;
                    rect.left = this.leftVisibleEdge();
                    rect.top = y + lineHeight;
                    rect.right = rect.left + childWidth;
                    rect.bottom = rect.top + childHeight;
                    break;
                }
                newLine = false;
                rect.left = x;
                rect.top = y;
                rect.right = rect.left + childWidth;
                rect.bottom = rect.top + childHeight;
            }
        }
        return newLine;
    }

    private Point startNewline(Rect rect) {
        return this.startNewline(rect, LayoutContext.fromLayoutOptions(this.flowLayoutOptions));
    }

    private Point startNewline(Rect rect, LayoutContext layoutContext) {
        switch (layoutContext.layoutOptions.alignment) {
            case RIGHT: {
                return new Point(this.rightVisibleEdge() - rect.width(), rect.top);
            }
        }
        return new Point(this.leftVisibleEdge() + rect.width(), rect.top);
    }

    private int advanceInSameLine(int x, Rect rect) {
        return this.advanceInSameLine(x, rect, LayoutContext.fromLayoutOptions(this.flowLayoutOptions));
    }

    private int advanceInSameLine(int x, Rect rect, LayoutContext layoutContext) {
        switch (layoutContext.layoutOptions.alignment) {
            case RIGHT: {
                return x - rect.width();
            }
        }
        return x + rect.width();
    }

    private Point layoutStartPoint() {
        return this.layoutHelper.layoutStartPoint(LayoutContext.fromLayoutOptions(this.flowLayoutOptions));
    }

    private boolean isStartOfLine(int index) {
        return this.isStartOfLine(index, LayoutContext.fromLayoutOptions(this.flowLayoutOptions));
    }

    private boolean isStartOfLine(int index, LayoutContext layoutContext) {
        if (index == 0) {
            return true;
        }
        switch (layoutContext.layoutOptions.alignment) {
            case RIGHT: {
                return this.getDecoratedRight(this.getChildAt(index)) >= this.rightVisibleEdge();
            }
            case LEFT: {
                return this.getDecoratedLeft(this.getChildAt(index)) <= this.leftVisibleEdge();
            }
        }
        return this.getDecoratedTop(this.getChildAt(index)) > this.getDecoratedTop(this.getChildAt(index - 1));
    }

    private boolean isEndOfLine(int index) {
        return this.isEndOfLine(index, LayoutContext.fromLayoutOptions(this.flowLayoutOptions));
    }

    private boolean isEndOfLine(int index, LayoutContext layoutContext) {
        return LayoutHelper.hasItemsPerLineLimit(layoutContext.layoutOptions) && layoutContext.currentLineItemCount == layoutContext.layoutOptions.itemsPerLine || this.getChildCount() == 0 || index == this.getChildCount() - 1 || this.isStartOfLine(index + 1, layoutContext);
    }

    public int computeVerticalScrollExtent(RecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        if (this.flowLayoutOptions.alignment == Alignment.CENTER) {
            View startChild = this.getChildAt(0);
            View endChild = this.getChildAt(this.getChildCount() - 1);
            if (state.getItemCount() == 0 || startChild == null || endChild == null) {
                return 0;
            }
            return Math.abs(this.getPosition(startChild) - this.getPosition(endChild)) + 1;
        }
        return super.computeVerticalScrollExtent(state);
    }

    private int getTotalSpace() {
        return this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
    }

    public int computeVerticalScrollOffset(RecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        if (this.flowLayoutOptions.alignment == Alignment.CENTER) {
            View startChild = this.getChildAt(0);
            View endChild = this.getChildAt(this.getChildCount() - 1);
            if (state.getItemCount() == 0 || startChild == null || endChild == null) {
                return 0;
            }
            int minPosition = Math.min(this.getPosition(startChild), this.getPosition(endChild));
            int maxPosition = Math.max(this.getPosition(startChild), this.getPosition(endChild));
            int itemsBefore = Math.max(0, minPosition);
            return itemsBefore;
        }
        return super.computeVerticalScrollOffset(state);
    }

    public int computeVerticalScrollRange(RecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        return state.getItemCount();
    }
}

