/*
 * Decompiled with CFR 0.152.
 */
package com.xiaofeng.flowlayoutmanager;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;
import java.util.LinkedList;
import java.util.List;

public class FlowLayoutManager
extends RecyclerView.LayoutManager {
    private static final String LOG_TAG = "FlowLayoutManager";
    RecyclerView recyclerView;
    int firstChildAdapterPosition = 0;
    RecyclerView.Recycler recyclerRef;
    FlowLayoutOptions flowLayoutOptions;
    FlowLayoutOptions newFlowLayoutOptions;
    SparseArray<Rect> viewSizeCache = new SparseArray();

    public FlowLayoutManager() {
        this.flowLayoutOptions = new FlowLayoutOptions();
        this.newFlowLayoutOptions = FlowLayoutOptions.clone(this.flowLayoutOptions);
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.recyclerRef = recycler;
        if (state.isPreLayout()) {
            this.onPreLayoutChildren(recycler, state);
        } else {
            this.onRealLayoutChildren(recycler);
        }
    }

    private void onPreLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        int firstItemAdapterPosition = this.getChildAdapterPosition(0);
        if (firstItemAdapterPosition == -1) {
            this.detachAndScrapAttachedViews(recycler);
            return;
        }
        Point point = this.layoutStartPoint(LayoutContext.fromLayoutOptions(this.flowLayoutOptions));
        int x = point.x;
        int y = point.y;
        int height = 0;
        int real_x = point.x;
        int real_y = point.y;
        int real_height = 0;
        Rect rect = new Rect();
        Rect real_rect = new Rect();
        this.detachAndScrapAttachedViews(recycler);
        LayoutContext beforeContext = LayoutContext.fromLayoutOptions(this.flowLayoutOptions);
        LayoutContext afterContext = LayoutContext.clone(beforeContext);
        afterContext.layoutOptions.itemsPerLine = this.newFlowLayoutOptions.itemsPerLine;
        for (int currentItemPosition = firstItemAdapterPosition < 0 ? 0 : firstItemAdapterPosition; currentItemPosition < state.getItemCount(); ++currentItemPosition) {
            View child = recycler.getViewForPosition(currentItemPosition);
            boolean childRemoved = this.isChildRemoved(child);
            boolean newline = this.calcChildLayoutRect(child, x, y, height, beforeContext, rect);
            if (newline) {
                point = this.startNewline(rect, beforeContext);
                x = point.x;
                y = point.y;
                height = rect.height();
                beforeContext.currentLineItemCount = 1;
            } else {
                x = this.advanceInSameLine(x, rect, beforeContext);
                height = Math.max(height, rect.height());
                ++beforeContext.currentLineItemCount;
            }
            if (!childRemoved) {
                boolean real_newline = this.calcChildLayoutRect(child, real_x, real_y, real_height, afterContext, real_rect);
                if (real_newline) {
                    point = this.startNewline(real_rect, afterContext);
                    real_x = point.x;
                    real_y = point.y;
                    real_height = real_rect.height();
                    afterContext.currentLineItemCount = 1;
                } else {
                    real_x = this.advanceInSameLine(real_x, real_rect, afterContext);
                    real_height = Math.max(real_height, real_rect.height());
                    ++afterContext.currentLineItemCount;
                }
            }
            if (!this.childVisible(real_x, real_y, real_x + rect.width(), real_y + rect.height())) {
                recycler.recycleView(child);
                break;
            }
            if (childRemoved) {
                this.addDisappearingView(child);
            } else {
                this.addView(child);
            }
            this.layoutDecorated(child, rect.left, rect.top, rect.right, rect.bottom);
        }
        this.flowLayoutOptions = FlowLayoutOptions.clone(this.newFlowLayoutOptions);
    }

    private void onRealLayoutChildren(RecyclerView.Recycler recycler) {
        this.detachAndScrapAttachedViews(recycler);
        Point startPoint = this.layoutStartPoint();
        int x = startPoint.x;
        int y = startPoint.y;
        int itemCount = this.getItemCount();
        int height = 0;
        Rect rect = new Rect();
        LayoutContext layoutContext = LayoutContext.fromLayoutOptions(this.flowLayoutOptions);
        for (int i = this.firstChildAdapterPosition; i < itemCount; ++i) {
            View child = recycler.getViewForPosition(i);
            boolean newLine = this.calcChildLayoutRect(child, x, y, height, layoutContext, rect);
            if (!this.childVisible(rect)) {
                recycler.recycleView(child);
                return;
            }
            this.addView(child);
            this.layoutDecorated(child, rect.left, rect.top, rect.right, rect.bottom);
            if (newLine) {
                Point lineInfo = this.startNewline(rect);
                x = lineInfo.x;
                y = lineInfo.y;
                height = rect.height();
                layoutContext.currentLineItemCount = 1;
                continue;
            }
            x = this.advanceInSameLine(x, rect, layoutContext);
            height = Math.max(height, rect.height());
            ++layoutContext.currentLineItemCount;
        }
    }

    public boolean canScrollHorizontally() {
        return false;
    }

    public boolean canScrollVertically() {
        if (this.getChildCount() == 0) {
            return false;
        }
        View firstChild = this.getChildAt(0);
        View lastChild = this.getChildAt(this.getChildCount() - 1);
        View topChild = this.getChildAt(this.getMaxHeightIndexInLine(0));
        View bottomChild = this.getChildAt(this.getMaxHeightIndexInLine(this.getChildCount() - 1));
        boolean topReached = false;
        boolean bottomReached = false;
        if (this.getChildAdapterPosition(firstChild) == 0 && this.getDecoratedTop(topChild) >= this.topVisibleEdge()) {
            topReached = true;
        }
        if (this.getChildAdapterPosition(lastChild) == this.recyclerView.getAdapter().getItemCount() - 1 && this.getDecoratedBottom(bottomChild) <= this.bottomVisibleEdge()) {
            bottomReached = true;
        }
        return !topReached || !bottomReached;
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (dy == 0) {
            return 0;
        }
        if (this.getItemCount() == 0) {
            return 0;
        }
        View firstChild = this.getChildAt(0);
        View lastChild = this.getChildAt(this.getChildCount() - 1);
        View topChild = this.getChildAt(this.getMaxHeightIndexInLine(0));
        View bottomChild = this.getChildAt(this.getMaxHeightIndexInLine(this.getChildCount() - 1));
        boolean topReached = false;
        boolean bottomReached = false;
        if (this.getChildAdapterPosition(firstChild) == 0 && this.getDecoratedTop(topChild) >= this.topVisibleEdge()) {
            topReached = true;
        }
        if (this.getChildAdapterPosition(lastChild) == this.recyclerView.getAdapter().getItemCount() - 1 && this.getDecoratedBottom(bottomChild) <= this.bottomVisibleEdge()) {
            bottomReached = true;
        }
        if (dy > 0 && bottomReached) {
            return 0;
        }
        if (dy < 0 && topReached) {
            return 0;
        }
        return dy > 0 ? this.contentMoveUp(dy, recycler) : this.contentMoveDown(dy, recycler);
    }

    public void onItemsChanged(RecyclerView recyclerView) {
        this.flowLayoutOptions = FlowLayoutOptions.clone(this.newFlowLayoutOptions);
        this.viewSizeCache.clear();
        super.onItemsChanged(recyclerView);
    }

    public void onItemsAdded(RecyclerView recyclerView, final int positionStart, final int itemCount) {
        this.updateViewCache(new ViewCacheUpdateCallback(){

            @Override
            public boolean shouldUpdate(int position) {
                return position >= positionStart;
            }

            @Override
            public int alterPosition(int position) {
                return position + itemCount;
            }
        });
        super.onItemsAdded(recyclerView, positionStart, itemCount);
    }

    private void updateViewCache(ViewCacheUpdateCallback updateCallback) {
        int i;
        SparseArray temp = new SparseArray();
        for (i = 0; i < this.viewSizeCache.size(); ++i) {
            int key = this.viewSizeCache.keyAt(i);
            if (!updateCallback.shouldUpdate(key)) continue;
            temp.append(updateCallback.alterPosition(key), this.viewSizeCache.get(key));
            this.viewSizeCache.remove(key);
        }
        for (i = 0; i < temp.size(); ++i) {
            int tmpKey = temp.keyAt(i);
            this.viewSizeCache.append(tmpKey, temp.get(tmpKey));
        }
        temp.clear();
    }

    public void onItemsRemoved(RecyclerView recyclerView, final int positionStart, final int itemCount) {
        for (int i = positionStart; i < positionStart + itemCount; ++i) {
            this.viewSizeCache.remove(i);
        }
        this.updateViewCache(new ViewCacheUpdateCallback(){

            @Override
            public boolean shouldUpdate(int position) {
                return position >= positionStart + itemCount;
            }

            @Override
            public int alterPosition(int position) {
                return position - itemCount;
            }
        });
        super.onItemsRemoved(recyclerView, positionStart, itemCount);
    }

    public void onItemsUpdated(RecyclerView recyclerView, int positionStart, int itemCount) {
        for (int i = positionStart; i < positionStart + itemCount; ++i) {
            this.viewSizeCache.remove(i);
        }
        super.onItemsUpdated(recyclerView, positionStart, itemCount);
    }

    public void onItemsUpdated(RecyclerView recyclerView, int positionStart, int itemCount, Object payload) {
        for (int i = positionStart; i < positionStart + itemCount; ++i) {
            this.viewSizeCache.remove(i);
        }
        super.onItemsUpdated(recyclerView, positionStart, itemCount, payload);
    }

    public void onItemsMoved(RecyclerView recyclerView, final int from, final int to, int itemCount) {
        boolean movingForward = to - from > 0;
        int steps = Math.abs(to - from);
        SparseArray temp = new SparseArray();
        for (int i = 0; i < itemCount; ++i) {
            int currentPosition = from + i;
            temp.append(currentPosition + (to - from), this.viewSizeCache.get(currentPosition));
            this.viewSizeCache.remove(currentPosition);
        }
        final int start = movingForward ? from + itemCount : from - steps;
        final int end = start + steps;
        this.updateViewCache(new ViewCacheUpdateCallback(){

            @Override
            public boolean shouldUpdate(int position) {
                return position >= start && position < end;
            }

            @Override
            public int alterPosition(int position) {
                return position + from - to;
            }
        });
        for (int i = 0; i < temp.size(); ++i) {
            this.viewSizeCache.append(temp.keyAt(i), temp.get(temp.keyAt(i)));
        }
        temp.clear();
        super.onItemsMoved(recyclerView, from, to, itemCount);
    }

    private int contentMoveUp(int dy, RecyclerView.Recycler recycler) {
        int actualDy = dy;
        int maxHeightIndex = this.getMaxHeightIndexInLine(this.getChildCount() - 1);
        View maxHeightItem = this.getChildAt(maxHeightIndex);
        int offscreenBottom = this.getDecoratedBottom(maxHeightItem) - this.bottomVisibleEdge();
        if (offscreenBottom >= dy) {
            this.offsetChildrenVertical(-dy);
            return dy;
        }
        while (this.getChildAdapterPosition(this.getChildCount() - 1) < this.getItemCount() - 1) {
            this.addNewLineAtBottom(recycler);
            maxHeightIndex = this.getMaxHeightIndexInLine(this.getChildCount() - 1);
            maxHeightItem = this.getChildAt(maxHeightIndex);
            if ((offscreenBottom += this.getDecoratedMeasuredHeight(maxHeightItem)) < dy) continue;
        }
        if (offscreenBottom < dy) {
            actualDy = offscreenBottom;
        }
        this.offsetChildrenVertical(-actualDy);
        while (!this.lineVisible(0)) {
            this.recycleLine(0, recycler);
        }
        this.firstChildAdapterPosition = this.getChildAdapterPosition(0);
        return actualDy;
    }

    private int contentMoveDown(int dy, RecyclerView.Recycler recycler) {
        int actualDy = dy;
        int maxHeightItemIndex = this.getMaxHeightIndexInLine(0);
        View maxHeightItem = this.getChildAt(maxHeightItemIndex);
        int offScreenTop = this.topVisibleEdge() - this.getDecoratedTop(maxHeightItem);
        if (offScreenTop > Math.abs(actualDy)) {
            this.offsetChildrenVertical(-dy);
            return dy;
        }
        while (this.getChildAdapterPosition(0) > 0) {
            this.addNewLineAtTop(recycler);
            maxHeightItemIndex = this.getMaxHeightIndexInLine(0);
            maxHeightItem = this.getChildAt(maxHeightItemIndex);
            if ((offScreenTop += this.getDecoratedMeasuredHeight(maxHeightItem)) < Math.abs(dy)) continue;
        }
        if (offScreenTop < Math.abs(dy)) {
            actualDy = -offScreenTop;
        }
        this.offsetChildrenVertical(-actualDy);
        while (!this.lineVisible(this.getChildCount() - 1)) {
            this.recycleLine(this.getChildCount() - 1, recycler);
        }
        this.firstChildAdapterPosition = this.getChildAdapterPosition(0);
        return actualDy;
    }

    private void addNewLineAtTop(RecyclerView.Recycler recycler) {
        boolean newline;
        int x = this.layoutStartPoint().x;
        int bottom = this.getDecoratedTop(this.getChildAt(this.getMaxHeightIndexInLine(0)));
        int height = 0;
        LinkedList<View> lineChildren = new LinkedList<View>();
        int endAdapterPosition = this.getChildAdapterPosition(0) - 1;
        Rect rect = new Rect();
        boolean firstItem = true;
        LayoutContext layoutContext = LayoutContext.fromLayoutOptions(this.flowLayoutOptions);
        for (int currentAdapterPosition = 0; currentAdapterPosition <= endAdapterPosition; ++currentAdapterPosition) {
            View newChild = recycler.getViewForPosition(currentAdapterPosition);
            newline = this.calcChildLayoutRect(newChild, x, 0, height, layoutContext, rect);
            this.addView(newChild, lineChildren.size());
            if (newline && !firstItem) {
                for (View viewToRecycle : lineChildren) {
                    this.removeAndRecycleView(viewToRecycle, recycler);
                }
                lineChildren.clear();
                x = this.advanceInSameLine(this.layoutStartPoint().x, rect, layoutContext);
                height = rect.height();
                layoutContext.currentLineItemCount = 1;
            } else {
                x = this.advanceInSameLine(x, rect, layoutContext);
                height = Math.max(height, rect.height());
                firstItem = false;
                ++layoutContext.currentLineItemCount;
            }
            lineChildren.add(newChild);
        }
        x = this.layoutStartPoint().x;
        int y = bottom - height;
        firstItem = true;
        layoutContext = LayoutContext.fromLayoutOptions(this.flowLayoutOptions);
        for (int i = 0; i < lineChildren.size(); ++i) {
            View childView = (View)lineChildren.get(i);
            newline = this.calcChildLayoutRect(childView, x, y, height, layoutContext, rect);
            if (newline && firstItem) {
                int rectHeight = rect.height();
                rect.top -= rectHeight;
                rect.bottom -= rectHeight;
                firstItem = false;
            }
            this.layoutDecorated(childView, rect.left, rect.top, rect.right, rect.bottom);
            x = this.advanceInSameLine(x, rect, layoutContext);
        }
    }

    private void addNewLineAtBottom(RecyclerView.Recycler recycler) {
        int x = this.layoutStartPoint().x;
        int y = this.getDecoratedBottom(this.getChildAt(this.getMaxHeightIndexInLine(this.getChildCount() - 1)));
        int childAdapterPosition = this.getChildAdapterPosition(this.getChildCount() - 1) + 1;
        if (childAdapterPosition == this.getItemCount()) {
            return;
        }
        Rect rect = new Rect();
        boolean firstItem = true;
        LayoutContext layoutContext = LayoutContext.fromLayoutOptions(this.flowLayoutOptions);
        while (childAdapterPosition < this.getItemCount()) {
            View newChild = recycler.getViewForPosition(childAdapterPosition);
            boolean newline = this.calcChildLayoutRect(newChild, x, y, 0, layoutContext, rect);
            if (newline && !firstItem) {
                recycler.recycleView(newChild);
                layoutContext.currentLineItemCount = 1;
                return;
            }
            this.addView(newChild);
            this.layoutDecorated(newChild, rect.left, rect.top, rect.right, rect.bottom);
            x = this.advanceInSameLine(x, rect, layoutContext);
            ++childAdapterPosition;
            firstItem = false;
            ++layoutContext.currentLineItemCount;
        }
    }

    public void onAttachedToWindow(RecyclerView view) {
        super.onAttachedToWindow(view);
        this.recyclerView = view;
    }

    public boolean supportsPredictiveItemAnimations() {
        return true;
    }

    public void scrollToPosition(int position) {
        this.firstChildAdapterPosition = position;
        this.requestLayout();
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        LinearSmoothScroller smoothScroller = new LinearSmoothScroller(recyclerView.getContext()){

            public PointF computeScrollVectorForPosition(int targetPosition) {
                return new PointF(0.0f, (float)FlowLayoutManager.this.getOffsetOfItemToFirstChild(targetPosition, FlowLayoutManager.this.recyclerRef));
            }
        };
        smoothScroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)smoothScroller);
    }

    private int leftVisibleEdge() {
        return this.getPaddingLeft();
    }

    private int rightVisibleEdge() {
        return this.getWidth() - this.getPaddingRight();
    }

    private int topVisibleEdge() {
        return this.getPaddingTop();
    }

    private int bottomVisibleEdge() {
        return this.getHeight() - this.getPaddingBottom();
    }

    private boolean childVisible(int left, int top, int right, int bottom) {
        return Rect.intersects((Rect)new Rect(this.leftVisibleEdge(), this.topVisibleEdge(), this.rightVisibleEdge(), this.bottomVisibleEdge()), (Rect)new Rect(left, top, right, bottom));
    }

    private boolean childVisible(Rect childRect) {
        return Rect.intersects((Rect)new Rect(this.leftVisibleEdge(), this.topVisibleEdge(), this.rightVisibleEdge(), this.bottomVisibleEdge()), (Rect)childRect);
    }

    private int getMaxHeightIndexInLine(int index) {
        int currentIndex;
        View child = this.getChildAt(index);
        int maxIndexBefore = index;
        int maxIndexAfter = index;
        int maxHeightBefore = this.getDecoratedMeasuredHeight(child);
        int maxHeightAfter = this.getDecoratedMeasuredHeight(child);
        LayoutContext layoutContext = LayoutContext.fromLayoutOptions(this.flowLayoutOptions);
        for (currentIndex = index; currentIndex >= 0 && !this.isStartOfLine(currentIndex, layoutContext); --currentIndex) {
            View beforeChild = this.getChildAt(currentIndex);
            if (this.getDecoratedMeasuredHeight(beforeChild) <= maxHeightBefore) continue;
            maxIndexBefore = currentIndex;
            maxHeightBefore = this.getDecoratedMeasuredHeight(beforeChild);
        }
        if (maxHeightBefore < this.getDecoratedMeasuredHeight(this.getChildAt(currentIndex))) {
            maxIndexBefore = currentIndex;
            maxHeightBefore = this.getDecoratedMeasuredHeight(this.getChildAt(currentIndex));
        }
        for (currentIndex = index; currentIndex < this.getChildCount() && !this.isEndOfLine(currentIndex, layoutContext); ++currentIndex) {
            View afterChild = this.getChildAt(currentIndex);
            if (this.getDecoratedMeasuredHeight(afterChild) <= maxHeightAfter) continue;
            maxIndexAfter = currentIndex;
            maxHeightAfter = this.getDecoratedMeasuredHeight(afterChild);
        }
        if (maxHeightAfter < this.getDecoratedMeasuredHeight(this.getChildAt(currentIndex))) {
            maxIndexAfter = currentIndex;
            maxHeightAfter = this.getDecoratedMeasuredHeight(this.getChildAt(currentIndex));
        }
        if (maxHeightBefore >= maxHeightAfter) {
            return maxIndexBefore;
        }
        return maxIndexAfter;
    }

    private List<View> getAllViewsInLine(int index) {
        int firstItemIndex = index;
        while (!this.isStartOfLine(firstItemIndex)) {
            --firstItemIndex;
        }
        LinkedList<View> viewList = new LinkedList<View>();
        viewList.add(this.getChildAt(firstItemIndex));
        LayoutContext layoutContext = LayoutContext.fromLayoutOptions(this.flowLayoutOptions);
        for (int nextItemIndex = firstItemIndex + 1; nextItemIndex < this.getChildCount() && !this.isStartOfLine(nextItemIndex, layoutContext); ++nextItemIndex) {
            viewList.add(this.getChildAt(nextItemIndex));
        }
        return viewList;
    }

    private int getChildAdapterPosition(int index) {
        return this.getChildAdapterPosition(this.getChildAt(index));
    }

    private int getChildAdapterPosition(View child) {
        if (child == null) {
            return -1;
        }
        return ((RecyclerView.LayoutParams)child.getLayoutParams()).getViewAdapterPosition();
    }

    public int getChildLayoutPosition(View child) {
        return ((RecyclerView.LayoutParams)child.getLayoutParams()).getViewLayoutPosition();
    }

    private boolean lineVisible(int index) {
        int maxHeightItemIndex = this.getMaxHeightIndexInLine(index);
        View maxHeightItem = this.getChildAt(maxHeightItemIndex);
        return Rect.intersects((Rect)new Rect(this.leftVisibleEdge(), this.topVisibleEdge(), this.rightVisibleEdge(), this.bottomVisibleEdge()), (Rect)new Rect(this.leftVisibleEdge(), this.getDecoratedTop(maxHeightItem), this.rightVisibleEdge(), this.getDecoratedBottom(maxHeightItem)));
    }

    private void recycleLine(int index, RecyclerView.Recycler recycler) {
        List<View> viewList = this.getAllViewsInLine(index);
        for (View viewToRecycle : viewList) {
            this.removeAndRecycleView(viewToRecycle, recycler);
        }
    }

    private int getOffsetOfItemToFirstChild(int adapterPosition, RecyclerView.Recycler recycler) {
        int firstChildPosition = this.getChildAdapterPosition(0);
        if (firstChildPosition == adapterPosition) {
            return this.topVisibleEdge() - this.getDecoratedTop(this.getChildAt(0));
        }
        if (adapterPosition > firstChildPosition) {
            int lastChildAdapterPosition = this.getChildAdapterPosition(this.getChildCount() - 1);
            if (lastChildAdapterPosition >= adapterPosition) {
                int targetChildIndex = this.getChildCount() - 1 - (lastChildAdapterPosition - adapterPosition);
                return this.getDecoratedTop(this.getChildAt(targetChildIndex)) - this.topVisibleEdge();
            }
            int y = this.getDecoratedBottom(this.getChildAt(this.getMaxHeightIndexInLine(this.getChildCount() - 1))) - this.topVisibleEdge();
            int x = this.layoutStartPoint().x;
            int height = 0;
            Rect rect = new Rect();
            LayoutContext layoutContext = LayoutContext.fromLayoutOptions(this.flowLayoutOptions);
            for (int targetAdapterPosition = lastChildAdapterPosition + 1; targetAdapterPosition != adapterPosition; ++targetAdapterPosition) {
                View nextChild = recycler.getViewForPosition(targetAdapterPosition);
                boolean newline = this.calcChildLayoutRect(nextChild, x, y, height, layoutContext, rect);
                if (newline) {
                    x = this.advanceInSameLine(this.layoutStartPoint().x, rect, layoutContext);
                    y = rect.top;
                    height = rect.height();
                    layoutContext.currentLineItemCount = 1;
                } else {
                    x = this.advanceInSameLine(x, rect, layoutContext);
                    height = Math.max(height, this.getDecoratedMeasuredHeight(nextChild));
                    ++layoutContext.currentLineItemCount;
                }
                recycler.recycleView(nextChild);
            }
            return y;
        }
        int x = this.layoutStartPoint().x;
        int height = 0;
        int y = this.topVisibleEdge() - this.getDecoratedTop(this.getChildAt(0));
        Rect rect = new Rect();
        LayoutContext layoutContext = LayoutContext.fromLayoutOptions(this.flowLayoutOptions);
        for (int targetAdapterPosition = 0; targetAdapterPosition <= firstChildPosition; ++targetAdapterPosition) {
            View child = recycler.getViewForPosition(targetAdapterPosition);
            boolean newline = this.calcChildLayoutRect(child, x, y, height, rect);
            if (newline) {
                x = this.advanceInSameLine(this.layoutStartPoint().x, rect);
                height = rect.height();
                if (targetAdapterPosition >= adapterPosition) {
                    y += height;
                }
                layoutContext.currentLineItemCount = 1;
                continue;
            }
            x = this.advanceInSameLine(x, rect);
            height = Math.max(height, this.getDecoratedMeasuredHeight(child));
            ++layoutContext.currentLineItemCount;
        }
        return -y;
    }

    private boolean isChildRemoved(View child) {
        return ((RecyclerView.LayoutParams)child.getLayoutParams()).isItemRemoved();
    }

    public FlowLayoutManager setAlignment(Alignment alignment) {
        this.newFlowLayoutOptions.alignment = alignment;
        return this;
    }

    public FlowLayoutManager singleItemPerLine() {
        this.newFlowLayoutOptions.itemsPerLine = 1;
        return this;
    }

    public FlowLayoutManager maxItemsPerLine(int itemsPerLine) {
        this.newFlowLayoutOptions.itemsPerLine = itemsPerLine;
        return this;
    }

    public FlowLayoutManager removeItemPerLineLimit() {
        this.newFlowLayoutOptions.itemsPerLine = 0;
        return this;
    }

    private boolean calcChildLayoutRect(View child, int x, int y, int lineHeight, Rect rect) {
        return this.calcChildLayoutRect(child, x, y, lineHeight, LayoutContext.fromLayoutOptions(this.flowLayoutOptions), rect);
    }

    private boolean calcChildLayoutRect(View child, int x, int y, int lineHeight, LayoutContext layoutContext, Rect rect) {
        boolean newLine;
        this.measureChildWithMargins(child, 0, 0);
        int childWidth = this.getDecoratedMeasuredWidth(child);
        int childHeight = this.getDecoratedMeasuredHeight(child);
        switch (layoutContext.layoutOptions.alignment) {
            case RIGHT: {
                if (this.shouldStartNewline(x, childWidth, layoutContext)) {
                    newLine = true;
                    rect.left = this.rightVisibleEdge() - childWidth;
                    rect.top = y + lineHeight;
                    rect.right = this.rightVisibleEdge();
                    rect.bottom = rect.top + childHeight;
                    break;
                }
                newLine = false;
                rect.left = x - childWidth;
                rect.top = y;
                rect.right = x;
                rect.bottom = rect.top + childHeight;
                break;
            }
            default: {
                if (this.shouldStartNewline(x, childWidth, layoutContext)) {
                    newLine = true;
                    rect.left = this.leftVisibleEdge();
                    rect.top = y + lineHeight;
                    rect.right = rect.left + childWidth;
                    rect.bottom = rect.top + childHeight;
                    break;
                }
                newLine = false;
                rect.left = x;
                rect.top = y;
                rect.right = rect.left + childWidth;
                rect.bottom = rect.top + childHeight;
            }
        }
        return newLine;
    }

    private Point startNewline(Rect rect) {
        return this.startNewline(rect, LayoutContext.fromLayoutOptions(this.flowLayoutOptions));
    }

    private Point startNewline(Rect rect, LayoutContext layoutContext) {
        switch (layoutContext.layoutOptions.alignment) {
            case RIGHT: {
                return new Point(this.rightVisibleEdge() - rect.width(), rect.top);
            }
        }
        return new Point(this.leftVisibleEdge() + rect.width(), rect.top);
    }

    private int advanceInSameLine(int x, Rect rect) {
        return this.advanceInSameLine(x, rect, LayoutContext.fromLayoutOptions(this.flowLayoutOptions));
    }

    private int advanceInSameLine(int x, Rect rect, LayoutContext layoutContext) {
        switch (layoutContext.layoutOptions.alignment) {
            case RIGHT: {
                return x - rect.width();
            }
        }
        return x + rect.width();
    }

    private Point layoutStartPoint() {
        return this.layoutStartPoint(LayoutContext.fromLayoutOptions(this.flowLayoutOptions));
    }

    private Point layoutStartPoint(LayoutContext layoutContext) {
        switch (layoutContext.layoutOptions.alignment) {
            case RIGHT: {
                return new Point(this.rightVisibleEdge(), this.topVisibleEdge());
            }
        }
        return new Point(this.leftVisibleEdge(), this.topVisibleEdge());
    }

    private boolean isStartOfLine(int index) {
        return this.isStartOfLine(index, LayoutContext.fromLayoutOptions(this.flowLayoutOptions));
    }

    private boolean isStartOfLine(int index, LayoutContext layoutContext) {
        if (index == 0) {
            return true;
        }
        switch (layoutContext.layoutOptions.alignment) {
            case RIGHT: {
                return this.getDecoratedRight(this.getChildAt(index)) >= this.rightVisibleEdge();
            }
        }
        return this.getDecoratedLeft(this.getChildAt(index)) <= this.leftVisibleEdge();
    }

    private boolean isEndOfLine(int index) {
        return this.isEndOfLine(index, LayoutContext.fromLayoutOptions(this.flowLayoutOptions));
    }

    private boolean isEndOfLine(int index, LayoutContext layoutContext) {
        if (this.hasItemsPerLineLimit(layoutContext.layoutOptions) && layoutContext.currentLineItemCount == layoutContext.layoutOptions.itemsPerLine) {
            return true;
        }
        if (this.getChildCount() == 0 || index == this.getChildCount() - 1) {
            return true;
        }
        return this.isStartOfLine(index + 1, layoutContext);
    }

    private boolean shouldStartNewline(int x, int childWidth, LayoutContext layoutContext) {
        if (this.hasItemsPerLineLimit(layoutContext.layoutOptions) && layoutContext.currentLineItemCount == layoutContext.layoutOptions.itemsPerLine) {
            return true;
        }
        switch (layoutContext.layoutOptions.alignment) {
            case RIGHT: {
                return x - childWidth < this.leftVisibleEdge();
            }
        }
        return x + childWidth > this.rightVisibleEdge();
    }

    private boolean hasItemsPerLineLimit(FlowLayoutOptions layoutOptions) {
        return layoutOptions.itemsPerLine > 0;
    }

    public static class LayoutContext {
        public FlowLayoutOptions layoutOptions;
        public int currentLineItemCount;

        public static LayoutContext clone(LayoutContext layoutContext) {
            LayoutContext resultContext = new LayoutContext();
            resultContext.currentLineItemCount = layoutContext.currentLineItemCount;
            resultContext.layoutOptions = FlowLayoutOptions.clone(layoutContext.layoutOptions);
            return resultContext;
        }

        public static LayoutContext fromLayoutOptions(FlowLayoutOptions layoutOptions) {
            LayoutContext layoutContext = new LayoutContext();
            layoutContext.layoutOptions = layoutOptions;
            return layoutContext;
        }
    }

    public static class FlowLayoutOptions {
        public static final int ITEM_PER_LINE_NO_LIMIT = 0;
        public Alignment alignment = Alignment.LEFT;
        public int itemsPerLine = 0;

        public static FlowLayoutOptions clone(FlowLayoutOptions layoutOptions) {
            FlowLayoutOptions result = new FlowLayoutOptions();
            result.alignment = layoutOptions.alignment;
            result.itemsPerLine = layoutOptions.itemsPerLine;
            return result;
        }
    }

    public static interface ViewCacheUpdateCallback {
        public boolean shouldUpdate(int var1);

        public int alterPosition(int var1);
    }

    static enum Alignment {
        LEFT,
        RIGHT;

    }
}

