/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event.deserialization.json;

import com.github.shyiko.mysql.binlog.event.deserialization.AbstractRowsEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.ColumnType;
import com.github.shyiko.mysql.binlog.event.deserialization.json.JsonFormatter;
import com.github.shyiko.mysql.binlog.event.deserialization.json.JsonStringFormatter;
import com.github.shyiko.mysql.binlog.event.deserialization.json.ValueType;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;

public class JsonBinary {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final ByteArrayInputStream reader;

    public static String parseAsString(byte[] bytes) throws IOException {
        JsonStringFormatter handler = new JsonStringFormatter();
        JsonBinary.parse(bytes, handler);
        return handler.getString();
    }

    public static void parse(byte[] bytes, JsonFormatter formatter) throws IOException {
        new JsonBinary(bytes).parse(formatter);
    }

    public JsonBinary(byte[] bytes) {
        this(new ByteArrayInputStream(bytes));
    }

    public JsonBinary(ByteArrayInputStream contents) {
        this.reader = contents;
    }

    public String getString() {
        JsonStringFormatter handler = new JsonStringFormatter();
        try {
            this.parse(handler);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return handler.getString();
    }

    public void parse(JsonFormatter formatter) throws IOException {
        this.parse(this.readValueType(), formatter);
    }

    protected void parse(ValueType type, JsonFormatter formatter) throws IOException {
        switch (type) {
            case SMALL_DOCUMENT: {
                this.parseObject(true, formatter);
                break;
            }
            case LARGE_DOCUMENT: {
                this.parseObject(false, formatter);
                break;
            }
            case SMALL_ARRAY: {
                this.parseArray(true, formatter);
                break;
            }
            case LARGE_ARRAY: {
                this.parseArray(false, formatter);
                break;
            }
            case LITERAL: {
                this.parseBoolean(formatter);
                break;
            }
            case INT16: {
                this.parseInt16(formatter);
                break;
            }
            case UINT16: {
                this.parseUInt16(formatter);
                break;
            }
            case INT32: {
                this.parseInt32(formatter);
                break;
            }
            case UINT32: {
                this.parseUInt32(formatter);
                break;
            }
            case INT64: {
                this.parseInt64(formatter);
                break;
            }
            case UINT64: {
                this.parseUInt64(formatter);
                break;
            }
            case DOUBLE: {
                this.parseDouble(formatter);
                break;
            }
            case STRING: {
                this.parseString(formatter);
                break;
            }
            case CUSTOM: {
                this.parseOpaque(formatter);
                break;
            }
            default: {
                throw new IOException("Unknown type value '" + JsonBinary.asHex(type.getCode()) + "' in first byte of a JSON value");
            }
        }
    }

    protected void parseObject(boolean small, JsonFormatter formatter) throws IOException {
        int i;
        int numElements = this.readUnsignedIndex(Integer.MAX_VALUE, small, "number of elements in");
        int numBytes = this.readUnsignedIndex(Integer.MAX_VALUE, small, "size of");
        int valueSize = small ? 2 : 4;
        int[] keyLengths = new int[numElements];
        for (int i2 = 0; i2 != numElements; ++i2) {
            this.readUnsignedIndex(numBytes, small, "key offset in");
            keyLengths[i2] = this.readUInt16();
        }
        ValueEntry[] entries = new ValueEntry[numElements];
        block8: for (int i3 = 0; i3 != numElements; ++i3) {
            ValueType type = this.readValueType();
            switch (type) {
                case LITERAL: {
                    entries[i3] = new ValueEntry(type).setValue(this.readLiteral());
                    this.reader.skip(valueSize - 1);
                    continue block8;
                }
                case INT16: {
                    entries[i3] = new ValueEntry(type).setValue(this.readInt16());
                    this.reader.skip(valueSize - 2);
                    continue block8;
                }
                case UINT16: {
                    entries[i3] = new ValueEntry(type).setValue(this.readUInt16());
                    this.reader.skip(valueSize - 2);
                    continue block8;
                }
                case INT32: {
                    if (!small) {
                        entries[i3] = new ValueEntry(type).setValue(this.readInt32());
                        continue block8;
                    }
                }
                case UINT32: {
                    if (!small) {
                        entries[i3] = new ValueEntry(type).setValue(this.readUInt32());
                        continue block8;
                    }
                }
                default: {
                    int offset = this.readUnsignedIndex(Integer.MAX_VALUE, small, "value offset in");
                    if (offset >= numBytes) {
                        throw new IOException("The offset for the value in the JSON binary document is " + offset + ", which is larger than the binary form of the JSON document (" + numBytes + " bytes)");
                    }
                    entries[i3] = new ValueEntry(type, offset);
                }
            }
        }
        String[] keys = new String[numElements];
        for (i = 0; i != numElements; ++i) {
            keys[i] = this.reader.readString(keyLengths[i]);
        }
        formatter.beginObject(numElements);
        for (i = 0; i != numElements; ++i) {
            if (i != 0) {
                formatter.nextEntry();
            }
            formatter.name(keys[i]);
            ValueEntry entry = entries[i];
            if (entry.resolved) {
                Object value = entry.value;
                if (value == null) {
                    formatter.valueNull();
                    continue;
                }
                if (value instanceof Boolean) {
                    formatter.value((Boolean)value);
                    continue;
                }
                if (!(value instanceof Integer)) continue;
                formatter.value((Integer)value);
                continue;
            }
            this.parse(entry.type, formatter);
        }
        formatter.endObject();
    }

    protected void parseArray(boolean small, JsonFormatter formatter) throws IOException {
        int i;
        int numElements = this.readUnsignedIndex(Integer.MAX_VALUE, small, "number of elements in");
        int numBytes = this.readUnsignedIndex(Integer.MAX_VALUE, small, "size of");
        int valueSize = small ? 2 : 4;
        ValueEntry[] entries = new ValueEntry[numElements];
        block7: for (i = 0; i != numElements; ++i) {
            ValueType type = this.readValueType();
            switch (type) {
                case LITERAL: {
                    entries[i] = new ValueEntry(type).setValue(this.readLiteral());
                    this.reader.skip(valueSize - 1);
                    continue block7;
                }
                case INT16: {
                    entries[i] = new ValueEntry(type).setValue(this.readInt16());
                    this.reader.skip(valueSize - 2);
                    continue block7;
                }
                case UINT16: {
                    entries[i] = new ValueEntry(type).setValue(this.readUInt16());
                    this.reader.skip(valueSize - 2);
                    continue block7;
                }
                case INT32: {
                    if (!small) {
                        entries[i] = new ValueEntry(type).setValue(this.readInt32());
                        continue block7;
                    }
                }
                case UINT32: {
                    if (!small) {
                        entries[i] = new ValueEntry(type).setValue(this.readUInt32());
                        continue block7;
                    }
                }
                default: {
                    int offset = this.readUnsignedIndex(Integer.MAX_VALUE, small, "value offset in");
                    if (offset >= numBytes) {
                        throw new IOException("The offset for the value in the JSON binary document is " + offset + ", which is larger than the binary form of the JSON document (" + numBytes + " bytes)");
                    }
                    entries[i] = new ValueEntry(type, offset);
                }
            }
        }
        formatter.beginArray(numElements);
        for (i = 0; i != numElements; ++i) {
            if (i != 0) {
                formatter.nextEntry();
            }
            ValueEntry entry = entries[i];
            if (entry.resolved) {
                Object value = entry.value;
                if (value == null) {
                    formatter.valueNull();
                    continue;
                }
                if (value instanceof Boolean) {
                    formatter.value((Boolean)value);
                    continue;
                }
                if (!(value instanceof Integer)) continue;
                formatter.value((Integer)value);
                continue;
            }
            this.parse(entry.type, formatter);
        }
        formatter.endArray();
    }

    protected void parseBoolean(JsonFormatter formatter) throws IOException {
        Boolean literal = this.readLiteral();
        if (literal == null) {
            formatter.valueNull();
        } else {
            formatter.value(literal);
        }
    }

    protected void parseInt16(JsonFormatter formatter) throws IOException {
        int value = this.readInt16();
        formatter.value(value);
    }

    protected void parseUInt16(JsonFormatter formatter) throws IOException {
        int value = this.readUInt16();
        formatter.value(value);
    }

    protected void parseInt32(JsonFormatter formatter) throws IOException {
        int value = this.readInt32();
        formatter.value(value);
    }

    protected void parseUInt32(JsonFormatter formatter) throws IOException {
        long value = this.readUInt32();
        formatter.value(value);
    }

    protected void parseInt64(JsonFormatter formatter) throws IOException {
        long value = this.readInt64();
        formatter.value(value);
    }

    protected void parseUInt64(JsonFormatter formatter) throws IOException {
        BigInteger value = this.readUInt64();
        formatter.value(value);
    }

    protected void parseDouble(JsonFormatter formatter) throws IOException {
        long rawValue = this.readInt64();
        double value = Double.longBitsToDouble(rawValue);
        formatter.value(value);
    }

    protected void parseString(JsonFormatter formatter) throws IOException {
        int length = this.readVariableInt();
        String value = new String(this.reader.read(length), UTF_8);
        formatter.value(value);
    }

    protected void parseOpaque(JsonFormatter formatter) throws IOException {
        int customType = this.reader.read();
        ColumnType type = ColumnType.byCode(customType);
        if (type == null) {
            throw new IOException("Unknown type '" + JsonBinary.asHex(customType) + "' in first byte of a JSON opaque value");
        }
        int length = this.readVariableInt();
        switch (type) {
            case DECIMAL: 
            case NEWDECIMAL: {
                this.parseDecimal(length, formatter);
                break;
            }
            case DATE: {
                this.parseDate(formatter);
                break;
            }
            case TIME: 
            case TIME_V2: {
                this.parseTime(formatter);
                break;
            }
            case DATETIME: 
            case DATETIME_V2: 
            case TIMESTAMP: 
            case TIMESTAMP_V2: {
                this.parseDatetime(formatter);
                break;
            }
            default: {
                this.parseOpaqueValue(type, length, formatter);
            }
        }
    }

    protected void parseDate(JsonFormatter formatter) throws IOException {
        long raw = this.readInt64();
        long value = raw >> 24;
        int yearMonth = (int)(value >> 22) % 131072;
        int year = yearMonth / 13;
        int month = yearMonth % 13;
        int day = (int)(value >> 17) % 32;
        formatter.valueDate(year, month, day);
    }

    protected void parseTime(JsonFormatter formatter) throws IOException {
        long raw = this.readInt64();
        long value = raw >> 24;
        boolean negative = value < 0L;
        int hour = (int)(value >> 12) % 1024;
        int min = (int)(value >> 6) % 64;
        int sec = (int)value % 64;
        if (negative) {
            hour *= -1;
        }
        int microSeconds = (int)(raw % 0x1000000L);
        formatter.valueTime(hour, min, sec, microSeconds);
    }

    protected void parseDatetime(JsonFormatter formatter) throws IOException {
        long raw = this.readInt64();
        long value = raw >> 24;
        int yearMonth = (int)(value >> 22) % 131072;
        int year = yearMonth / 13;
        int month = yearMonth % 13;
        int day = (int)(value >> 17) % 32;
        int hour = (int)(value >> 12) % 32;
        int min = (int)(value >> 6) % 64;
        int sec = (int)(value % 64L);
        int microSeconds = (int)(raw % 0x1000000L);
        formatter.valueDatetime(year, month, day, hour, min, sec, microSeconds);
    }

    protected void parseDecimal(int length, JsonFormatter formatter) throws IOException {
        int precision = this.reader.read();
        int scale = this.reader.read();
        int decimalLength = length - 2;
        BigDecimal dec = AbstractRowsEventDataDeserializer.asBigDecimal(precision, scale, this.reader.read(decimalLength));
        formatter.value(dec);
    }

    protected void parseOpaqueValue(ColumnType type, int length, JsonFormatter formatter) throws IOException {
        formatter.valueOpaque(type, this.reader.read(length));
    }

    protected int readFractionalSecondsInMicroseconds() throws IOException {
        return (int)this.readBigEndianLong(3);
    }

    protected long readBigEndianLong(int numBytes) throws IOException {
        byte[] bytes = this.reader.read(numBytes);
        long result = 0L;
        for (int i = 0; i != numBytes; ++i) {
            int b = bytes[i] & 0xFF;
            result = result << 8 | (long)b;
        }
        return result;
    }

    protected int readUnsignedIndex(int maxValue, boolean isSmall, String desc) throws IOException {
        long result;
        long l = result = isSmall ? (long)this.readUInt16() : this.readUInt32();
        if (result >= (long)maxValue) {
            throw new IOException("The " + desc + " the JSON document is " + result + " and is too big for the binary form of the document (" + maxValue + ")");
        }
        if (result > Integer.MAX_VALUE) {
            throw new IOException("The " + desc + " the JSON document is " + result + " and is too big to be used");
        }
        return (int)result;
    }

    protected int readInt16() throws IOException {
        int b1 = this.reader.read() & 0xFF;
        int b2 = this.reader.read();
        return (short)(b2 << 8 | b1);
    }

    protected int readUInt16() throws IOException {
        int b1 = this.reader.read() & 0xFF;
        int b2 = this.reader.read() & 0xFF;
        return (b2 << 8 | b1) & 0xFFFF;
    }

    protected int readInt24() throws IOException {
        int b1 = this.reader.read() & 0xFF;
        int b2 = this.reader.read() & 0xFF;
        int b3 = this.reader.read();
        return b3 << 16 | b2 << 8 | b1;
    }

    protected int readInt32() throws IOException {
        int b1 = this.reader.read() & 0xFF;
        int b2 = this.reader.read() & 0xFF;
        int b3 = this.reader.read() & 0xFF;
        int b4 = this.reader.read();
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    protected long readUInt32() throws IOException {
        int b1 = this.reader.read() & 0xFF;
        int b2 = this.reader.read() & 0xFF;
        int b3 = this.reader.read() & 0xFF;
        int b4 = this.reader.read() & 0xFF;
        return (long)(b4 << 24 | b3 << 16 | b2 << 8 | b1) & 0xFFFFFFFFFFFFFFFFL;
    }

    protected long readInt64() throws IOException {
        int b1 = this.reader.read() & 0xFF;
        int b2 = this.reader.read() & 0xFF;
        int b3 = this.reader.read() & 0xFF;
        long b4 = this.reader.read() & 0xFF;
        long b5 = this.reader.read() & 0xFF;
        long b6 = this.reader.read() & 0xFF;
        long b7 = this.reader.read() & 0xFF;
        long b8 = this.reader.read();
        return b8 << 56 | b7 << 48 | b6 << 40 | b5 << 32 | b4 << 24 | (long)(b3 << 16) | (long)(b2 << 8) | (long)b1;
    }

    protected BigInteger readUInt64() throws IOException {
        byte[] bigEndian = new byte[8];
        for (int i = 8; i != 0; --i) {
            bigEndian[i - 1] = (byte)(this.reader.read() & 0xFF);
        }
        return new BigInteger(1, bigEndian);
    }

    protected int readVariableInt() throws IOException {
        int length = 0;
        for (int i = 0; i < 5; ++i) {
            byte b = (byte)this.reader.read();
            length |= (b & 0x7F) << 7 * i;
            if ((b & 0x80) != 0) continue;
            return length;
        }
        throw new IOException("Unexpected byte sequence (" + length + ")");
    }

    protected Boolean readLiteral() throws IOException {
        byte b = (byte)this.reader.read();
        if (b == 0) {
            return null;
        }
        if (b == 1) {
            return Boolean.TRUE;
        }
        if (b == 2) {
            return Boolean.FALSE;
        }
        throw new IOException("Unexpected value '" + JsonBinary.asHex(b) + "' for literal");
    }

    protected ValueType readValueType() throws IOException {
        byte b = (byte)this.reader.read();
        ValueType result = ValueType.byCode(b);
        if (result == null) {
            throw new IOException("Unknown value type code '" + String.format("%02X", b) + "'");
        }
        return result;
    }

    protected static String asHex(byte b) {
        return String.format("%02X ", b);
    }

    protected static String asHex(int value) {
        return Integer.toHexString(value);
    }

    protected static final class ValueEntry {
        protected final ValueType type;
        protected final int index;
        protected Object value;
        protected boolean resolved;

        public ValueEntry(ValueType type) {
            this.type = type;
            this.index = 0;
        }

        public ValueEntry(ValueType type, int index) {
            this.type = type;
            this.index = index;
        }

        public ValueEntry setValue(Object value) {
            this.value = value;
            this.resolved = true;
            return this;
        }
    }
}

