/*
 * Decompiled with CFR 0.152.
 */
package com.shivtechs.maplocationpicker;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResponse;
import com.google.android.gms.location.LocationSettingsStates;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.MapFragment;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.libraries.places.api.Places;
import com.google.android.libraries.places.api.model.LocationBias;
import com.google.android.libraries.places.api.model.Place;
import com.google.android.libraries.places.api.model.RectangularBounds;
import com.google.android.libraries.places.widget.Autocomplete;
import com.google.android.libraries.places.widget.model.AutocompleteActivityMode;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.shivtechs.maplocationpicker.MapUtility;
import com.shivtechs.maplocationpicker.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocationPickerActivity
extends AppCompatActivity
implements OnMapReadyCallback {
    private static final int REQUEST_CHECK_SETTINGS = 2;
    private final String TAG = LocationPickerActivity.class.getSimpleName();
    private String userAddress = "";
    private double mLatitude;
    private double mLongitude;
    private String place_id = "";
    private String place_url = " ";
    private GoogleMap mMap;
    private static final int REQUEST_ID_MULTIPLE_PERMISSIONS = 2;
    private boolean mLocationPermissionGranted;
    private TextView imgSearch;
    int PLACE_AUTOCOMPLETE_REQUEST_CODE = 1;
    private FusedLocationProviderClient fusedLocationProviderClient;
    private List<AsyncTask> filterTaskList = new ArrayList<AsyncTask>();
    String regex = "^(-?\\d+(\\.\\d+)?),\\s*(-?\\d+(\\.\\d+)?)$";
    Pattern latLongPattern = Pattern.compile(this.regex);
    private int doAfterPermissionProvided;
    private int doAfterLocationSwitchedOn = 1;
    private double currentLatitude;
    private double currentLongitude;
    private LocationRequest locationRequest;
    private LocationCallback locationCallback;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        Bundle extras;
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 19) {
            this.getWindow().setFlags(0x4000000, 0x4000000);
        }
        this.setContentView(R.layout.activity_location_picker);
        ImageView imgCurrentloc = (ImageView)this.findViewById(R.id.imgCurrentloc);
        FloatingActionButton txtSelectLocation = (FloatingActionButton)this.findViewById(R.id.fab_select_location);
        this.imgSearch = (TextView)this.findViewById(R.id.imgSearch);
        ImageView directionTool = (ImageView)this.findViewById(R.id.direction_tool);
        ImageView googleMapTool = (ImageView)this.findViewById(R.id.google_maps_tool);
        this.fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Activity)this);
        this.getLocationRequest();
        this.locationCallback = new LocationCallback(){

            public void onLocationAvailability(LocationAvailability locationAvailability) {
                Log.d((String)LocationPickerActivity.this.TAG, (String)("onLocationAvailability: isLocationAvailable =  " + locationAvailability.isLocationAvailable()));
            }

            public void onLocationResult(LocationResult locationResult) {
                Log.d((String)LocationPickerActivity.this.TAG, (String)("onLocationResult: " + locationResult));
                if (locationResult == null) {
                    return;
                }
                switch (LocationPickerActivity.this.doAfterLocationSwitchedOn) {
                    case 1: {
                        LocationPickerActivity.this.startParsingAddressToShow();
                        break;
                    }
                    case 2: {
                        LocationPickerActivity.this.showCurrentLocationOnMap(false);
                        break;
                    }
                    case 3: {
                        LocationPickerActivity.this.showCurrentLocationOnMap(true);
                    }
                }
                LocationPickerActivity.this.fusedLocationProviderClient.removeLocationUpdates(LocationPickerActivity.this.locationCallback);
            }
        };
        MapFragment mapFragment = (MapFragment)this.getFragmentManager().findFragmentById(R.id.map);
        mapFragment.getMapAsync((OnMapReadyCallback)this);
        Intent i = this.getIntent();
        if (i != null && (extras = i.getExtras()) != null) {
            this.userAddress = extras.getString("address");
            this.mLatitude = this.getIntent().getDoubleExtra("latitude", 0.0);
            this.mLongitude = this.getIntent().getDoubleExtra("longitude", 0.0);
        }
        if (savedInstanceState != null) {
            this.mLatitude = savedInstanceState.getDouble("latitude");
            this.mLongitude = savedInstanceState.getDouble("longitude");
            this.userAddress = savedInstanceState.getString("userAddress");
            this.currentLatitude = savedInstanceState.getDouble("currentLatitude");
            this.currentLongitude = savedInstanceState.getDouble("currentLongitude");
        }
        if (!MapUtility.isNetworkAvailable((Context)this)) {
            MapUtility.showToast((Context)this, "Please Connect to Internet");
        }
        this.imgSearch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!Places.isInitialized()) {
                    Places.initialize((Context)LocationPickerActivity.this.getApplicationContext(), (String)MapUtility.apiKey);
                }
                List<Place.Field> fields = Arrays.asList(Place.Field.ID, Place.Field.NAME, Place.Field.ADDRESS, Place.Field.LAT_LNG);
                Intent intent = new Autocomplete.IntentBuilder(AutocompleteActivityMode.FULLSCREEN, fields).setLocationBias((LocationBias)RectangularBounds.newInstance((LatLng)new LatLng(23.63936, 68.14712), (LatLng)new LatLng(28.20453, 97.34466))).build((Context)LocationPickerActivity.this);
                LocationPickerActivity.this.startActivityForResult(intent, LocationPickerActivity.this.PLACE_AUTOCOMPLETE_REQUEST_CODE);
            }
        });
        txtSelectLocation.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent();
                intent.putExtra("address", LocationPickerActivity.this.imgSearch.getText().toString().trim());
                intent.putExtra("lat", LocationPickerActivity.this.mLatitude);
                intent.putExtra("long", LocationPickerActivity.this.mLongitude);
                intent.putExtra("id", LocationPickerActivity.this.place_id);
                intent.putExtra("url", LocationPickerActivity.this.place_url);
                LocationPickerActivity.this.setResult(-1, intent);
                LocationPickerActivity.this.finish();
            }
        });
        imgCurrentloc.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LocationPickerActivity.this.showCurrentLocationOnMap(false);
                LocationPickerActivity.this.doAfterPermissionProvided = 2;
                LocationPickerActivity.this.doAfterLocationSwitchedOn = 2;
            }
        });
        directionTool.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LocationPickerActivity.this.showCurrentLocationOnMap(true);
                LocationPickerActivity.this.doAfterPermissionProvided = 3;
                LocationPickerActivity.this.doAfterLocationSwitchedOn = 3;
            }
        });
        googleMapTool.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("http://maps.google.com/maps?q=loc:" + LocationPickerActivity.this.mLatitude + ", " + LocationPickerActivity.this.mLongitude + "")));
                LocationPickerActivity.this.startActivity(intent);
            }
        });
    }

    protected void onPause() {
        super.onPause();
        this.fusedLocationProviderClient.removeLocationUpdates(this.locationCallback);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == this.PLACE_AUTOCOMPLETE_REQUEST_CODE) {
            if (resultCode == -1) {
                Place place = Autocomplete.getPlaceFromIntent((Intent)data);
                this.userAddress = place.getAddress();
                this.imgSearch.setText((CharSequence)("" + this.userAddress));
                this.mLatitude = place.getLatLng().latitude;
                this.mLongitude = place.getLatLng().longitude;
                this.place_id = place.getId();
                this.place_url = String.valueOf(place.getWebsiteUri());
                this.addMarker();
            } else if (resultCode == 2) {
                Status status = Autocomplete.getStatusFromIntent((Intent)data);
                Log.i((String)this.TAG, (String)status.getStatusMessage());
            } else if (resultCode == 0) {
                // empty if block
            }
        } else if (requestCode == 2) {
            if (resultCode != -1) {
                Toast.makeText((Context)this, (CharSequence)"Location Not Available..", (int)0).show();
            } else {
                Toast.makeText((Context)this, (CharSequence)"Fetching Location...", (int)1).show();
                this.startLocationUpdates();
            }
        }
    }

    private boolean checkAndRequestPermissions() {
        int locationPermission = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_FINE_LOCATION");
        int coarsePermision = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_COARSE_LOCATION");
        ArrayList<String> listPermissionsNeeded = new ArrayList<String>();
        if (locationPermission != 0) {
            listPermissionsNeeded.add("android.permission.ACCESS_FINE_LOCATION");
        }
        if (coarsePermision != 0) {
            listPermissionsNeeded.add("android.permission.ACCESS_COARSE_LOCATION");
        }
        if (!listPermissionsNeeded.isEmpty()) {
            ActivityCompat.requestPermissions((Activity)this, (String[])listPermissionsNeeded.toArray(new String[0]), (int)2);
            return false;
        }
        return true;
    }

    private void showCurrentLocationOnMap(final boolean isDirectionClicked) {
        if (this.checkAndRequestPermissions()) {
            Task lastLocation = this.fusedLocationProviderClient.getLastLocation();
            lastLocation.addOnSuccessListener((Activity)this, (OnSuccessListener)new OnSuccessListener<Location>(){

                public void onSuccess(Location location) {
                    if (location != null) {
                        LocationPickerActivity.this.mMap.clear();
                        if (isDirectionClicked) {
                            LocationPickerActivity.this.currentLatitude = location.getLatitude();
                            LocationPickerActivity.this.currentLongitude = location.getLongitude();
                            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("http://maps.google.com/maps?saddr=" + LocationPickerActivity.this.currentLatitude + ", " + LocationPickerActivity.this.currentLongitude + "&daddr=" + LocationPickerActivity.this.mLatitude + ", " + LocationPickerActivity.this.mLongitude + "")));
                            LocationPickerActivity.this.startActivity(intent);
                        } else {
                            LocationPickerActivity.this.mLatitude = location.getLatitude();
                            LocationPickerActivity.this.mLongitude = location.getLongitude();
                            LocationPickerActivity.this.getAddressByGeoCodingLatLng();
                        }
                    } else {
                        LocationPickerActivity.this.getSettingsLocation();
                        Toast.makeText((Context)LocationPickerActivity.this, (CharSequence)"Location not Available", (int)0).show();
                    }
                }
            });
            lastLocation.addOnFailureListener(new OnFailureListener(){

                public void onFailure(@NonNull Exception e) {
                    Toast.makeText((Context)LocationPickerActivity.this, (CharSequence)"Location Not Availabe", (int)0).show();
                }
            });
        }
    }

    private void addMarker() {
        LatLng coordinate = new LatLng(this.mLatitude, this.mLongitude);
        if (this.mMap != null) {
            try {
                this.mMap.clear();
                this.imgSearch.setText((CharSequence)("" + this.userAddress));
                MarkerOptions markerOptions = new MarkerOptions().position(coordinate).title(this.userAddress).icon(BitmapDescriptorFactory.fromResource((int)R.drawable.ic_place_red_800_24dp));
                CameraUpdate cameraUpdate = CameraUpdateFactory.newLatLngZoom((LatLng)coordinate, (float)14.0f);
                this.mMap.animateCamera(cameraUpdate);
                this.mMap.setMapType(1);
                Marker marker = this.mMap.addMarker(markerOptions);
                marker.showInfoWindow();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void onMapReady(GoogleMap googleMap) {
        this.mMap = googleMap;
        this.mMap.clear();
        this.mMap.setMapType(1);
        this.mMap.getUiSettings().setMapToolbarEnabled(false);
        if (this.mMap.isIndoorEnabled()) {
            this.mMap.setIndoorEnabled(false);
        }
        this.mMap.setInfoWindowAdapter(new GoogleMap.InfoWindowAdapter(){

            public View getInfoWindow(Marker arg0) {
                return null;
            }

            public View getInfoContents(Marker arg0) {
                View v = LocationPickerActivity.this.getLayoutInflater().inflate(R.layout.info_window_layout, null);
                LatLng latLng = arg0.getPosition();
                LocationPickerActivity.this.mLatitude = latLng.latitude;
                LocationPickerActivity.this.mLongitude = latLng.longitude;
                TextView tvLat = (TextView)v.findViewById(R.id.address);
                tvLat.setText((CharSequence)LocationPickerActivity.this.userAddress);
                return v;
            }
        });
        this.mMap.getUiSettings().setZoomControlsEnabled(true);
        this.mMap.setOnMapClickListener(new GoogleMap.OnMapClickListener(){

            public void onMapClick(LatLng latLng) {
                LocationPickerActivity.this.mMap.clear();
                LocationPickerActivity.this.mLatitude = latLng.latitude;
                LocationPickerActivity.this.mLongitude = latLng.longitude;
                Log.e((String)"latlng", (String)(latLng + ""));
                LocationPickerActivity.this.addMarker();
                if (!MapUtility.isNetworkAvailable((Context)LocationPickerActivity.this)) {
                    MapUtility.showToast((Context)LocationPickerActivity.this, "Please Connect to Internet");
                }
                LocationPickerActivity.this.getAddressByGeoCodingLatLng();
            }
        });
        if (this.checkAndRequestPermissions()) {
            this.startParsingAddressToShow();
        } else {
            this.doAfterPermissionProvided = 1;
        }
    }

    private void getSettingsLocation() {
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder().addLocationRequest(this.locationRequest);
        Task result = LocationServices.getSettingsClient((Activity)this).checkLocationSettings(builder.build());
        result.addOnCompleteListener((OnCompleteListener)new OnCompleteListener<LocationSettingsResponse>(){

            public void onComplete(@NonNull Task<LocationSettingsResponse> task) {
                try {
                    LocationSettingsResponse response = (LocationSettingsResponse)task.getResult(ApiException.class);
                    if (response != null) {
                        LocationSettingsStates locationSettingsStates = response.getLocationSettingsStates();
                        Log.d((String)LocationPickerActivity.this.TAG, (String)("getSettingsLocation: " + locationSettingsStates));
                        LocationPickerActivity.this.startLocationUpdates();
                    }
                }
                catch (ApiException exception) {
                    Log.d((String)LocationPickerActivity.this.TAG, (String)("getSettingsLocation: " + (Object)((Object)exception)));
                    switch (exception.getStatusCode()) {
                        case 6: {
                            try {
                                ResolvableApiException resolvable = (ResolvableApiException)exception;
                                resolvable.startResolutionForResult((Activity)LocationPickerActivity.this, 2);
                            }
                            catch (IntentSender.SendIntentException sendIntentException) {
                            }
                            catch (ClassCastException classCastException) {}
                            break;
                        }
                    }
                }
            }
        });
    }

    private void startParsingAddressToShow() {
        if (this.userAddress == null || this.userAddress.isEmpty()) {
            this.showCurrentLocationOnMap(false);
        } else if (this.latLongPattern.matcher(this.userAddress).matches()) {
            Pattern p = Pattern.compile("(-?\\d+(\\.\\d+)?)");
            Matcher m = p.matcher(this.userAddress);
            int i = 0;
            while (m.find()) {
                if (i == 0) {
                    this.mLatitude = Double.parseDouble(m.group());
                }
                if (i == 1) {
                    this.mLongitude = Double.parseDouble(m.group());
                }
                ++i;
            }
            this.getAddressByGeoCodingLatLng();
            this.addMarker();
        } else if (this.mLatitude == 0.0 && this.mLongitude == 0.0) {
            this.getLatLngByRevGeoCodeFromAdd();
        } else {
            this.addMarker();
        }
    }

    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putDouble("latitude", this.mLatitude);
        outState.putDouble("longitude", this.mLongitude);
        outState.putString("userAddress", this.userAddress);
        outState.putDouble("currentLatitude", this.currentLatitude);
        outState.putDouble("currentLongitude", this.currentLongitude);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        this.finish();
    }

    private void getAddressByGeoCodingLatLng() {
        if (this.mLatitude != 0.0 && this.mLongitude != 0.0) {
            if (MapUtility.popupWindow != null && MapUtility.popupWindow.isShowing()) {
                MapUtility.hideProgress();
            }
            Log.d((String)this.TAG, (String)"getAddressByGeoCodingLatLng: START");
            for (AsyncTask prevTask : this.filterTaskList) {
                prevTask.cancel(true);
            }
            this.filterTaskList.clear();
            GetAddressFromLatLng asyncTask = new GetAddressFromLatLng();
            this.filterTaskList.add(asyncTask);
            asyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Double[]{this.mLatitude, this.mLongitude});
        }
    }

    private void getLatLngByRevGeoCodeFromAdd() {
        if (this.mLatitude == 0.0 && this.mLongitude == 0.0) {
            if (MapUtility.popupWindow != null && MapUtility.popupWindow.isShowing()) {
                MapUtility.hideProgress();
            }
            Log.d((String)this.TAG, (String)"getLatLngByRevGeoCodeFromAdd: START");
            for (AsyncTask prevTask : this.filterTaskList) {
                prevTask.cancel(true);
            }
            this.filterTaskList.clear();
            GetLatLngFromAddress asyncTask = new GetLatLngFromAddress();
            this.filterTaskList.add(asyncTask);
            asyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{this.userAddress});
        }
    }

    double roundAvoid(double value) {
        double scale = Math.pow(10.0, 6.0);
        return (double)Math.round(value * scale) / scale;
    }

    protected void onDestroy() {
        super.onDestroy();
        for (AsyncTask task : this.filterTaskList) {
            task.cancel(true);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        this.mLocationPermissionGranted = false;
        switch (requestCode) {
            case 2: {
                if (grantResults.length <= 0 || grantResults[0] != 0) break;
                this.mLocationPermissionGranted = true;
            }
        }
    }

    protected void onResume() {
        super.onResume();
        if (!this.isFinishing() && this.mLocationPermissionGranted) {
            this.mLocationPermissionGranted = false;
            switch (this.doAfterPermissionProvided) {
                case 1: {
                    this.startParsingAddressToShow();
                    break;
                }
                case 2: {
                    this.showCurrentLocationOnMap(false);
                    break;
                }
                case 3: {
                    this.showCurrentLocationOnMap(true);
                }
            }
        }
    }

    private void startLocationUpdates() {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            Toast.makeText((Context)this, (CharSequence)"Location not Available", (int)0).show();
            return;
        }
        this.fusedLocationProviderClient.requestLocationUpdates(this.locationRequest, this.locationCallback, null).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void onSuccess(Void aVoid) {
                Log.d((String)LocationPickerActivity.this.TAG, (String)"startLocationUpdates: onSuccess: ");
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                if (e instanceof ApiException) {
                    Log.d((String)LocationPickerActivity.this.TAG, (String)("startLocationUpdates: " + ((ApiException)e).getMessage()));
                } else {
                    Log.d((String)LocationPickerActivity.this.TAG, (String)("startLocationUpdates: " + e.getMessage()));
                }
            }
        });
    }

    private void getLocationRequest() {
        this.locationRequest = new LocationRequest();
        this.locationRequest.setInterval(10000L);
        this.locationRequest.setFastestInterval(3000L);
        this.locationRequest.setPriority(100);
    }

    private class GetLatLngFromAddress
    extends AsyncTask<String, Void, LatLng> {
        private GetLatLngFromAddress() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
            MapUtility.showProgress((Context)LocationPickerActivity.this);
        }

        protected LatLng doInBackground(String ... userAddress) {
            LatLng latLng = new LatLng(0.0, 0.0);
            try {
                Geocoder geocoder = new Geocoder((Context)LocationPickerActivity.this, Locale.getDefault());
                List addresses = geocoder.getFromLocationName(userAddress[0], 1);
                if (addresses != null && addresses.size() > 0) {
                    latLng = new LatLng(((Address)addresses.get(0)).getLatitude(), ((Address)addresses.get(0)).getLongitude());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return latLng;
        }

        protected void onPostExecute(LatLng latLng) {
            super.onPostExecute((Object)latLng);
            LocationPickerActivity.this.mLatitude = latLng.latitude;
            LocationPickerActivity.this.mLongitude = latLng.longitude;
            MapUtility.hideProgress();
            LocationPickerActivity.this.addMarker();
        }
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private class GetAddressFromLatLng
    extends AsyncTask<Double, Void, String> {
        Double latitude;
        Double longitude;

        private GetAddressFromLatLng() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
            MapUtility.showProgress((Context)LocationPickerActivity.this);
        }

        protected String doInBackground(Double ... doubles) {
            try {
                this.latitude = doubles[0];
                this.longitude = doubles[1];
                Geocoder geocoder = new Geocoder((Context)LocationPickerActivity.this, Locale.getDefault());
                StringBuilder sb = new StringBuilder();
                List addresses = geocoder.getFromLocation(this.latitude.doubleValue(), this.longitude.doubleValue(), 1);
                if (addresses != null && addresses.size() > 0) {
                    String postalCode;
                    String country;
                    String state;
                    String city;
                    String address = ((Address)addresses.get(0)).getAddressLine(0);
                    if (address != null) {
                        sb.append(address).append(" ");
                    }
                    if ((city = ((Address)addresses.get(0)).getLocality()) != null) {
                        sb.append(city).append(" ");
                    }
                    if ((state = ((Address)addresses.get(0)).getAdminArea()) != null) {
                        sb.append(state).append(" ");
                    }
                    if ((country = ((Address)addresses.get(0)).getCountryName()) != null) {
                        sb.append(country).append(" ");
                    }
                    if ((postalCode = ((Address)addresses.get(0)).getPostalCode()) != null) {
                        sb.append(postalCode).append(" ");
                    }
                    return sb.toString();
                }
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return LocationPickerActivity.this.roundAvoid(this.latitude) + "," + LocationPickerActivity.this.roundAvoid(this.longitude);
            }
        }

        protected void onPostExecute(String userAddress) {
            super.onPostExecute((Object)userAddress);
            LocationPickerActivity.this.userAddress = userAddress;
            MapUtility.hideProgress();
            LocationPickerActivity.this.addMarker();
        }
    }
}

