/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.modeler.model;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kr.co.shineware.ds.aho_corasick.AhoCorasickDictionary;
import kr.co.shineware.nlp.komoran.interfaces.FileAccessible;
import kr.co.shineware.nlp.komoran.interfaces.UnitParser;
import kr.co.shineware.nlp.komoran.model.ScoredTag;
import kr.co.shineware.nlp.komoran.parser.KoreanUnitParser;

public class Observation
implements FileAccessible {
    private AhoCorasickDictionary<List<ScoredTag>> observation;
    private UnitParser parser;

    public Observation() {
        this.init();
    }

    private void init() {
        this.observation = new AhoCorasickDictionary();
        this.parser = new KoreanUnitParser();
    }

    public void put(String word, String tag, int tagId, double observationScore) {
        String koreanUnits = this.parser.parse(word);
        List<ScoredTag> scoredTagList = this.observation.getValue(koreanUnits);
        if (scoredTagList == null) {
            scoredTagList = new ArrayList<ScoredTag>();
            scoredTagList.add(new ScoredTag(tag, tagId, observationScore));
        } else {
            int i = 0;
            for (i = 0; i < scoredTagList.size() && scoredTagList.get(i).getTagId() != tagId; ++i) {
            }
            if (scoredTagList.size() == i) {
                scoredTagList.add(new ScoredTag(tag, tagId, observationScore));
            }
        }
        this.observation.put(koreanUnits, scoredTagList);
    }

    public AhoCorasickDictionary<List<ScoredTag>> getTrieDictionary() {
        return this.observation;
    }

    @Override
    public void save(String filename) {
        this.observation.save(filename);
    }

    @Override
    public void load(String filename) {
        this.observation.load(filename);
    }

    public void load(File file) {
        this.observation.load(file);
    }

    public void load(InputStream is) {
        this.observation.load(is);
    }
}

