/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.corpus.parser;

import java.util.ArrayList;
import java.util.List;
import kr.co.shineware.nlp.komoran.corpus.parser.CorpusParser;
import kr.co.shineware.nlp.komoran.corpus.parser.model.ProblemAnswerPair;
import kr.co.shineware.nlp.komoran.exception.FileFormatException;
import kr.co.shineware.util.common.model.Pair;
import kr.co.shineware.util.common.string.StringUtil;

public class IrregularParser {
    private int answerBeginIndex = -1;
    private int problemBeginIndex = -1;
    private int answerEndIndex = -1;
    private int problemEndIndex = -1;

    public List<Pair<String, String>> parse(String problem, List<Pair<String, String>> answerList) {
        this.setBeginIdx(problem, answerList);
        this.setEndIdx(problem, answerList);
        return this.getIrregularRules(problem, answerList);
    }

    private Pair<String, String> expandIrregularRule(String problem, List<Pair<String, String>> answerList, int problemBeginIndex, int problemEndIndex, int answerBeginIndex, int answerEndIndex) {
        StringBuffer centerConvertRule = new StringBuffer();
        for (int i = answerBeginIndex; i < answerEndIndex + 1; ++i) {
            centerConvertRule.append(answerList.get(i).getFirst());
            centerConvertRule.append("/");
            centerConvertRule.append(answerList.get(i).getSecond());
            centerConvertRule.append(" ");
        }
        String prevConvertRule = "";
        String nextConvertRule = "";
        String convertRule = "";
        int tmpProblemBeginIndex = problemBeginIndex;
        int tmpProblemEndIndex = problemEndIndex;
        if (answerBeginIndex != 0) {
            prevConvertRule = prevConvertRule + answerList.get(answerBeginIndex - 1).getFirst();
            prevConvertRule = prevConvertRule + "/";
            prevConvertRule = prevConvertRule + answerList.get(answerBeginIndex - 1).getSecond();
            prevConvertRule = prevConvertRule + " ";
            tmpProblemBeginIndex = problemBeginIndex - answerList.get(answerBeginIndex - 1).getFirst().length();
        }
        if (answerEndIndex + 1 != answerList.size()) {
            nextConvertRule = nextConvertRule + answerList.get(answerEndIndex + 1).getFirst();
            nextConvertRule = nextConvertRule + "/";
            nextConvertRule = nextConvertRule + answerList.get(answerEndIndex + 1).getSecond();
            nextConvertRule = nextConvertRule + " ";
            tmpProblemEndIndex = problemEndIndex + answerList.get(answerEndIndex + 1).getFirst().length();
        }
        convertRule = prevConvertRule + centerConvertRule.toString() + nextConvertRule.trim();
        String irrProblem = problem.substring(tmpProblemBeginIndex, tmpProblemEndIndex);
        return new Pair<String, String>(irrProblem, convertRule.trim());
    }

    private Pair<String, String> expandIrregularRule(String problem, List<Pair<String, String>> answerList) {
        return this.expandIrregularRule(problem, answerList, this.problemBeginIndex, this.problemEndIndex, this.answerBeginIndex, this.answerEndIndex);
    }

    private List<Pair<String, String>> getIrregularRules(String problem, List<Pair<String, String>> answerList) {
        ArrayList<Pair<String, String>> irrRuleList = new ArrayList<Pair<String, String>>();
        try {
            if (!this.isCleanRule(problem, answerList)) {
                return irrRuleList;
            }
            if (this.problemBeginIndex > this.problemEndIndex) {
                String irrProblem = problem.substring(0, this.problemEndIndex);
                if (irrProblem.trim().length() == 0 || this.answerEndIndex == 0) {
                    irrRuleList.add(this.expandIrregularRule(problem, answerList, 0, this.problemEndIndex, 0, this.answerEndIndex));
                } else {
                    this.appendIrrRule(irrRuleList, irrProblem, answerList, 0, this.answerEndIndex);
                }
                irrProblem = problem.substring(this.problemBeginIndex);
                if (irrProblem.trim().length() == 0 || this.answerBeginIndex == answerList.size() - 1) {
                    irrRuleList.add(this.expandIrregularRule(problem, answerList, this.problemBeginIndex, problem.length(), this.answerBeginIndex, answerList.size() - 1));
                } else {
                    this.appendIrrRule(irrRuleList, irrProblem, answerList, this.answerBeginIndex, answerList.size() - 1);
                }
                irrProblem = null;
            } else if (this.problemBeginIndex == this.problemEndIndex) {
                irrRuleList.add(this.expandIrregularRule(problem, answerList));
            } else {
                String irrProblem = problem.substring(this.problemBeginIndex, this.problemEndIndex);
                if (this.answerBeginIndex == this.answerEndIndex) {
                    int extractLength = this.problemEndIndex - this.problemBeginIndex;
                    if (extractLength < 4) {
                        irrRuleList.add(this.expandIrregularRule(problem, answerList));
                    } else {
                        this.appendIrrRule(irrRuleList, irrProblem, answerList, this.answerBeginIndex, this.answerEndIndex);
                    }
                } else {
                    this.appendIrrRule(irrRuleList, irrProblem, answerList, this.answerBeginIndex, this.answerEndIndex);
                }
                irrProblem = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return irrRuleList;
    }

    private boolean isCleanRule(String problem, List<Pair<String, String>> answerList) {
        int i;
        if (answerList.get(this.answerEndIndex).getSecond().equals("VCP")) {
            return false;
        }
        for (i = this.answerBeginIndex; i <= this.answerEndIndex; ++i) {
            if (!answerList.get(i).getSecond().contains("NNP") && !answerList.get(i).getSecond().contains("NNG") && !answerList.get(i).getSecond().contains("JK")) continue;
            return false;
        }
        for (i = 0; i < problem.length(); ++i) {
            if (StringUtil.isKorean(problem.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void appendIrrRule(List<Pair<String, String>> irrRuleList, String problem, List<Pair<String, String>> answerList, int answerBeginIndex, int answerEndIndex) {
        StringBuffer convertRule = new StringBuffer();
        for (int i = answerBeginIndex; i < answerEndIndex + 1; ++i) {
            convertRule.append(answerList.get(i).getFirst());
            convertRule.append("/");
            convertRule.append(answerList.get(i).getSecond());
            convertRule.append(" ");
        }
        irrRuleList.add(new Pair<String, String>(problem, convertRule.toString().trim()));
        convertRule = null;
    }

    public List<Pair<String, String>> parse(String line) {
        CorpusParser parser = new CorpusParser();
        try {
            ProblemAnswerPair pair = parser.parse(line);
            if (this.isIrregular(pair)) {
                return this.parse(pair.getProblem(), pair.getAnswerList());
            }
        }
        catch (FileFormatException e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<Pair<String, String>> parse(ProblemAnswerPair pair) {
        if (this.isIrregular(pair)) {
            return this.parse(pair.getProblem(), pair.getAnswerList());
        }
        return null;
    }

    private boolean isIrregular(ProblemAnswerPair pair) {
        return this.isIrregular(pair.getProblem(), pair.getAnswerList());
    }

    private boolean isIrregular(String problem, List<Pair<String, String>> answerList) {
        StringBuffer answer = new StringBuffer();
        for (Pair<String, String> pair : answerList) {
            answer.append(pair.getFirst());
        }
        return !StringUtil.getKorean(problem).equals(StringUtil.getKorean(answer.toString()));
    }

    private void setEndIdx(String problem, List<Pair<String, String>> answerList) {
        int ptr = problem.length();
        for (int i = answerList.size() - 1; i >= 0; --i) {
            String answerMorph = answerList.get(i).getFirst();
            if (ptr - answerMorph.length() < 0) {
                this.answerEndIndex = i;
                this.problemEndIndex = ptr;
                break;
            }
            String problemWord = problem.substring(ptr - answerMorph.length(), ptr);
            if (!answerMorph.equals(problemWord)) {
                this.answerEndIndex = i;
                this.problemEndIndex = ptr;
                break;
            }
            ptr -= answerMorph.length();
            answerMorph = null;
            problemWord = null;
        }
    }

    private void setBeginIdx(String problem, List<Pair<String, String>> answerList) {
        int ptr = 0;
        for (int i = 0; i < answerList.size(); ++i) {
            String answerMorph = answerList.get(i).getFirst();
            if (ptr + answerMorph.length() > problem.length()) {
                this.answerBeginIndex = i;
                this.problemBeginIndex = ptr;
                break;
            }
            String problemWord = problem.substring(ptr, ptr + answerMorph.length());
            if (!answerMorph.equals(problemWord)) {
                this.answerBeginIndex = i;
                this.problemBeginIndex = ptr;
                break;
            }
            ptr += answerMorph.length();
            answerMorph = null;
            problemWord = null;
        }
    }
}

