/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.ds.aho_corasick.model;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class AhoCorasickNode<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private AhoCorasickNode<V>[] children;
    private AhoCorasickNode<V> parent;
    private AhoCorasickNode<V> failNode;
    private char key;
    private V value;
    private int depth;

    public String getId() {
        return "[" + this.depth + "," + this.key + "]";
    }

    public AhoCorasickNode<V>[] getChildren() {
        return this.children;
    }

    public void setChildren(AhoCorasickNode<V>[] children) {
        this.children = children;
    }

    public AhoCorasickNode<V> getParent() {
        return this.parent;
    }

    public void setParent(AhoCorasickNode<V> parent) {
        this.parent = parent;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public AhoCorasickNode<V> getFailNode() {
        return this.failNode;
    }

    public void setFailNode(AhoCorasickNode<V> failNode) {
        this.failNode = failNode;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public char getKey() {
        return this.key;
    }

    public void setKey(char key) {
        this.key = key;
    }

    public String toString() {
        return ", key=" + this.key + ", value=" + this.value + ", depth=" + this.depth + " [children=" + (this.children == null ? 0 : this.children.length) + ", parent=" + this.parent + ", failNode=" + this.failNode + "]";
    }

    public void save(String filename) {
        try {
            ObjectOutputStream dos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(filename))));
            this.write(dos, true);
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save(File file) {
        try {
            ObjectOutputStream dos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file))));
            this.write(dos, true);
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void write(ObjectOutputStream dos, boolean isRoot) throws Exception {
        if (!isRoot) {
            dos.writeChar(this.getKey());
            dos.writeObject(this.getValue());
        }
        if (this.children == null) {
            dos.writeInt(0);
        } else {
            dos.writeInt(this.children.length);
            for (int i = 0; i < this.children.length; ++i) {
                super.write(dos, false);
            }
        }
    }

    public void load(String filename) {
        try {
            ObjectInputStream dis = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(filename))));
            this.load(dis, true);
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load(File file) {
        try {
            ObjectInputStream dis = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
            this.load(dis, true);
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load(InputStream inputStream) {
        try {
            ObjectInputStream dis = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(inputStream)));
            this.load(dis, true);
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void load(ObjectInputStream dis, boolean isRoot) throws Exception {
        int length;
        if (!isRoot) {
            this.setKey(dis.readChar());
            this.setValue(dis.readObject());
        }
        if ((length = dis.readInt()) != 0) {
            this.children = new AhoCorasickNode[length];
        }
        for (int i = 0; i < length; ++i) {
            this.children[i] = new AhoCorasickNode<V>();
            super.load(dis, false);
            this.children[i].setParent(this);
        }
    }
}

