/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kr.co.shineware.nlp.komoran.interfaces.UnitParser;
import kr.co.shineware.util.common.model.Pair;

public class KoreanUnitParser
implements UnitParser {
    public static char[] ChoSung = new char[]{'\u3131', '\u3132', '\u3134', '\u3137', '\u3138', '\u3139', '\u3141', '\u3142', '\u3143', '\u3145', '\u3146', '\u3147', '\u3148', '\u3149', '\u314a', '\u314b', '\u314c', '\u314d', '\u314e'};
    public static char[] JungSung = new char[]{'\u314f', '\u3150', '\u3151', '\u3152', '\u3153', '\u3154', '\u3155', '\u3156', '\u3157', '\u3158', '\u3159', '\u315a', '\u315b', '\u315c', '\u315d', '\u315e', '\u315f', '\u3160', '\u3161', '\u3162', '\u3163'};
    public static char[] JongSung = new char[]{'\u0000', '\u3131', '\u3132', '\u3133', '\u3134', '\u3135', '\u3136', '\u3137', '\u3139', '\u313a', '\u313b', '\u313c', '\u313d', '\u313e', '\u313f', '\u3140', '\u3141', '\u3142', '\u3144', '\u3145', '\u3146', '\u3147', '\u3148', '\u314a', '\u314b', '\u314c', '\u314d', '\u314e'};

    public List<Pair<Character, UnitType>> parseWithType(String str) {
        ArrayList<Pair<Character, UnitType>> result = new ArrayList<Pair<Character, UnitType>>();
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            Character.UnicodeBlock block = Character.UnicodeBlock.of(ch);
            if (block == Character.UnicodeBlock.HANGUL_SYLLABLES) {
                int tmp = ch - 44032;
                int cho = tmp / 588;
                int jung = (tmp %= 588) / 28;
                int jong = tmp % 28;
                result.add(new Pair<Character, UnitType>(Character.valueOf(ChoSung[cho]), UnitType.CHOSUNG));
                result.add(new Pair<Character, UnitType>(Character.valueOf(JungSung[jung]), UnitType.JUNGSUNG));
                if (jong == 0) continue;
                result.add(new Pair<Character, UnitType>(Character.valueOf(JongSung[jong]), UnitType.JONGSUNG));
                continue;
            }
            result.add(new Pair<Character, UnitType>(Character.valueOf(ch), UnitType.OTHER));
        }
        return result;
    }

    public String combineWithType(List<Pair<Character, UnitType>> jasoUnitsWithType) {
        int chosung = 0;
        int jungsung = 0;
        int jongsung = 0;
        boolean hasBuffer = false;
        StringBuilder result = new StringBuilder();
        for (Pair<Character, UnitType> characterUnitTypePair : jasoUnitsWithType) {
            if (characterUnitTypePair.getSecond() == UnitType.CHOSUNG) {
                if (hasBuffer) {
                    result.append((char)(44032 + chosung * 588 + jungsung * 28 + jongsung));
                    jungsung = 0;
                    jongsung = 0;
                }
                chosung = Arrays.binarySearch(ChoSung, characterUnitTypePair.getFirst().charValue());
                hasBuffer = true;
                continue;
            }
            if (characterUnitTypePair.getSecond() == UnitType.JUNGSUNG) {
                jungsung = Arrays.binarySearch(JungSung, characterUnitTypePair.getFirst().charValue());
                hasBuffer = true;
                continue;
            }
            if (characterUnitTypePair.getSecond() == UnitType.JONGSUNG) {
                jongsung = Arrays.binarySearch(JongSung, characterUnitTypePair.getFirst().charValue());
                hasBuffer = true;
                continue;
            }
            if (hasBuffer) {
                result.append((char)(44032 + chosung * 588 + jungsung * 28 + jongsung));
                chosung = 0;
                jungsung = 0;
                jongsung = 0;
            }
            result.append(characterUnitTypePair.getFirst());
            hasBuffer = false;
        }
        if (hasBuffer) {
            result.append((char)(44032 + chosung * 588 + jungsung * 28 + jongsung));
        }
        return result.toString();
    }

    @Override
    public String parse(String str) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        int length = str.length();
        for (i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            Character.UnicodeBlock block = Character.UnicodeBlock.of(ch);
            if (block == Character.UnicodeBlock.HANGUL_SYLLABLES) {
                int tmp = ch - 44032;
                int cho = tmp / 588;
                int jung = (tmp %= 588) / 28;
                int jong = tmp % 28;
                result.append(ChoSung[cho]);
                result.append(JungSung[jung]);
                if (jong == 0) continue;
                result.append(JongSung[jong]);
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public List<Pair<Integer, Integer>> getSyllableAreaList(String str) {
        ArrayList<Pair<Integer, Integer>> syllableAreaList = new ArrayList<Pair<Integer, Integer>>();
        StringBuffer result = new StringBuffer();
        int i = 0;
        int length = str.length();
        int prevIdx = 0;
        for (i = 1; i < length; ++i) {
            int chosung;
            char ch = str.charAt(i);
            int jungsung = Arrays.binarySearch(JungSung, ch);
            if (jungsung < 0 || (chosung = Arrays.binarySearch(ChoSung, str.charAt(i - 1))) < 0) continue;
            result.append(str.substring(prevIdx, i - 1));
            if (str.substring(prevIdx, i - 1).length() != 0) {
                this.appendSplitedSyllableList(prevIdx, i - 1, syllableAreaList);
            }
            int jongsung = 0;
            if (i + 1 < length) {
                jongsung = Arrays.binarySearch(JongSung, str.charAt(i + 1));
            }
            if (i + 2 < length && Arrays.binarySearch(JungSung, str.charAt(i + 2)) >= 0) {
                jongsung = 0;
            }
            if (jongsung < 0) {
                jongsung = 0;
            }
            char syllable = (char)(44032 + chosung * 588 + jungsung * 28 + jongsung);
            result.append(syllable);
            int beginIndex = i - 1;
            if (jongsung > 0) {
                // empty if block
            }
            int endIndex = ++i;
            syllableAreaList.add(new Pair<Integer, Integer>(beginIndex, endIndex + 1));
            prevIdx = i + 1;
        }
        if (prevIdx < length) {
            result.append(str.substring(prevIdx));
            this.appendSplitedSyllableList(prevIdx, length, syllableAreaList);
        }
        return syllableAreaList;
    }

    private void appendSplitedSyllableList(int prevIdx, int endIdx, List<Pair<Integer, Integer>> targetList) {
        for (int i = prevIdx; i < endIdx; ++i) {
            targetList.add(new Pair<Integer, Integer>(i, i + 1));
        }
    }

    @Override
    public String combine(String str) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        int length = str.length();
        int prevIdx = 0;
        for (i = 1; i < length; ++i) {
            int chosung;
            char ch = str.charAt(i);
            int jungsung = Arrays.binarySearch(JungSung, ch);
            if (jungsung < 0 || (chosung = Arrays.binarySearch(ChoSung, str.charAt(i - 1))) < 0) continue;
            result.append(str.substring(prevIdx, i - 1));
            int jongsung = 0;
            if (i + 1 < length) {
                jongsung = Arrays.binarySearch(JongSung, str.charAt(i + 1));
            }
            if (i + 2 < length && Arrays.binarySearch(JungSung, str.charAt(i + 2)) >= 0) {
                jongsung = 0;
            }
            if (jongsung < 0) {
                jongsung = 0;
            }
            char syllable = (char)(44032 + chosung * 588 + jungsung * 28 + jongsung);
            result.append(syllable);
            if (jongsung > 0) {
                ++i;
            }
            prevIdx = i + 1;
        }
        if (prevIdx < length) {
            result.append(str.substring(prevIdx));
        }
        return result.toString();
    }

    public static enum UnitType {
        CHOSUNG,
        JUNGSUNG,
        JONGSUNG,
        OTHER;

    }
}

