/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.modeler.model;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kr.co.shineware.nlp.komoran.interfaces.FileAccessible;

public class Transition
implements FileAccessible {
    private double[][] scoreMatrix;

    public Transition() {
    }

    public Transition(int size) {
        this.scoreMatrix = new double[size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                this.scoreMatrix[i][j] = Double.NEGATIVE_INFINITY;
            }
        }
    }

    public void put(int prevId, int curId, double transitionScore) {
        this.scoreMatrix[prevId][curId] = transitionScore;
    }

    public Double get(int prevId, int curId) {
        if (this.scoreMatrix[prevId][curId] == Double.NEGATIVE_INFINITY) {
            return null;
        }
        return this.scoreMatrix[prevId][curId];
    }

    @Override
    public void save(String filename) {
        try {
            ObjectOutputStream dos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(filename))));
            dos.writeObject(this.scoreMatrix);
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void load(String filename) {
        try {
            ObjectInputStream dis = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(filename))));
            this.scoreMatrix = (double[][])dis.readObject();
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load(File file) {
        try {
            ObjectInputStream dis = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
            this.scoreMatrix = (double[][])dis.readObject();
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load(InputStream inputStream) {
        try {
            ObjectInputStream dis = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(inputStream)));
            this.scoreMatrix = (double[][])dis.readObject();
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

