/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.modeler.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kr.co.shineware.nlp.komoran.interfaces.FileAccessible;

public class PosTable
implements FileAccessible {
    private Map<String, Integer> posIdTable;
    private Map<Integer, String> idPosTable;

    public PosTable() {
        this.init();
    }

    private void init() {
        this.posIdTable = null;
        this.idPosTable = null;
        this.posIdTable = new HashMap<String, Integer>();
        this.idPosTable = new HashMap<Integer, String>();
    }

    public void put(String pos) {
        Integer id = this.posIdTable.get(pos);
        if (id == null) {
            this.posIdTable.put(pos, this.posIdTable.size());
            this.idPosTable.put(this.idPosTable.size(), pos);
        }
    }

    public int getId(String pos) {
        return this.posIdTable.get(pos);
    }

    public String getPos(int id) {
        return this.idPosTable.get(id);
    }

    public int size() {
        return this.posIdTable.size();
    }

    @Override
    public void save(String filename) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
            Set<Map.Entry<String, Integer>> posIdEntrySet = this.posIdTable.entrySet();
            for (Map.Entry<String, Integer> entry : posIdEntrySet) {
                bw.write(entry.getKey() + "\t" + entry.getValue());
                bw.newLine();
            }
            bw.close();
            bw = null;
            Object var3_4 = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void load(String filename) {
        try {
            this.init();
            BufferedReader br = new BufferedReader(new FileReader(filename));
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] tokens = line.split("\t");
                this.posIdTable.put(tokens[0], Integer.parseInt(tokens[1]));
                this.idPosTable.put(Integer.parseInt(tokens[1]), tokens[0]);
            }
            br.close();
            br = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load(InputStream is) {
        try {
            this.init();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] tokens = line.split("\t");
                this.posIdTable.put(tokens[0], Integer.parseInt(tokens[1]));
                this.idPosTable.put(Integer.parseInt(tokens[1]), tokens[0]);
            }
            br.close();
            br = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load(File file) {
        try {
            this.init();
            BufferedReader br = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] tokens = line.split("\t");
                this.posIdTable.put(tokens[0], Integer.parseInt(tokens[1]));
                this.idPosTable.put(Integer.parseInt(tokens[1]), tokens[0]);
            }
            br.close();
            br = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

