/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.modeler.builder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kr.co.shineware.nlp.komoran.corpus.model.Dictionary;
import kr.co.shineware.nlp.komoran.corpus.model.Grammar;
import kr.co.shineware.nlp.komoran.model.ScoredTag;
import kr.co.shineware.nlp.komoran.modeler.model.IrregularNode;
import kr.co.shineware.nlp.komoran.modeler.model.IrregularTrie;
import kr.co.shineware.nlp.komoran.modeler.model.Observation;
import kr.co.shineware.nlp.komoran.modeler.model.PosTable;
import kr.co.shineware.nlp.komoran.modeler.model.Transition;
import kr.co.shineware.nlp.komoran.parser.KoreanUnitParser;
import kr.co.shineware.util.common.file.FileUtil;
import kr.co.shineware.util.common.model.Pair;

public class ModelBuilder {
    private Dictionary wordDic;
    private Dictionary irrDic;
    private Grammar grammar;
    private Transition transition;
    private Observation observation;
    private PosTable table;
    private IrregularTrie irrTrie;
    private KoreanUnitParser unitParser;
    private String externalDic;

    public void buildPath(String path) {
        this.unitParser = null;
        this.wordDic = null;
        this.irrDic = null;
        this.grammar = null;
        this.unitParser = new KoreanUnitParser();
        this.wordDic = new Dictionary(path + File.separator + "dic.word");
        this.addExternalDic(this.externalDic);
        this.irrDic = new Dictionary(path + File.separator + "dic.irregular");
        this.grammar = new Grammar(path + File.separator + "grammar.in");
        Map<String, Integer> totalPrevPOSTf = this.getTotalPrevPOSCount();
        this.buildPosTable(totalPrevPOSTf);
        this.calTransition(totalPrevPOSTf);
        this.calObservation(totalPrevPOSTf);
        this.buildIrregularDic();
    }

    private void buildIrregularDic() {
        this.irrTrie = new IrregularTrie();
        Set<Map.Entry<String, Map<String, Integer>>> irrDicEntrySet = this.irrDic.getDictionary().entrySet();
        for (Map.Entry<String, Map<String, Integer>> irrConvertTfEntry : irrDicEntrySet) {
            String irr = irrConvertTfEntry.getKey();
            irr = this.unitParser.parse(irr);
            Set<Map.Entry<String, Integer>> convertTfSet = irrConvertTfEntry.getValue().entrySet();
            for (Map.Entry<String, Integer> convertTf : convertTfSet) {
                if (convertTf.getValue() < 2 && convertTfSet.size() > 1) continue;
                IrregularNode irrNode = this.makeIrrNode(irr, this.unitParser.parse(convertTf.getKey()));
                this.irrTrie.put(irr, irrNode);
            }
        }
    }

    private IrregularNode makeIrrNode(String irr, String convert) {
        IrregularNode irrNode = new IrregularNode();
        ArrayList<Pair<String, Integer>> irrNodeTokens = new ArrayList<Pair<String, Integer>>();
        double score = 0.0;
        StringBuffer morphFormat = new StringBuffer();
        String[] tokens = convert.split(" ");
        int prevPosId = -1;
        for (int i = 0; i < tokens.length; ++i) {
            List<ScoredTag> scoredTagList;
            String token = tokens[i];
            int splitIdx = token.lastIndexOf("/");
            String morph = token.substring(0, splitIdx);
            int posId = this.table.getId(token.substring(splitIdx + 1));
            irrNodeTokens.add(new Pair<String, Integer>(morph, posId));
            if (i == 0) {
                irrNode.setFirstPosId(posId);
            }
            if ((scoredTagList = this.observation.getTrieDictionary().getValue(morph)) == null) continue;
            for (ScoredTag scoredTag : scoredTagList) {
                if (scoredTag.getTagId() != posId) continue;
                score += scoredTag.getScore();
                break;
            }
            if (prevPosId != -1) {
                score += this.transition.get(prevPosId, posId).doubleValue();
            }
            prevPosId = posId;
            morphFormat.append(morph);
            if (i == tokens.length - 1) {
                irrNode.setLastMorph(morph);
                irrNode.setLastPosId(posId);
                break;
            }
            morphFormat.append("/");
            morphFormat.append(token.substring(splitIdx + 1));
            morphFormat.append(" ");
        }
        irrNode.setInnerScore(score);
        irrNode.setTokens(irrNodeTokens);
        irrNode.setMorphFormat(morphFormat.toString());
        return irrNode;
    }

    private void buildPosTable(Map<String, Integer> totalPrevPOSTf) {
        this.table = new PosTable();
        Set<String> posSet = totalPrevPOSTf.keySet();
        for (String pos : posSet) {
            this.table.put(pos);
        }
        this.table.put("<end>");
        this.table.put("NA");
    }

    private void calObservation(Map<String, Integer> totalPrevPOSTf) {
        this.observation = new Observation();
        Set<Map.Entry<String, Map<String, Integer>>> wordDicEntrySet = this.wordDic.getDictionary().entrySet();
        for (Map.Entry<String, Map<String, Integer>> wordPosTfEntry : wordDicEntrySet) {
            String word = wordPosTfEntry.getKey();
            Set<Map.Entry<String, Integer>> posTfSet = wordPosTfEntry.getValue().entrySet();
            for (Map.Entry<String, Integer> posTf : posTfSet) {
                int totalPosTf = totalPrevPOSTf.get(posTf.getKey());
                double observationScore = (double)posTf.getValue().intValue() / (double)totalPosTf;
                observationScore = Math.log10(observationScore);
                this.observation.put(word, posTf.getKey(), this.table.getId(posTf.getKey()), observationScore);
            }
        }
    }

    private void calTransition(Map<String, Integer> totalPrevPOSTf) {
        this.transition = new Transition(this.table.size());
        Set<String> prevPosSet = this.grammar.getGrammar().keySet();
        for (String prevPos : prevPosSet) {
            Map<String, Integer> curPosMap = this.grammar.getGrammar().get(prevPos);
            Set<String> curPosSet = curPosMap.keySet();
            for (String curPos : curPosSet) {
                int prev2CurTf = curPosMap.get(curPos);
                int prevTf = totalPrevPOSTf.get(prevPos);
                if (curPos.equals("NNP")) {
                    prev2CurTf += 100000;
                    prevTf += 100000;
                }
                double transitionScore = (double)prev2CurTf / (double)prevTf;
                transitionScore = Math.log10(transitionScore);
                this.transition.put(this.table.getId(prevPos), this.table.getId(curPos), transitionScore);
            }
        }
    }

    private Map<String, Integer> getTotalPrevPOSCount() {
        HashMap<String, Integer> posCountMap = new HashMap<String, Integer>();
        Set<String> prevPosSet = this.grammar.getGrammar().keySet();
        for (String prevPos : prevPosSet) {
            Map<String, Integer> prev2curPosMap = this.grammar.getGrammar().get(prevPos);
            Set<String> curPosSet = prev2curPosMap.keySet();
            for (String curPos : curPosSet) {
                Integer tf = (Integer)posCountMap.get(prevPos);
                if (tf == null) {
                    tf = 0;
                }
                tf = tf + prev2curPosMap.get(curPos);
                posCountMap.put(prevPos, tf);
            }
        }
        return posCountMap;
    }

    @Deprecated
    public void load(String path) {
    }

    public void save(String path) {
        FileUtil.makePath(path);
        this.transition.save(path + File.separator + "transition.model");
        this.observation.save(path + File.separator + "observation.model");
        this.table.save(path + File.separator + "pos.table");
        this.irrTrie.save(path + File.separator + "irregular.model");
    }

    public void setExternalDic(String externalDic) {
        this.externalDic = externalDic;
    }

    private void addExternalDic(String filename) {
        try {
            if (filename != null) {
                BufferedReader br = new BufferedReader(new FileReader(filename));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                    this.wordDic.append(line, "NNP", 50);
                }
                br.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

