/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kr.co.shineware.nlp.komoran.core.model.LatticeNode;
import kr.co.shineware.nlp.komoran.model.Token;
import kr.co.shineware.nlp.komoran.parser.KoreanUnitParser;
import kr.co.shineware.util.common.model.Pair;

public class KomoranResult {
    private List<LatticeNode> resultNodeList;
    private String jasoUnits;
    private KoreanUnitParser parser = new KoreanUnitParser();

    public KomoranResult(List<LatticeNode> latticeNode, String jasoUnits) {
        this.resultNodeList = latticeNode;
        this.jasoUnits = jasoUnits;
    }

    public List<String> getNouns() {
        return this.getMorphesByTags(Arrays.asList("NNG", "NNP"));
    }

    public List<String> getMorphesByTags(String ... str) {
        return this.getMorphesByTags(Arrays.asList(str));
    }

    public List<String> getMorphesByTags(Collection<String> targetPosCollection) {
        HashSet<String> targetPosSet = new HashSet<String>(targetPosCollection);
        ArrayList<String> morphList = new ArrayList<String>();
        for (LatticeNode latticeNode : this.resultNodeList) {
            if (!targetPosSet.contains(latticeNode.getTag())) continue;
            morphList.add(this.parser.combine(latticeNode.getMorphTag().getMorph()));
        }
        return morphList;
    }

    public String getPlainText() {
        StringBuilder result = new StringBuilder();
        for (LatticeNode latticeNode : this.resultNodeList) {
            if (latticeNode.getMorphTag().getTag().equals("<end>")) continue;
            if (latticeNode.getTag().equals("NA")) {
                result.append(latticeNode.getMorphTag().getMorph()).append("/").append(latticeNode.getMorphTag().getTag()).append(" ");
                continue;
            }
            result.append(this.parser.combine(latticeNode.getMorphTag().getMorph())).append("/").append(latticeNode.getTag()).append(" ");
        }
        return result.toString().trim();
    }

    public List<Token> getTokenList() {
        List<Pair<Integer, Integer>> syllableAreaList = this.parser.getSyllableAreaList(this.jasoUnits);
        ArrayList<Token> tokenList = new ArrayList<Token>();
        int prevBeginIdx = 0;
        for (LatticeNode latticeNode : this.resultNodeList) {
            if (latticeNode.getMorphTag().getTag().equals("<end>")) continue;
            if (latticeNode.getBeginIdx() < 0) {
                latticeNode.setBeginIdx(prevBeginIdx);
            }
            Pair<Integer, Integer> syllableArea = this.getSyllableArea(latticeNode.getBeginIdx(), latticeNode.getEndIdx(), syllableAreaList);
            tokenList.add(new Token(this.parser.combine(latticeNode.getMorphTag().getMorph()), this.parser.combine(latticeNode.getTag()), syllableArea.getFirst(), syllableArea.getSecond()));
            prevBeginIdx = latticeNode.getBeginIdx();
        }
        return tokenList;
    }

    private Pair<Integer, Integer> getSyllableArea(int jasoBeginIdx, int jasoEndIdx, List<Pair<Integer, Integer>> syllableAreaList) {
        Pair<Integer, Integer> syllableAreaPair = new Pair<Integer, Integer>();
        for (int i = 0; i < syllableAreaList.size(); ++i) {
            if (syllableAreaList.get(i).getFirst() <= jasoBeginIdx && jasoBeginIdx <= syllableAreaList.get(i).getSecond()) {
                syllableAreaPair.setFirst(i);
            }
            if (syllableAreaList.get(i).getFirst() >= jasoEndIdx || jasoEndIdx > syllableAreaList.get(i).getSecond()) continue;
            syllableAreaPair.setSecond(i + 1);
        }
        return syllableAreaPair;
    }

    public List<Pair<String, String>> getList() {
        ArrayList<Pair<String, String>> resultList = new ArrayList<Pair<String, String>>();
        for (LatticeNode latticeNode : this.resultNodeList) {
            if (latticeNode.getMorphTag().getTag().equals("<end>")) continue;
            resultList.add(new Pair<String, String>(this.parser.combine(latticeNode.getMorphTag().getMorph()), latticeNode.getTag()));
        }
        return resultList;
    }
}

