/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.corpus.model;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kr.co.shineware.nlp.komoran.interfaces.FileAccessible;
import kr.co.shineware.util.common.file.FileUtil;
import kr.co.shineware.util.common.string.StringUtil;

public class Grammar
implements FileAccessible {
    private Map<String, Map<String, Integer>> grammar;

    public Grammar() {
        this.grammar = new HashMap<String, Map<String, Integer>>();
    }

    public Grammar(String filename) {
        this.load(filename);
    }

    public Map<String, Map<String, Integer>> getGrammar() {
        return this.grammar;
    }

    public void append(String prevPos, String nextPos) {
        Integer tf;
        Map<String, Integer> nextMorphMap = this.grammar.get(prevPos);
        if (nextMorphMap == null) {
            nextMorphMap = new HashMap<String, Integer>();
        }
        if ((tf = nextMorphMap.get(nextPos)) == null) {
            tf = 0;
        }
        Integer n = tf;
        Integer n2 = tf = Integer.valueOf(tf + 1);
        nextMorphMap.put(nextPos, tf);
        this.grammar.put(prevPos, nextMorphMap);
    }

    public boolean has(String prevPos, String nextPos) {
        Map<String, Integer> nextPosMap = this.grammar.get(prevPos);
        if (nextPosMap == null) {
            return false;
        }
        Integer tf = nextPosMap.get(nextPos);
        return tf != null;
    }

    @Override
    public void save(String filename) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
            Set<Map.Entry<String, Map<String, Integer>>> entrySet = this.grammar.entrySet();
            for (Map.Entry<String, Map<String, Integer>> entry : entrySet) {
                bw.write(entry.getKey());
                bw.write("\t");
                Set<String> nextMorphSet = entry.getValue().keySet();
                int morphSize = nextMorphSet.size();
                int count = 0;
                for (String nextMorph : nextMorphSet) {
                    bw.write(nextMorph);
                    bw.write(":");
                    Integer tf = entry.getValue().get(nextMorph);
                    bw.write("" + tf);
                    if (morphSize == ++count) continue;
                    bw.write(",");
                }
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void load(String filename) {
        this.grammar = new HashMap<String, Map<String, Integer>>();
        List<String> lines = FileUtil.load2List(filename);
        int size = lines.size();
        for (int i = 0; i < size; ++i) {
            String line = lines.get(i);
            List<String> lineSplitedList = StringUtil.split(line, "\t");
            String prevPos = lineSplitedList.get(0);
            HashMap<String, Integer> nextPosMap = new HashMap<String, Integer>();
            String nextPosChunks = lineSplitedList.get(1);
            List<String> nextPosChunkList = StringUtil.split(nextPosChunks, ",");
            int posChunkListSize = nextPosChunkList.size();
            String commaPos = "";
            for (int j = 0; j < posChunkListSize; ++j) {
                String nextPosTfPair = nextPosChunkList.get(j);
                if (nextPosTfPair.length() == 0) {
                    commaPos = commaPos + ",";
                    continue;
                }
                int separatorIdx = nextPosTfPair.lastIndexOf(58);
                String nextPos = separatorIdx == 0 ? "" : nextPosTfPair.substring(0, separatorIdx);
                Integer tf = Integer.parseInt(nextPosTfPair.substring(separatorIdx + 1));
                nextPosMap.put(commaPos + nextPos, tf);
                commaPos = "";
            }
            this.grammar.put(prevPos, nextPosMap);
        }
    }
}

