/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.corpus.builder;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kr.co.shineware.nlp.komoran.corpus.parser.CorpusParser;
import kr.co.shineware.nlp.komoran.corpus.parser.model.ProblemAnswerPair;
import kr.co.shineware.util.common.file.FileUtil;

public class FWDBuilder {
    private int threshold = 1;
    private CorpusParser parser = new CorpusParser();
    private Map<String, Map<String, Integer>> fwdMap = new HashMap<String, Map<String, Integer>>();

    public void buildPath(String path, String suffix) {
        List<String> filenames = FileUtil.getFileNames(path);
        for (String filename : filenames) {
            if (!filename.endsWith("." + suffix)) continue;
            System.out.println(filename);
            this.build(filename);
        }
        filenames = null;
    }

    public void build(String filename) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(filename));
            String line = null;
            while ((line = br.readLine()) != null) {
                if ((line = this.refineFormat(line)).length() == 0) continue;
                ProblemAnswerPair problemAnswerPair = this.parser.parse(line);
                String problem = problemAnswerPair.getProblem();
                String answer = problemAnswerPair.getAnswer();
                this.insertFWDMap(problem, answer);
            }
            br.close();
            br = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void insertFWDMap(String problem, String answer) {
        Integer tf;
        Map<String, Integer> answerTfMap = this.fwdMap.get(problem);
        if (answerTfMap == null) {
            answerTfMap = new HashMap<String, Integer>();
        }
        if ((tf = answerTfMap.get(answer)) == null) {
            tf = 0;
        }
        Integer n = tf;
        Integer n2 = tf = Integer.valueOf(tf + 1);
        answerTfMap.put(answer, tf);
        this.fwdMap.put(problem, answerTfMap);
    }

    private String refineFormat(String line) {
        return line.replaceAll("[ ]+", " ").trim();
    }

    public void save(String filename, int threshold) {
        this.setThreshold(threshold);
        this.save(filename);
    }

    private void save(String filename) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
            Set<Map.Entry<String, Map<String, Integer>>> fwdEntrySet = this.fwdMap.entrySet();
            for (Map.Entry<String, Map<String, Integer>> fwdEntry : fwdEntrySet) {
                String problem = fwdEntry.getKey();
                Map<String, Integer> answerTf = fwdEntry.getValue();
                if (answerTf.size() != 1) continue;
                Set<String> answerSet = answerTf.keySet();
                for (String answer : answerSet) {
                    int tf = answerTf.get(answer);
                    if (tf < this.getThreshold()) continue;
                    bw.write(problem + "\t" + answer);
                    bw.newLine();
                }
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

