/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kr.co.shineware.nlp.komoran.core.model.LatticeNode;
import kr.co.shineware.nlp.komoran.core.model.Resources;
import kr.co.shineware.nlp.komoran.model.MorphTag;
import kr.co.shineware.nlp.komoran.model.ScoredTag;
import kr.co.shineware.nlp.komoran.modeler.model.IrregularNode;
import kr.co.shineware.nlp.komoran.modeler.model.Observation;
import kr.co.shineware.nlp.komoran.modeler.model.PosTable;
import kr.co.shineware.nlp.komoran.modeler.model.Transition;
import kr.co.shineware.nlp.komoran.parser.KoreanUnitParser;
import kr.co.shineware.util.common.model.Pair;

public class Lattice {
    private static final int IRREGULAR_POS_ID = -1;
    private Map<Integer, List<LatticeNode>> lattice;
    private PosTable posTable;
    private Transition transition;
    private int lastIdx = -1;
    private int irrIdx = 0;
    private Observation observation;
    private KoreanUnitParser unitParser;
    private double prevMaxScore;
    private LatticeNode prevMaxNode;
    private int prevMaxIdx;

    public Lattice(Resources resource) {
        this.setPosTable(resource.getTable());
        this.setTransition(resource.getTransition());
        this.setObservation(resource.getObservation());
        this.init();
    }

    private void init() {
        this.lattice = new HashMap<Integer, List<LatticeNode>>();
        this.irrIdx = 0;
        ArrayList<LatticeNode> latticeNodes = new ArrayList<LatticeNode>();
        latticeNodes.add(this.makeStartNode());
        this.lattice.put(0, latticeNodes);
    }

    private LatticeNode makeStartNode() {
        return new LatticeNode(-1, 0, new MorphTag("<start>", "<start>", this.getPosTable().getId("<start>")), 0.0);
    }

    public void put(int beginIdx, int endIdx, List<Pair<String, String>> fwdResultList) {
        if (fwdResultList.size() == 1) {
            Pair<String, String> morphPosPair = fwdResultList.get(0);
            this.put(beginIdx, endIdx, morphPosPair.getFirst(), morphPosPair.getSecond(), this.posTable.getId(morphPosPair.getSecond()), 0.0);
        } else {
            for (int i = 0; i < fwdResultList.size(); ++i) {
                Pair<String, String> morphPosPair = fwdResultList.get(i);
                if (i == 0) {
                    this.put(beginIdx, this.irrIdx - 1, morphPosPair.getFirst(), morphPosPair.getSecond(), this.posTable.getId(morphPosPair.getSecond()), 0.0);
                } else if (i == fwdResultList.size() - 1) {
                    this.put(this.irrIdx, endIdx, morphPosPair.getFirst(), morphPosPair.getSecond(), this.posTable.getId(morphPosPair.getSecond()), 0.0);
                } else {
                    this.put(this.irrIdx, this.irrIdx - 1, morphPosPair.getFirst(), morphPosPair.getSecond(), this.posTable.getId(morphPosPair.getSecond()), 0.0);
                }
                --this.irrIdx;
            }
        }
    }

    public void put(int beginIdx, int endIdx, IrregularNode irregularNode) {
        List<LatticeNode> prevLatticeNodes = this.getNodeList(beginIdx);
        if (prevLatticeNodes != null) {
            this.prevMaxIdx = -1;
            this.prevMaxNode = null;
            this.prevMaxScore = Double.NEGATIVE_INFINITY;
            this.getMaxTransitionIdxFromPrevNodes(prevLatticeNodes, irregularNode.getFirstPosId());
            if (this.prevMaxNode != null) {
                List<Pair<String, Integer>> irregularTokens = irregularNode.getTokens();
                int prevMaxIdx = this.prevMaxIdx;
                double prevMaxScore = this.prevMaxScore;
                this.putIrregularExtendTokens(beginIdx, endIdx, irregularTokens, prevMaxScore, prevMaxIdx);
                this.putFirstIrrgularNode(beginIdx, endIdx, irregularTokens, prevMaxScore, prevMaxIdx);
                this.putIrregularTokens(beginIdx, endIdx, irregularTokens);
            }
        }
    }

    private void putIrregularExtendTokens(int beginIdx, int endIdx, List<Pair<String, Integer>> morphPosIdList, double prevMaxScore, int prevMaxIdx) {
        if (morphPosIdList.size() != 0) {
            Pair<String, Integer> morphPosId = morphPosIdList.get(0);
            List<ScoredTag> scoredTags = this.observation.getTrieDictionary().getValue(morphPosId.getFirst());
            for (ScoredTag scoredTag : scoredTags) {
                if (scoredTag.getTagId() != morphPosId.getSecond().intValue()) continue;
                LatticeNode firstIrregularNode = this.makeNode(beginIdx, this.irrIdx - 1, morphPosId.getFirst(), scoredTag.getTag(), scoredTag.getTagId(), prevMaxScore + scoredTag.getScore(), prevMaxIdx);
                --this.irrIdx;
                this.appendNode(firstIrregularNode);
            }
        }
        for (int i = 1; i < morphPosIdList.size(); ++i) {
            Pair<String, Integer> morphPosId = morphPosIdList.get(i);
            if (i == morphPosIdList.size() - 1) {
                LatticeNode latticeNode = this.makeNode(this.irrIdx, endIdx, morphPosId.getFirst(), "IRR", -1, 0.0, 0);
                this.appendNode(latticeNode);
            } else {
                List<ScoredTag> scoredTags = this.observation.getTrieDictionary().getValue(morphPosId.getFirst());
                for (ScoredTag scoredTag : scoredTags) {
                    if (scoredTag.getTagId() != morphPosId.getSecond().intValue()) continue;
                    this.put(this.irrIdx, this.irrIdx - 1, morphPosId.getFirst(), this.posTable.getPos(morphPosId.getSecond()), morphPosId.getSecond(), scoredTag.getScore());
                }
            }
            --this.irrIdx;
        }
    }

    private void putFirstIrrgularNode(int beginIdx, int endIdx, List<Pair<String, Integer>> irregularTokens, double score, int maxTransitionPrevIdx) {
        if (irregularTokens.size() == 1) {
            Pair<String, Integer> morphPosId = irregularTokens.get(0);
            List<ScoredTag> scoredTags = this.observation.getTrieDictionary().getValue(morphPosId.getFirst());
            for (ScoredTag scoredTag : scoredTags) {
                if (scoredTag.getTagId() != morphPosId.getSecond().intValue()) continue;
                LatticeNode firstIrregularNode = this.makeNode(beginIdx, endIdx, morphPosId.getFirst(), scoredTag.getTag(), scoredTag.getTagId(), score + scoredTag.getScore(), maxTransitionPrevIdx);
                this.appendNode(firstIrregularNode);
                if (scoredTag.getTagId() != this.posTable.getId("EC")) continue;
                LatticeNode extendIrregularNode = this.makeNode(beginIdx, endIdx, morphPosId.getFirst(), "EF", this.posTable.getId("EF"), score + scoredTag.getScore(), maxTransitionPrevIdx);
                this.appendNode(extendIrregularNode);
            }
        } else {
            Pair<String, Integer> morphPosId = irregularTokens.get(0);
            List<ScoredTag> scoredTags = this.observation.getTrieDictionary().getValue(morphPosId.getFirst());
            for (ScoredTag scoredTag : scoredTags) {
                if (scoredTag.getTagId() != morphPosId.getSecond().intValue()) continue;
                LatticeNode firstIrregularNode = this.makeNode(beginIdx, this.irrIdx - 1, morphPosId.getFirst(), scoredTag.getTag(), scoredTag.getTagId(), score + scoredTag.getScore(), maxTransitionPrevIdx);
                --this.irrIdx;
                this.appendNode(firstIrregularNode);
            }
        }
    }

    public boolean put(int beginIdx, int endIdx, String morph, String tag, int tagId, double score) {
        LatticeNode latticeNode;
        List<LatticeNode> prevLatticeNodes = this.getNodeList(beginIdx);
        if (prevLatticeNodes != null && (latticeNode = this.getMaxTransitionNodeFromPrevNodes(prevLatticeNodes, beginIdx, endIdx, morph, tag, tagId, score)) != null) {
            this.appendNode(latticeNode);
            return true;
        }
        return false;
    }

    private LatticeNode getMaxTransitionNodeFromPrevNodes(List<LatticeNode> prevLatticeNodes, int beginIdx, int endIdx, String morph, String tag, int tagId, double score) {
        double prevMaxScore = Double.NEGATIVE_INFINITY;
        LatticeNode prevMaxNode = null;
        int latticeNodeIdx = -1;
        int prevLatticeNodeIdx = -1;
        for (LatticeNode prevLatticeNode : prevLatticeNodes) {
            Double transitionScore;
            String prevMorph;
            int prevTagId;
            ++latticeNodeIdx;
            if (prevLatticeNode.getMorphTag().getTagId() == -1) continue;
            if (prevLatticeNode.getMorphTag().getTag().equals("<end>")) {
                prevTagId = this.getPosTable().getId("<start>");
                prevMorph = "<start>";
            } else {
                prevTagId = prevLatticeNode.getMorphTag().getTagId();
                prevMorph = prevLatticeNode.getMorphTag().getMorph();
            }
            if ((transitionScore = this.transition.get(prevTagId, tagId)) == null || (tagId == this.posTable.getId("JKO") ? (this.hasJongsung(prevMorph) ? morph.charAt(0) != '\u3147' : morph.charAt(0) == '\u3147') : (tagId == this.posTable.getId("JKS") || tagId == this.posTable.getId("JKC")) && (this.hasJongsung(prevMorph) ? morph.charAt(0) == '\u3131' && morph.charAt(1) == '\u314f' : morph.charAt(0) == '\u3147' && morph.charAt(1) == '\u3163'))) continue;
            double prevObservationScore = prevLatticeNode.getScore();
            if (!(prevMaxScore < transitionScore + prevObservationScore)) continue;
            prevMaxScore = transitionScore + prevObservationScore;
            prevMaxNode = prevLatticeNode;
            prevLatticeNodeIdx = latticeNodeIdx;
        }
        if (prevMaxNode != null) {
            return this.makeNode(beginIdx, endIdx, morph, tag, tagId, prevMaxScore + score, prevLatticeNodeIdx);
        }
        return null;
    }

    public LatticeNode makeNode(int beginIdx, int endIdx, String morph, String tag, int tagId, double score, int prevNodeHash) {
        LatticeNode latticeNode = new LatticeNode(beginIdx, endIdx, new MorphTag(morph, tag, tagId), score);
        latticeNode.setPrevNodeIdx(prevNodeHash);
        return latticeNode;
    }

    public int appendNode(LatticeNode latticeNode) {
        List<LatticeNode> latticeNodeList = this.getNodeList(latticeNode.getEndIdx());
        if (latticeNodeList == null) {
            latticeNodeList = new ArrayList<LatticeNode>();
        }
        latticeNodeList.add(latticeNode);
        this.lattice.put(latticeNode.getEndIdx(), latticeNodeList);
        return latticeNodeList.size() - 1;
    }

    public List<LatticeNode> getNodeList(int index) {
        return this.lattice.get(index);
    }

    private void getMaxTransitionIdxFromPrevNodes(List<LatticeNode> prevLatticeNodes, int tagId) {
        this.getMaxTransitionInfoFromPrevNodes(prevLatticeNodes, tagId);
    }

    private void getMaxTransitionInfoFromPrevNodes(List<LatticeNode> prevLatticeNodes, int tagId) {
        int prevMaxNodeIdx = -1;
        for (LatticeNode prevLatticeNode : prevLatticeNodes) {
            int prevTagId;
            Double transitionScore;
            ++prevMaxNodeIdx;
            if (prevLatticeNode.getMorphTag().getTagId() == -1 || (transitionScore = this.transition.get(prevTagId = prevLatticeNode.getMorphTag().getTag().equals("<end>") ? this.getPosTable().getId("<start>") : prevLatticeNode.getMorphTag().getTagId(), tagId)) == null) continue;
            double prevObservationScore = prevLatticeNode.getScore();
            if (!(this.prevMaxScore < transitionScore + prevObservationScore)) continue;
            this.prevMaxScore = transitionScore + prevObservationScore;
            this.prevMaxNode = prevLatticeNode;
            this.prevMaxIdx = prevMaxNodeIdx;
        }
    }

    private boolean hasJongsung(String str) {
        char prevLastJaso = str.charAt(str.length() - 1);
        if ('\u3131' <= prevLastJaso && prevLastJaso <= '\u314e') {
            return prevLastJaso != '\u3138' && prevLastJaso != '\u3143' && prevLastJaso != '\u3149';
        }
        return false;
    }

    public PosTable getPosTable() {
        return this.posTable;
    }

    public void setPosTable(PosTable posTable) {
        this.posTable = posTable;
    }

    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public int getLastIdx() {
        return this.lastIdx;
    }

    public void setLastIdx(int lastIdx) {
        this.lastIdx = lastIdx;
    }

    public boolean appendEndNode() {
        return this.put(this.lastIdx, this.lastIdx + 1, "<end>", "<end>", this.getPosTable().getId("<end>"), 0.0);
    }

    public List<LatticeNode> findPath() {
        ArrayList<LatticeNode> shortestPathList = new ArrayList<LatticeNode>();
        int idx = this.getLastIdx() + 1;
        if (!this.lattice.containsKey(idx)) {
            return null;
        }
        LatticeNode latticeNode = this.lattice.get(idx).get(0);
        int prevLatticeEndIndex = latticeNode.getEndIdx();
        do {
            if ((latticeNode = this.lattice.get(latticeNode.getBeginIdx()).get(latticeNode.getPrevNodeIdx())).getEndIdx() < 0) {
                latticeNode.setEndIdx(prevLatticeEndIndex);
            }
            shortestPathList.add(latticeNode);
            prevLatticeEndIndex = latticeNode.getEndIdx();
        } while (latticeNode.getBeginIdx() != 0);
        return shortestPathList;
    }

    private void putIrregularTokens(int beginIdx, int endIdx, List<Pair<String, Integer>> morphPosIdList) {
        for (int i = 1; i < morphPosIdList.size(); ++i) {
            Pair<String, Integer> morphPosId = morphPosIdList.get(i);
            List<ScoredTag> scoredTags = this.observation.getTrieDictionary().getValue(morphPosId.getFirst());
            if (i == morphPosIdList.size() - 1) {
                for (ScoredTag scoredTag : scoredTags) {
                    if (scoredTag.getTagId() != morphPosId.getSecond().intValue()) continue;
                    this.put(this.irrIdx, endIdx, morphPosId.getFirst(), this.posTable.getPos(morphPosId.getSecond()), morphPosId.getSecond(), scoredTag.getScore());
                    if (morphPosId.getSecond().intValue() != this.posTable.getId("EC")) continue;
                    this.put(this.irrIdx, endIdx, morphPosId.getFirst(), "EF", this.posTable.getId("EF"), scoredTag.getScore());
                }
            } else {
                for (ScoredTag scoredTag : scoredTags) {
                    if (scoredTag.getTagId() != morphPosId.getSecond().intValue()) continue;
                    this.put(this.irrIdx, this.irrIdx - 1, morphPosId.getFirst(), this.posTable.getPos(morphPosId.getSecond()), morphPosId.getSecond(), scoredTag.getScore());
                }
            }
            --this.irrIdx;
        }
    }

    public void setObservation(Observation observation) {
        this.observation = observation;
    }

    public void setUnitParser(KoreanUnitParser unitParser) {
        this.unitParser = unitParser;
    }
}

