/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import kr.co.shineware.ds.aho_corasick.FindContext;
import kr.co.shineware.nlp.komoran.constant.DEFAULT_MODEL;
import kr.co.shineware.nlp.komoran.core.model.ContinuousSymbolInfo;
import kr.co.shineware.nlp.komoran.core.model.Lattice;
import kr.co.shineware.nlp.komoran.core.model.LatticeNode;
import kr.co.shineware.nlp.komoran.core.model.Resources;
import kr.co.shineware.nlp.komoran.corpus.parser.CorpusParser;
import kr.co.shineware.nlp.komoran.corpus.parser.model.ProblemAnswerPair;
import kr.co.shineware.nlp.komoran.model.KomoranResult;
import kr.co.shineware.nlp.komoran.model.MorphTag;
import kr.co.shineware.nlp.komoran.model.ScoredTag;
import kr.co.shineware.nlp.komoran.model.Tag;
import kr.co.shineware.nlp.komoran.modeler.model.IrregularNode;
import kr.co.shineware.nlp.komoran.modeler.model.Observation;
import kr.co.shineware.nlp.komoran.parser.KoreanUnitParser;
import kr.co.shineware.nlp.komoran.util.KomoranCallable;
import kr.co.shineware.util.common.file.FileUtil;
import kr.co.shineware.util.common.model.Pair;
import kr.co.shineware.util.common.string.StringUtil;

public class Komoran
implements Cloneable {
    private Resources resources = new Resources();
    private Observation userDic;
    private KoreanUnitParser unitParser;
    private HashMap<String, List<Pair<String, String>>> fwd;

    public Komoran(String modelPath) {
        this.load(modelPath);
        this.unitParser = new KoreanUnitParser();
    }

    public Komoran(DEFAULT_MODEL modelType) {
        this.resources.init();
        String modelPath = modelType == DEFAULT_MODEL.FULL ? "models_full" : (modelType == DEFAULT_MODEL.LIGHT ? "models_light" : "models_full");
        String delimiter = "/";
        InputStream posTableFile = this.getResourceStream(String.join((CharSequence)delimiter, modelPath, "pos.table"));
        InputStream irrModelFile = this.getResourceStream(String.join((CharSequence)delimiter, modelPath, "irregular.model"));
        InputStream observationFile = this.getResourceStream(String.join((CharSequence)delimiter, modelPath, "observation.model"));
        InputStream transitionFile = this.getResourceStream(String.join((CharSequence)delimiter, modelPath, "transition.model"));
        this.resources.loadPosTable(posTableFile);
        this.resources.loadIrregular(irrModelFile);
        this.resources.loadObservation(observationFile);
        this.resources.loadTransition(transitionFile);
        this.unitParser = new KoreanUnitParser();
    }

    private InputStream getResourceStream(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }

    public void analyzeTextFile(String inputFilename, String outputFilename, int thread) {
        try {
            List<String> lines = FileUtil.load2List(inputFilename);
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFilename));
            ArrayList<Future<KomoranResult>> komoranResultList = new ArrayList<Future<KomoranResult>>();
            ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(thread);
            for (String string : lines) {
                KomoranCallable komoranCallable = new KomoranCallable(this, string);
                komoranResultList.add(executor.submit(komoranCallable));
            }
            for (Future future : komoranResultList) {
                KomoranResult komoranResult = (KomoranResult)future.get();
                bw.write(komoranResult.getPlainText());
                bw.newLine();
            }
            bw.close();
            executor.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public KomoranResult analyze(String sentence) {
        List<LatticeNode> shortestPathList;
        FindContext<List<ScoredTag>> userDicFindContext = null;
        FindContext<List<ScoredTag>> observationFindContext = this.resources.getObservation().getTrieDictionary().newFindContext();
        FindContext<List<IrregularNode>> irregularFindContext = this.resources.getIrrTrie().getTrieDictionary().newFindContext();
        if (this.userDic != null) {
            userDicFindContext = this.userDic.getTrieDictionary().newFindContext();
        }
        sentence = sentence.replaceAll("[ ]+", " ").trim();
        ArrayList<LatticeNode> resultList = new ArrayList<LatticeNode>();
        Lattice lattice = new Lattice(this.resources);
        lattice.setUnitParser(this.unitParser);
        ContinuousSymbolInfo continuousSymbolInfo = new ContinuousSymbolInfo();
        String jasoUnits = this.unitParser.parse(sentence);
        List<Pair<Character, KoreanUnitParser.UnitType>> jasoUnitsWithType = this.unitParser.parseWithType(sentence);
        int length = jasoUnits.length();
        int prevStartIdx = 0;
        for (int i = 0; i < length; ++i) {
            int skipIdx = this.lookupFwd(lattice, jasoUnits, i);
            if (skipIdx != -1) {
                i = skipIdx - 1;
                continue;
            }
            if (jasoUnits.charAt(i) == ' ') {
                this.consumeContiniousSymbolParserBuffer(lattice, i, continuousSymbolInfo);
                this.bridgeToken(lattice, i, jasoUnits, prevStartIdx);
                prevStartIdx = i + 1;
            }
            this.continiousSymbolParsing(lattice, jasoUnits.charAt(i), i, continuousSymbolInfo);
            this.symbolParsing(lattice, jasoUnits.charAt(i), i);
            this.userDicParsing(lattice, userDicFindContext, jasoUnits.charAt(i), i);
            this.regularParsing(lattice, observationFindContext, jasoUnits.charAt(i), i);
            this.irregularParsing(lattice, irregularFindContext, jasoUnits.charAt(i), i);
            this.irregularExtends(lattice, jasoUnits.charAt(i), i);
        }
        this.consumeContiniousSymbolParserBuffer(lattice, jasoUnits, continuousSymbolInfo);
        lattice.setLastIdx(jasoUnits.length());
        boolean inserted = lattice.appendEndNode();
        if (!inserted) {
            double NAPenaltyScore = -10000.0;
            if (prevStartIdx != 0) {
                NAPenaltyScore += lattice.getNodeList(prevStartIdx).get(0).getScore();
            }
            String combinedWord = this.unitParser.combineWithType(jasoUnitsWithType.subList(prevStartIdx, jasoUnits.length()));
            LatticeNode latticeNode = new LatticeNode(prevStartIdx, jasoUnits.length(), new MorphTag(combinedWord, "NA", this.resources.getTable().getId("NA")), NAPenaltyScore);
            latticeNode.setPrevNodeIdx(0);
            lattice.appendNode(latticeNode);
            lattice.appendEndNode();
        }
        if ((shortestPathList = lattice.findPath()) == null) {
            resultList.add(new LatticeNode(0, jasoUnits.length(), new MorphTag(sentence, "NA", -1), -10000.0));
        } else {
            Collections.reverse(shortestPathList);
            resultList.addAll(shortestPathList);
        }
        return new KomoranResult(resultList, jasoUnits);
    }

    private void bridgeToken(Lattice lattice, int curIdx, String jasoUnits, int prevBeginSymbolIdx) {
        if (lattice.put(curIdx, curIdx + 1, "<end>", "<end>", this.resources.getTable().getId("<end>"), 0.0)) {
            return;
        }
        LatticeNode naLatticeNode = lattice.makeNode(prevBeginSymbolIdx, curIdx, jasoUnits.substring(prevBeginSymbolIdx, curIdx), "NA", this.resources.getTable().getId("NA"), -10000.0, 0);
        int naNodeIndex = lattice.appendNode(naLatticeNode);
        LatticeNode endLatticeNode = lattice.makeNode(curIdx, curIdx + 1, "<end>", "<end>", this.resources.getTable().getId("<end>"), 0.0, naNodeIndex);
        lattice.appendNode(endLatticeNode);
    }

    private boolean symbolParsing(Lattice lattice, char jaso, int idx) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(jaso);
        if (Character.isDigit(jaso)) {
            return false;
        }
        if (unicodeBlock == Character.UnicodeBlock.BASIC_LATIN) {
            if (jaso >= 'A' && jaso <= 'Z' || jaso >= 'a' && jaso <= 'z') {
                return false;
            }
            if (this.resources.getObservation().getTrieDictionary().getValue("" + jaso) != null) {
                return false;
            }
            if (jaso == ' ') {
                return false;
            }
            lattice.put(idx, idx + 1, "" + jaso, "SW", this.resources.getTable().getId("SW"), -10000.0);
            return true;
        }
        if (unicodeBlock == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO || unicodeBlock == Character.UnicodeBlock.HANGUL_JAMO || unicodeBlock == Character.UnicodeBlock.HANGUL_JAMO_EXTENDED_A || unicodeBlock == Character.UnicodeBlock.HANGUL_JAMO_EXTENDED_B || unicodeBlock == Character.UnicodeBlock.HANGUL_SYLLABLES) {
            return false;
        }
        if (unicodeBlock == Character.UnicodeBlock.KATAKANA || unicodeBlock == Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS) {
            return false;
        }
        if (Character.UnicodeBlock.CJK_COMPATIBILITY.equals(unicodeBlock) || Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS.equals(unicodeBlock) || Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A.equals(unicodeBlock) || Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B.equals(unicodeBlock) || Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS.equals(unicodeBlock)) {
            return false;
        }
        lattice.put(idx, idx + 1, "" + jaso, "SW", this.resources.getTable().getId("SW"), -10000.0);
        return true;
    }

    private boolean userDicParsing(Lattice lattice, FindContext<List<ScoredTag>> userDicFindContext, char jaso, int curIndex) {
        Map<String, List<ScoredTag>> morphScoredTagsMap = this.getMorphScoredTagMapFromUserDic(userDicFindContext, jaso);
        if (morphScoredTagsMap == null) {
            return false;
        }
        Set<String> morphes = this.getMorphes(morphScoredTagsMap);
        for (String morph : morphes) {
            int beginIdx = curIndex - morph.length() + 1;
            int endIdx = curIndex + 1;
            List<ScoredTag> scoredTags = morphScoredTagsMap.get(morph);
            for (ScoredTag scoredTag : scoredTags) {
                this.insertLattice(lattice, beginIdx, endIdx, morph, scoredTag, scoredTag.getScore());
            }
        }
        return true;
    }

    private int lookupFwd(Lattice lattice, String token, int curIdx) {
        int wordEndIdx;
        String targetWord;
        List<Pair<String, String>> fwdResultList;
        if (this.fwd == null) {
            return -1;
        }
        if ((curIdx == 0 || token.charAt(curIdx - 1) == ' ') && (fwdResultList = this.fwd.get(targetWord = token.substring(curIdx, wordEndIdx = (wordEndIdx = token.indexOf(32, curIdx)) == -1 ? token.length() : wordEndIdx))) != null) {
            this.insertLatticeForFwd(lattice, curIdx, wordEndIdx, fwdResultList);
            return wordEndIdx;
        }
        return -1;
    }

    private void insertLatticeForFwd(Lattice lattice, int beginIdx, int endIdx, List<Pair<String, String>> fwdResultList) {
        lattice.put(beginIdx, endIdx, fwdResultList);
    }

    private void continiousSymbolParsing(Lattice lattice, char charAt, int i, ContinuousSymbolInfo continuousSymbolInfo) {
        String curPos = "";
        if (StringUtil.isEnglish(charAt)) {
            curPos = "SL";
        } else if (StringUtil.isNumeric(charAt)) {
            curPos = "SN";
        } else if (StringUtil.isChinese(charAt)) {
            curPos = "SH";
        } else if (StringUtil.isForeign(charAt)) {
            curPos = "SL";
        }
        if (curPos.equals(continuousSymbolInfo.getPrevPos())) {
            continuousSymbolInfo.setPrevMorph(continuousSymbolInfo.getPrevMorph() + charAt);
        } else {
            switch (continuousSymbolInfo.getPrevPos()) {
                case "SL": {
                    lattice.put(continuousSymbolInfo.getPrevBeginIdx(), i, continuousSymbolInfo.getPrevMorph(), continuousSymbolInfo.getPrevPos(), this.resources.getTable().getId(continuousSymbolInfo.getPrevPos()), -1.0);
                    break;
                }
                case "SN": {
                    lattice.put(continuousSymbolInfo.getPrevBeginIdx(), i, continuousSymbolInfo.getPrevMorph(), continuousSymbolInfo.getPrevPos(), this.resources.getTable().getId(continuousSymbolInfo.getPrevPos()), -1.0);
                    break;
                }
                case "SH": {
                    lattice.put(continuousSymbolInfo.getPrevBeginIdx(), i, continuousSymbolInfo.getPrevMorph(), continuousSymbolInfo.getPrevPos(), this.resources.getTable().getId(continuousSymbolInfo.getPrevPos()), -1.0);
                }
            }
            continuousSymbolInfo.setPrevBeginIdx(i);
            continuousSymbolInfo.setPrevMorph("" + charAt);
            continuousSymbolInfo.setPrevPos(curPos);
        }
    }

    private void consumeContiniousSymbolParserBuffer(Lattice lattice, String in, ContinuousSymbolInfo continuousSymbolInfo) {
        if (continuousSymbolInfo.getPrevPos().trim().length() != 0) {
            switch (continuousSymbolInfo.getPrevPos()) {
                case "SL": {
                    lattice.put(continuousSymbolInfo.getPrevBeginIdx(), in.length(), continuousSymbolInfo.getPrevMorph(), continuousSymbolInfo.getPrevPos(), this.resources.getTable().getId(continuousSymbolInfo.getPrevPos()), -1.0);
                    break;
                }
                case "SH": {
                    lattice.put(continuousSymbolInfo.getPrevBeginIdx(), in.length(), continuousSymbolInfo.getPrevMorph(), continuousSymbolInfo.getPrevPos(), this.resources.getTable().getId(continuousSymbolInfo.getPrevPos()), -1.0);
                    break;
                }
                case "SN": {
                    lattice.put(continuousSymbolInfo.getPrevBeginIdx(), in.length(), continuousSymbolInfo.getPrevMorph(), continuousSymbolInfo.getPrevPos(), this.resources.getTable().getId(continuousSymbolInfo.getPrevPos()), -1.0);
                }
            }
        }
    }

    private void consumeContiniousSymbolParserBuffer(Lattice lattice, int endIdx, ContinuousSymbolInfo continuousSymbolInfo) {
        if (continuousSymbolInfo.getPrevPos().trim().length() != 0) {
            switch (continuousSymbolInfo.getPrevPos()) {
                case "SL": {
                    lattice.put(continuousSymbolInfo.getPrevBeginIdx(), endIdx, continuousSymbolInfo.getPrevMorph(), continuousSymbolInfo.getPrevPos(), this.resources.getTable().getId(continuousSymbolInfo.getPrevPos()), -1.0);
                    break;
                }
                case "SH": {
                    lattice.put(continuousSymbolInfo.getPrevBeginIdx(), endIdx, continuousSymbolInfo.getPrevMorph(), continuousSymbolInfo.getPrevPos(), this.resources.getTable().getId(continuousSymbolInfo.getPrevPos()), -1.0);
                    break;
                }
                case "SN": {
                    lattice.put(continuousSymbolInfo.getPrevBeginIdx(), endIdx, continuousSymbolInfo.getPrevMorph(), continuousSymbolInfo.getPrevPos(), this.resources.getTable().getId(continuousSymbolInfo.getPrevPos()), -1.0);
                }
            }
        }
    }

    private void irregularExtends(Lattice lattice, char jaso, int curIndex) {
        List<LatticeNode> prevLatticeNodes = lattice.getNodeList(curIndex);
        if (prevLatticeNodes != null) {
            HashSet<LatticeNode> extendedIrrNodeList = new HashSet<LatticeNode>();
            for (LatticeNode prevLatticeNode : prevLatticeNodes) {
                List<ScoredTag> lastScoredTags;
                if (prevLatticeNode.getMorphTag().getTagId() != -1) continue;
                String lastMorph = prevLatticeNode.getMorphTag().getMorph();
                if (this.resources.getObservation().getTrieDictionary().hasChild((lastMorph + jaso).toCharArray())) {
                    LatticeNode extendedIrregularNode = new LatticeNode();
                    extendedIrregularNode.setBeginIdx(prevLatticeNode.getBeginIdx());
                    extendedIrregularNode.setEndIdx(curIndex + 1);
                    extendedIrregularNode.setMorphTag(new MorphTag(prevLatticeNode.getMorphTag().getMorph() + jaso, "IRR", -1));
                    extendedIrregularNode.setPrevNodeIdx(prevLatticeNode.getPrevNodeIdx());
                    extendedIrregularNode.setScore(prevLatticeNode.getScore());
                    extendedIrrNodeList.add(extendedIrregularNode);
                }
                if ((lastScoredTags = this.resources.getObservation().getTrieDictionary().getValue(lastMorph + jaso)) == null) continue;
                for (ScoredTag scoredTag : lastScoredTags) {
                    lattice.put(prevLatticeNode.getBeginIdx(), curIndex + 1, prevLatticeNode.getMorphTag().getMorph() + jaso, scoredTag.getTag(), scoredTag.getTagId(), scoredTag.getScore());
                }
            }
            for (LatticeNode extendedIrrNode : extendedIrrNodeList) {
                lattice.appendNode(extendedIrrNode);
            }
        }
    }

    private boolean irregularParsing(Lattice lattice, FindContext<List<IrregularNode>> irregularFindContext, char jaso, int curIndex) {
        Map<String, List<IrregularNode>> morphIrrNodesMap = this.getIrregularNodes(irregularFindContext, jaso);
        if (morphIrrNodesMap == null) {
            return false;
        }
        Set<String> morphs = morphIrrNodesMap.keySet();
        for (String morph : morphs) {
            List<IrregularNode> irrNodes = morphIrrNodesMap.get(morph);
            int beginIdx = curIndex - morph.length() + 1;
            int endIdx = curIndex + 1;
            for (IrregularNode irregularNode : irrNodes) {
                this.insertLattice(lattice, beginIdx, endIdx, irregularNode);
            }
        }
        return true;
    }

    private void insertLattice(Lattice lattice, int beginIdx, int endIdx, IrregularNode irregularNode) {
        lattice.put(beginIdx, endIdx, irregularNode);
    }

    private void regularParsing(Lattice lattice, FindContext<List<ScoredTag>> observationFindContext, char jaso, int curIndex) {
        Map<String, List<ScoredTag>> morphScoredTagsMap = this.getMorphScoredTagsMap(observationFindContext, jaso);
        if (morphScoredTagsMap == null) {
            return;
        }
        Set<String> morphes = this.getMorphes(morphScoredTagsMap);
        for (String morph : morphes) {
            int beginIdx = curIndex - morph.length() + 1;
            int endIdx = curIndex + 1;
            List<ScoredTag> scoredTags = morphScoredTagsMap.get(morph);
            for (ScoredTag scoredTag : scoredTags) {
                lattice.put(beginIdx, endIdx, morph, scoredTag.getTag(), scoredTag.getTagId(), scoredTag.getScore());
                if (!scoredTag.getTag().equals("EC")) continue;
                lattice.put(beginIdx, endIdx, morph, "EF", this.resources.getTable().getId("EF"), scoredTag.getScore());
            }
        }
    }

    private Map<String, List<IrregularNode>> getIrregularNodes(FindContext<List<IrregularNode>> irregularFindContext, char jaso) {
        return this.resources.getIrrTrie().getTrieDictionary().get(irregularFindContext, jaso);
    }

    private void insertLattice(Lattice lattice, int beginIdx, int endIdx, String morph, Tag tag, double score) {
        lattice.put(beginIdx, endIdx, morph, tag.getTag(), tag.getTagId(), score);
    }

    private Set<String> getMorphes(Map<String, List<ScoredTag>> morphScoredTagMap) {
        return morphScoredTagMap.keySet();
    }

    private Map<String, List<ScoredTag>> getMorphScoredTagsMap(FindContext<List<ScoredTag>> observationFindContext, char jaso) {
        return this.resources.getObservation().getTrieDictionary().get(observationFindContext, jaso);
    }

    private Map<String, List<ScoredTag>> getMorphScoredTagMapFromUserDic(FindContext<List<ScoredTag>> userDicFindContext, char jaso) {
        if (this.userDic == null) {
            return null;
        }
        if (userDicFindContext == null) {
            userDicFindContext = this.userDic.getTrieDictionary().newFindContext();
        }
        return this.userDic.getTrieDictionary().get(userDicFindContext, jaso);
    }

    public void load(String modelPath) {
        this.resources.load(modelPath);
    }

    public void setFWDic(String filename) {
        try {
            String line;
            CorpusParser corpusParser = new CorpusParser();
            BufferedReader br = new BufferedReader(new FileReader(filename));
            this.fwd = new HashMap();
            while ((line = br.readLine()) != null) {
                String[] tmp = line.split("\t");
                if (tmp.length != 2 || tmp[0].charAt(0) == '#') {
                    tmp = null;
                    continue;
                }
                ProblemAnswerPair problemAnswerPair = corpusParser.parse(line);
                ArrayList<Pair<String, String>> convertAnswerList = new ArrayList<Pair<String, String>>();
                for (Pair<String, String> pair : problemAnswerPair.getAnswerList()) {
                    convertAnswerList.add(new Pair<String, String>(pair.getFirst(), pair.getSecond()));
                }
                this.fwd.put(this.unitParser.parse(problemAnswerPair.getProblem()), convertAnswerList);
                tmp = null;
                problemAnswerPair = null;
                convertAnswerList = null;
            }
            br.close();
            corpusParser = null;
            br = null;
            line = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setUserDic(String userDic) {
        try {
            this.userDic = new Observation();
            BufferedReader br = new BufferedReader(new FileReader(userDic));
            String line = null;
            while ((line = br.readLine()) != null) {
                String pos;
                String morph;
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                int lastIdx = line.lastIndexOf("\t");
                if (lastIdx == -1) {
                    morph = line.trim();
                    pos = "NNP";
                } else {
                    morph = line.substring(0, lastIdx);
                    pos = line.substring(lastIdx + 1);
                }
                this.userDic.put(morph, pos, this.resources.getTable().getId(pos), 0.0);
                line = null;
                morph = null;
                pos = null;
            }
            br.close();
            br = null;
            line = null;
            this.userDic.getTrieDictionary().buildFailLink();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

